/*
 * Copyright (C) 2002 Pascal Haakmat.
 */

#include "../modutils.h"

module modinfo;

module *
module_new() {
    MODULE_INIT(&modinfo, "Normalize");
    return &modinfo;
}

action_group *
module_execute(shell *shl, 
               int undo) {
    int32_t peak = 0, p;
    double factor;
    int t, map = shl->select_channel_map;
    AFframecount start = shl->select_start, end = shl->select_end;
    action_group *undo_ag = NULL;

    DEBUG("start: %ld, end: %ld\n", start, end);
    rwlock_rlock(&shl->sr->rwl);

    for(t = 0; t < snd_track_count(shl->sr); t++) {
        if((1 << t) & map) {
            p = find_peak(shl,
                          t,
                          start,
                          end);
            if(p > peak)
                peak = p;
        }
    }
    
    if(peak == 0) {
        gui_alert("Not enough memory.");
        rwlock_runlock(&shl->sr->rwl);
        return NULL;
     }

    if(gtk_main_iteration_do(FALSE)) {
        rwlock_runlock(&shl->sr->rwl);
        return NULL;
    }

    factor = (double)INT32_MAX / (double)peak;

    if(undo) 
        undo_ag = action_group_undo_create(shl,
                                           map, 
                                           start,
                                           end - start,
                                           start,
                                           end - start);

    DEBUG("undo: %d, undo_ag: %p, peak: %d, factor: %f\n", 
          undo, undo_ag, peak, factor);

    for(t = 0; t < snd_track_count(shl->sr); t++) 
        if((1 << t) & map) 
            amplify(shl,
                    t,
                    start,
                    end,
                    factor,
                    0);
    rwlock_runlock(&shl->sr->rwl);

    DEBUG("returning: %p\n", undo_ag);
    return undo_ag;
}
