/*
 * Copyright (C) 2002 Pascal Haakmat.
 */

#include <gnome.h>
#include <glade/glade.h>
#include "config.h"
#include "mem.h"
#include "action.h"
#include "gui.h"
#include "file.h"
#include "module.h"
#include "shell.h"

extern snd *clipboard;
extern shell *clipboard_shell;

GdkColormap *colormap;
GdkFont *grid_font;
GdkFont *info_font;
extern GdkColor point_play_col,
    point_rec_col,
    wave_col,
    sel_col,
    sel_bg_col,
    block_col,
    mark_col,
    wsel_col,
    zero_col,
    grid_col,
    grid_font_col,
    info_font_col,
    info_font_rec_col,
    info_font_play_col,
    slope_marker_cols[];

int 
gui_yes_no(const char *title,
           const char *format,
           ...) {
    va_list ap;
    char *message;
    int button;
    GtkWidget *dialog;

    message = (char *) mem_alloc(strlen(format) + 4096);

    if(!message) {
        FAIL("could not get memory to display error string. start of error: %s\n", format);
        return GUI_CANCEL;
    }
    
    va_start(ap, format);
    vsnprintf(message, strlen(format) + 4096, format, ap);
    va_end(ap);

    dialog = gnome_message_box_new(message,
                                   GNOME_MESSAGE_BOX_QUESTION,
                                   GNOME_STOCK_BUTTON_YES,
                                   GNOME_STOCK_BUTTON_NO,
                                   NULL);
    button = gnome_dialog_run_and_close(GNOME_DIALOG(dialog));
    free(message);

    return button;
}

void
gui_alert(const char *format,
          ...) {
    va_list ap;
    char message[4096];
    GtkWidget *dialog;

    va_start(ap, format);
    vsnprintf(message, 4096, format, ap);
    va_end(ap);

    dialog = gnome_message_box_new(message,
                                   GNOME_MESSAGE_BOX_WARNING,
                                   GNOME_STOCK_BUTTON_OK,
                                   NULL);
    gnome_dialog_run(GNOME_DIALOG(dialog));

}

void
gui_new_activate(GtkWidget *w,
                 gpointer user_data) {    
    action *a = ACTION_FILE_NEW_NEW();
    action_do(a);
}

void 
gui_open_activate(GtkWidget *w,
                  gpointer user_data) {

    action *a = ACTION_FILE_OPEN_NEW();
    action_do(a);
}


char *
disabled_bindings_for_clipboard[] = {
    "copy",
    "cut",
    "paste",
    NULL
};

void 
gui_show_clipboard_activate(GtkMenuItem *menuitem,
                            gpointer user_data) {

    DEBUG("show_clipboard\n");
    if(clipboard_shell) {
        gdk_window_raise(gtk_widget_get_parent_window(GTK_WIDGET(clipboard_shell)));
    } else {
        clipboard_shell = shell_new();
        clipboard_shell->sr = clipboard;
        mixer_configure(clipboard_shell->mixer, 
                        MIN(OUTPUT_CHANNELS, clipboard_shell->sr->channels), 
                        clipboard_shell->sr->channels);
        shell_bindings_disable(clipboard_shell, disabled_bindings_for_clipboard);
        gtk_widget_show(GTK_WIDGET(clipboard_shell->appwindow));
        shell_status_default_set(clipboard_shell);
    }
}

void
gui_exit_activate(GtkWidget *w,
                  shell *shl) {
    action_do(ACTION_EXIT_NEW());
}


int 
gui_init(int argc, char *argv[]) {
    g_thread_init(NULL);
    gnome_init(NAME, VERSION, argc, argv);
    glade_gnome_init();

    colormap = gdk_colormap_get_system();
    gdk_colormap_alloc_color(colormap, &wave_col, FALSE, TRUE);
    gdk_colormap_alloc_color(colormap, &sel_col, FALSE, TRUE);
    gdk_colormap_alloc_color(colormap, &sel_bg_col, FALSE, TRUE);
    gdk_colormap_alloc_color(colormap, &block_col, FALSE, TRUE);
    gdk_colormap_alloc_color(colormap, &point_play_col, FALSE, TRUE);
    gdk_colormap_alloc_color(colormap, &point_rec_col, FALSE, TRUE);
    gdk_colormap_alloc_color(colormap, &mark_col, FALSE, TRUE);
    gdk_colormap_alloc_color(colormap, &wsel_col, FALSE, TRUE);
    gdk_colormap_alloc_color(colormap, &zero_col, FALSE, TRUE);
    gdk_colormap_alloc_color(colormap, &grid_col, FALSE, TRUE);
    gdk_colormap_alloc_color(colormap, &grid_font_col, FALSE, TRUE);
    gdk_colormap_alloc_color(colormap, &info_font_col, FALSE, TRUE);
    gdk_colormap_alloc_color(colormap, &info_font_rec_col, FALSE, TRUE);
    gdk_colormap_alloc_color(colormap, &info_font_play_col, FALSE, TRUE);
    gdk_colormap_alloc_color(colormap, &(slope_marker_cols[0]), FALSE, TRUE);
    gdk_colormap_alloc_color(colormap, &(slope_marker_cols[1]), FALSE, TRUE);
    gdk_colormap_alloc_color(colormap, &(slope_marker_cols[2]), FALSE, TRUE);
    grid_font = gdk_font_load("fixed");
    info_font = gdk_font_load("fixed");
    return 0;
}

int gui_run(int argc, char *argv[]) {
    int i;
    clipboard = (snd *)snd_new();
    snd_name_set(clipboard, "clipboard");
    if(gui_init(argc, argv))
        return -1;
    
    //    clipboard_shell = shell_new();
    //    clipboard_shell->sr = clipboard;

    if(argc >= 2) {
        for(i = 1; i < argc; i++)
            gtk_init_add((GtkFunction)file_open, argv[i]);
    } else {
        if(file_new())
            return -1;
    }
    
    gtk_main();
    return 0;
}


/**
 * option_menu_index:
 * @optionmenu: a gtkoptionmenu
 * 
 * Tries to find out (in an ugly way) the selected
 * item in @optionmenu
 * 
 * Return value: the selected index
 * @author: Almer. S. Tigelaar.
 **/
int
option_menu_get_active (GtkOptionMenu *optionmenu)
{
    GtkMenu *menu;
    GtkMenuItem *selected;
    GList *iterator;
    int index = -1;
    int i = 0;

    g_return_val_if_fail (optionmenu != NULL, -1);
    
    menu = (GtkMenu *) gtk_option_menu_get_menu (optionmenu);
    iterator = GTK_MENU_SHELL (menu)->children;
    selected = (GtkMenuItem *) gtk_menu_get_active (menu);
    
    while (iterator) {
        
        if (iterator->data == selected) {
            
            index = i;
            break;
        }
        
        iterator = iterator->next;
        i++;
    }

    return index;
}


