/*
 * Copyright (C) 2002 Pascal Haakmat. 
 */

#include <string.h>
#include <math.h>
#include "config.h"
#include "mem.h"
#include "gui.h"
#include "module.h"

int main(int argc, char *argv[]) {
    int r;

    if(mem_init()) {
        FAIL("fatal error initializing private malloc library.\n");
        return -1;
    }

    if(module_init()) {
        FAIL("fatal error initializing modules.\n");
        return -1;
    }

    r = gui_run(argc, argv);

    module_exit();
    mem_exit();
    return r;

}
