/*
 * Copyright (C) 2002 Pascal Haakmat. 
 */

#ifndef MIXER_H
#define MIXER_H

#include <audiofile.h>
#include "config.h"

#define FB(fb, s, c, os, oc) (fb + (((oc) * (s)) + ((os) * ((c) * (s)))))
#define FB1(fb, s, os) (fb + (((os) * ((s)))))

typedef struct {
    int target_channels;
    int source_channels;
    float **mixtable;
} mixer;

mixer *
mixer_new(int target_channels,
          int source_channels);

void 
mixer_destroy(mixer *m);

void
mixer_configure(mixer *m,
                int target_channels,
                int source_channels);

void
mixer_mux(mixer *m,
          _frame_bits fb_target,
          _frame_bits *fb_sources,
          int frame_width,
          AFframecount frame_count);

void
mixer_demux(_frame_bits fb_target,
            _frame_bits fb_source,
            int channel,
            int channel_count,
            int frame_width,
            AFframecount frame_count);

void 
mixer_buffers_free(int tracks,
                   _frame_bits fb_downmix,
                   _frame_bits *fb_sources);

_frame_bits
mixer_buffers_alloc(int frame_width,
                    int tracks,
                    _frame_bits *fb_downmix,
                    _frame_bits *fb_sources,
                    AFframecount frame_count);

void 
mixer_dump(mixer *m);

#endif /* ! MIXER_H */
