/*
 * Copyright (C) 2002 Pascal Haakmat.
 */

#include "../modutils.h"

module modinfo;

module *
module_new() {
    MODULE_INIT(&modinfo, "Mix");
    return &modinfo;
}

action_group *
module_execute(shell *shl, 
               int undo) {
    int t, seltrks = 0, target_channel = -1, map = shl->select_channel_map;
    AFframecount start = shl->select_start, end = shl->select_end;
    action_group *undo_ag = NULL;

    DEBUG("start: %ld, end: %ld, channel_map: %d\n", 
          start, end, shl->select_channel_map);
    rwlock_rlock(&shl->sr->rwl);

    for(t = 0; t < shl->sr->channels; t++) {
        if((1 << t) & map) {
            seltrks++;
            if(target_channel == -1)
                target_channel = t;
        }
    }

    if(seltrks != 2) {
        gui_alert("Mix mixes the second of 2 selected tracks to the first " \
                  "selected track. You must select 2 tracks.");
        rwlock_runlock(&shl->sr->rwl);
        return NULL;
    }

    if(undo) 
        undo_ag = action_group_undo_create(shl,
                                           (1 << target_channel), 
                                           start,
                                           end - start,
                                           start,
                                           end - start);
    
    for(t = 0; t < shl->sr->channels; t++) 
        if(t != target_channel && ((1 << t) & map)) 
            mix(shl,
                target_channel,
                start,
                shl,
                t,
                start,
                end - start);
    
    rwlock_runlock(&shl->sr->rwl);
    
    return undo_ag;
}
