#include <audiofile.h>
#include "mem.h"
#include "module.h"
#include "shell.h"
#include "gui.h"
#include "action.h"

const char *
dirname(const char *s);

void
mix(shell *target_shell,
    int target_channel,
    AFframecount target_offset,
    shell *source_shell,
    int source_channel,
    AFframecount source_offset,
    AFframecount source_end_offset);

AFframecount
resample(shell *shl,
         int track,
         AFframecount start_offset,
         AFframecount end_offset,
         double factor);

void
reverse(shell *shl,
        int track,
        AFframecount start_offset,
        AFframecount end_offset);

void
amplify(shell *shl,
        int track,
        AFframecount start_offset,
        AFframecount end_offset,
        double factor,
        double slope);

int32_t
find_peak(shell *shl,
          int track,
          AFframecount start_offset,
          AFframecount end_offset);

action_group *
fade(shell *shl, 
     int undo,
     double factor,
     double slope);

AFframecount
find_zero(shell *shl,
          int track,
          AFframecount start_offset,
          AFframecount end_offset);
