/*
 * Copyright 2002 Pascal Haakmat
 * 
 * An rwlock is a shared read/exclusive write lock.
 */

#include <pthread.h>
#include <errno.h>
#include "config.h"
#include "rwlock.h"

void
rwlock_wlock(rwlock *rwl) {
    pthread_mutex_lock(&rwl->wlock);
    pthread_mutex_lock(&rwl->rlock);
    while(rwl->rcount) 
        pthread_cond_wait(&rwl->rcond, &rwl->rlock);
    pthread_mutex_unlock(&rwl->rlock);
}

void
rwlock_wunlock(rwlock *rwl) {
    pthread_mutex_unlock(&rwl->wlock);
}

void
rwlock_rlock(rwlock *rwl) {
    pthread_mutex_lock(&rwl->wlock);
    pthread_mutex_lock(&rwl->rlock);
    rwl->rcount++;
    pthread_mutex_unlock(&rwl->rlock);
    pthread_mutex_unlock(&rwl->wlock);
}

void
rwlock_runlock(rwlock *rwl) {
    pthread_mutex_lock(&rwl->rlock);
    rwl->rcount--;
    pthread_cond_broadcast(&rwl->rcond);
    pthread_mutex_unlock(&rwl->rlock);
}

void
rwlock_init(rwlock *rwl) {
    pthread_mutexattr_t attr;
    rwl->rcount = 0;
    pthread_mutexattr_init(&attr);
    pthread_mutexattr_setkind_np(&attr, PTHREAD_MUTEX_RECURSIVE_NP);
    pthread_mutex_init(&rwl->wlock, &attr);
    pthread_mutex_init(&rwl->rlock, &attr);
    pthread_cond_init(&rwl->rcond, NULL);
}

void
rwlock_destroy(rwlock *rwl) {
    if(pthread_mutex_destroy(&rwl->rlock) == EBUSY) 
        FAIL("unable to destroy read mutex, busy?\n");
    if(pthread_mutex_destroy(&rwl->wlock) == EBUSY) 
        FAIL("unable to destroy write mutex, busy?\n");
    pthread_cond_destroy(&rwl->rcond);
}
