#ifndef RWLOCK_H
#define RWLOCK_H

#include <pthread.h>

typedef struct {
    pthread_mutex_t rlock;
    pthread_mutex_t wlock;
    pthread_cond_t rcond;
    int rcount; /* number of readers */
} rwlock;

#include <pthread.h>
#include "rwlock.h"

void
rwlock_wlock(rwlock *rwl);

void
rwlock_rlock(rwlock *rwl);

void
rwlock_wunlock(rwlock *rwl);

void
rwlock_runlock(rwlock *rwl);

void
rwlock_init(rwlock *rwl);

void
rwlock_destroy(rwlock *rwl);

#endif /* ! RWLOCK_H */
