/* Copyright (C) 2002 Pascal Haakmat */

#ifndef ACTION_H
#define ACTION_H

#include <audiofile.h>
#include "snd.h"
#include "shell.h"

typedef enum {
    ACTION_FILE_NEW,
    ACTION_FILE_OPEN,
    ACTION_FILE_SAVE,
    ACTION_FILE_SAVE_AS,
    ACTION_FILE_CLOSE,
    ACTION_INSERT,
    ACTION_ERASE,
    ACTION_DELETE,
    ACTION_DELETE_ON_TRACK,
    ACTION_CUT,
    ACTION_PASTE,
    ACTION_PASTE_OVER,
    ACTION_PASTE_MIX,
    ACTION_PASTE_FIT,
    ACTION_SELECT,
    ACTION_COPY,
    ACTION_TRACKS_INSERT,
    ACTION_TRACKS_DELETE,
    ACTION_SELECTION_FIT,
    ACTION_SELECTION_TO_LOOP,
    ACTION_LOOP_TO_SELECTION,
    ACTION_PLAYER_PLAY,
    ACTION_PLAYER_STOP,
    ACTION_MODULE_OPEN,
    ACTION_MODULE_EXECUTE,
    ACTION_EXIT,
    ACTION_LAST
} action_id;

typedef struct _action {
    action_id id;
    shell *shl;
    snd *sr_source;
    snd *sr_target;
    int channel_map;
    AFframecount offset;
    AFframecount count;
    int undo;
    int suppress_redraw;
    int in_group;
} action;

typedef struct {
    int count;
    action *a[1];
} action_group;

typedef struct {
    char *name;
    action_group *(*func)(action *);
    int signature;
} action_desc;

typedef struct {
    int id;
    char defined;
    union {
        int int_val;
        char *str_val;
        float float_val;
    } v;
    action_group *undo;
} action_result;

#define HAS_TARGET       (1 <<  0)
#define HAS_SOURCE       (1 <<  1)
#define HAS_SHELL        (1 <<  2)
#define HAS_MAP          (1 <<  3)
#define HAS_OFFSET       (1 <<  4)
#define HAS_COUNT        (1 <<  5)
#define HAS_MODULE_INDEX (1 <<  6)
#define HAS_TRACK_INDEX  (1 <<  7)
#define HAS_SEL_SPEC     (HAS_MAP | HAS_OFFSET | HAS_COUNT)
#define NULL_SOURCE      (1 << 10)

#define DONT_UNDO 0
#define WITH_UNDO 1

#define ACTION_RESULT (&last_action_result)

#define ACTION_RESULT_RETURN_BOOL(id, v) \
(action_result_bool_set(&last_action_result, (id), (v)))

#define ACTION_RESULT_UNDO_SET(undo) \
(action_result_undo_set(&last_action_result, (undo)))

#define ACTION_RESULT_INIT(id) \
(action_result_init(&last_action_result, (id)))

#define ACTION_EXIT_NEW() \
action_new(ACTION_EXIT, NULL, NULL, NULL, -1, -1, -1, DONT_UNDO) 

#define ACTION_MODULE_EXECUTE_NEW(u, shl, module_index) \
action_new(ACTION_MODULE_EXECUTE, shl, NULL, NULL, module_index, -1, -1, u) 

#define ACTION_MODULE_OPEN_NEW(u, shl, module_index) \
action_new(ACTION_MODULE_OPEN, shl, NULL, NULL, module_index, -1, -1, u) 

#define ACTION_PLAYER_PLAY_NEW(shl) \
action_new(ACTION_PLAYER_PLAY, shl, NULL, NULL, -1, -1, -1, DONT_UNDO) 

#define ACTION_PLAYER_STOP_NEW(shl) \
action_new(ACTION_PLAYER_STOP, shl, NULL, NULL, -1, -1, -1, DONT_UNDO) 

#define ACTION_LOOP_TO_SELECTION_NEW(shl) \
action_new(ACTION_LOOP_TO_SELECTION, shl, NULL, NULL, -1, -1, -1, DONT_UNDO) 

#define ACTION_SELECTION_TO_LOOP_NEW(shl) \
action_new(ACTION_SELECTION_TO_LOOP, shl, NULL, NULL, -1, -1, -1, DONT_UNDO) 

#define ACTION_SELECTION_FIT_NEW(shl) \
action_new(ACTION_SELECTION_FIT, shl, NULL, NULL, -1, -1, -1, DONT_UNDO) 

#define ACTION_FILE_OPEN_NEW() \
action_new(ACTION_FILE_OPEN, NULL, NULL, NULL, -1, -1, -1, DONT_UNDO) 

#define ACTION_FILE_NEW_NEW() \
action_new(ACTION_FILE_NEW, NULL, NULL, NULL, -1, -1, -1, DONT_UNDO) 

#define ACTION_FILE_SAVE_NEW(shl) \
action_new(ACTION_FILE_SAVE, shl, NULL, NULL, -1, -1, -1, DONT_UNDO) 

#define ACTION_FILE_SAVE_AS_NEW(shl) \
action_new(ACTION_FILE_SAVE_AS, shl, NULL, NULL, -1, -1, -1, DONT_UNDO) 

#define ACTION_FILE_CLOSE_NEW(shl) \
action_new(ACTION_FILE_CLOSE, shl, NULL, NULL, -1, -1, -1, DONT_UNDO) 

#define ACTION_TRACKS_DELETE_NEW(u, shl, sr, chmap) \
action_new(ACTION_TRACKS_DELETE, shl, sr, NULL, chmap, -1, -1, u) 

#define ACTION_TRACKS_INSERT_NEW(u, shl, sr, ins_sr, chmap) \
action_new(ACTION_TRACKS_INSERT, shl, sr, ins_sr, chmap, -1, -1, u) 

#define ACTION_COPY_NEW(u, shl, sr, chmap, off, count) \
action_new(ACTION_COPY, shl, sr, NULL, chmap, off, count, u) 

#define ACTION_SELECT_NEW(u, shl, sr, chmap, off, count) \
action_new(ACTION_SELECT, shl, sr, NULL, chmap, off, count, u) 

#define ACTION_PASTE_NEW(u, shl, sr, chmap, off, count) \
action_new(ACTION_PASTE, shl, sr, NULL, chmap, off, count, u) 

#define ACTION_PASTE_OVER_NEW(u, shl, sr, chmap, off, count) \
action_new(ACTION_PASTE_OVER, shl, sr, NULL, chmap, off, count, u) 

#define ACTION_PASTE_MIX_NEW(u, shl, sr, chmap, off, count) \
action_new(ACTION_PASTE_MIX, shl, sr, NULL, chmap, off, count, u) 

#define ACTION_PASTE_FIT_NEW(u, shl, sr, chmap, off, count) \
action_new(ACTION_PASTE_FIT, shl, sr, NULL, chmap, off, count, u) 

#define ACTION_CUT_NEW(u, shl, sr, chmap, off, count) \
action_new(ACTION_CUT, shl, sr, NULL, chmap, off, count, u)

#define ACTION_INSERT_NEW(u, sr, ins_sr, chmap, off) \
action_new(ACTION_INSERT, NULL, sr, ins_sr, chmap, off, -1, u)

#define ACTION_ERASE_NEW(u, shl, sr, chmap, off, count) \
action_new(ACTION_ERASE, shl, sr, NULL, chmap, off, count, u)

#define ACTION_DELETE_NEW(u, shl, sr, chmap, off, count) \
action_new(ACTION_DELETE, shl, sr, NULL, chmap, off, count, u)

/* FIXME: this action is needed because we cannot make per-track
   selections. */

#define ACTION_DELETE_ON_TRACK_NEW(u, shl, sr, track_index, off, count) \
action_new(ACTION_DELETE_ON_TRACK, shl, sr, NULL, track_index, off, count, u)

action *
action_new(action_id id,
           shell *shl,
           snd *sr_target,
           snd *sr_source,
           int channel_map,
           AFframecount offset,
           AFframecount count,
           int undo);

action_group *
action_group_new(int count, ...);

action_group *
action_group_new_empty(int count);
 
action_group *
action_group_append(action_group *ag,
                    action *a);

action_group *
action_group_undo_create(shell *shl,
                         int channel_map,
                         AFframecount frame_offset,
                         AFframecount frame_count,
                         AFframecount delete_frame_offset,
                         AFframecount delete_frame_count);

void
action_result_undo_set(action_result *ar,
                       action_group *undo);
 
action_result *
action_do(action *a);

void
action_group_do(action_group *ag);

void
action_group_destroy(action_group *ag);

void
action_destroy(action *a);

void
action_result_bool_set(action_result *ar,
                       action_id id,
                       gboolean b);

gboolean
action_result_as_bool(action_result *ar);

void
action_result_init(action_result *ar,
                   action_id id);

#endif
