/* 
 * Copyright (C) 2002 Pascal Haakmat 
 */

#ifndef CONFIG_H
#define CONFIG_H

#include <gdk/gdk.h>
#include <stdio.h>

extern FILE *stderr, *stdout;

#define NAME                       "gnusound"
#define VERSION                       "0.2.2"

#define LIBDIR                  "/usr/lib"
#define PRIMARY_GLADE_FILE      ("ui/" NAME ".glade")
#define SECONDARY_GLADE_FILE    (LIBDIR "/" NAME "/" NAME ".glade")
#define MIXER_LEVEL_FILE        (LIBDIR "/" NAME "/lvl.xpm")
#define MODULE_PATH             ("modules:~/." NAME "/modules:" LIBDIR "/" NAME "/modules:modules")

#define OUTPUT_CHANNELS                    2 /* should make this automatic/dynamic */
#define RECORD_DEVICE             "/dev/dsp"
#define PLAY_DEVICE               "/dev/dsp"
#define MAX_MODULES                       50
#define MAX_TRACKS                         8
#define DEFAULT_SAMPLE_RATE            44100
#define DEFAULT_SAMPLE_WIDTH               2 /* bytes */

/* Number of frames to feed to processors. */

#define EFFECT_BUF_SIZE                32768 /* frames */

/* The default number of frames per block. */

#define BLOCK_SIZE  (GRAPH_BITS_HRES * 4096) /* frames */

/* Number of frames to send to the audio device per mixer iteration.
   Small values = faster response, large values = fewer audio
   dropouts. */

#define PLAY_BUF_SIZE                   4096 /* in frames. */
#define LOAD_BUF_SIZE       (BLOCK_SIZE / 8)
#define SAVE_BUF_SIZE      (BLOCK_SIZE / 16)
#define MAX_BCACHE_ENTRIES                25

#define MIXER_LEVEL_WIDTH                 40 /* pixels */
#define MIXER_LEVEL_HEIGHT                 9 /* pixels */
#define MARKER_HANDLE_SIZE                 8 /* pixels */
#define GRAPH_BITS_VRES                  256 /* pixels */
#define GRAPH_BITS_HRES                  128 /* frames */
#define HRES_MIN                       0.125

/* Maximum scaling factor. Large scaling factors cause very slow
   redraw times and can actually lead to audio dropouts. You can
   increase GRAPH_BITS_HRES above to allow larger values here, but then
   you get worse performance at smaller scaling factors. */

#define HRES_MAX                       16384

/* How often to update the UI during playback/record. */

#define DRAW_DIV                           1

/* How many frames to move the player position to the right or to the
   left when scrubbing. */

#define SCRUB_AMOUNT                   32768 /* frames */

/* Whether to force conversion on playing signed 8 bit samples to
   unsigned 8 bit samples. For soundcards where AFMT_S8 doesn't
   work. */

#define SIGNED_INT8_TO_UNSIGNED_INT8_FLAG  1

/* This affects the number and size of the output buffers (fragments)
   in the soundcard driver. Larger/more fragments can mean less audio
   dropouts but longer delays. From the OSS handbook:
   
   "The argument to this call is an integer encoded as 0xMMMMSSSS (in
   hex). The 16 least significant bits determine the fragment
   size. [...] For example SSSS=0008 gives fragment size of 256 bytes
   (2^8). The minimum is 16 bytes (SSSS=4) and the maximum is
   total_buffer_size/2. Some devices or processor architectures may
   require larger fragments - in this case the requested fragment size
   is automatically increased. Large number of audio devices (the
   professional ones in particular) use fixed fragment size and it's
   possible that this ioctl call has no effect. The 16 most
   significant bits (MMMM) determine the maximum number of fragments."
   (oss.pdf, p. 98) */

#define DSP_FRAGS                 0x001a000a
#define DEBUG_FLAG                         0

typedef void *_frame_bits;
typedef short graph_bits_unit;
typedef struct {
    graph_bits_unit l;
    graph_bits_unit h;
} _graph_bits_t;
typedef _graph_bits_t *_graph_bits;

/* Many systems come with an old sys/soundcard.h which is missing a
   number of defines so they are defined here. */

#include <sys/soundcard.h>
#ifndef AFMT_S32_LE
#define AFMT_S32_LE              0x00001000
#endif
#ifndef AFMT_S32_BE
#define AFMT_S32_BE              0x00002000
#endif
#ifndef AFMT_S32_NE
#define AFMT_S32_NE              (AFMT_S16_NE == AFMT_S16_BE ? AFMT_S32_BE : AFMT_S32_LE)
#endif

#define INT8_MIN     (-128)
#define INT8_MAX     127

#define INT16_MIN      (-32768)
#define INT16_MAX      32767

#define INT32_MIN       (-INT_MAX - 1)
#define INT32_MAX       2147483647

#ifdef DEBUG_FLAG
#define DEBUG(fmt, args...) \
fprintf(stdout, "" __FUNCTION__ ":%d: " fmt , __LINE__ , ## args)
/*fprintf(stdout, "debug: "__FILE__ ":" __FUNCTION__ ":%d: " fmt , __LINE__ , ## args)*/
#else
#define DEBUG(fmt, args...)
#endif

#define FAIL(fmt, args...) \
fprintf(stderr, "FAIL : "__FILE__ ":" __FUNCTION__ ":%d: " fmt , __LINE__ , ## args)

#define INFO(fmt, args...) \
fprintf(stdout, fmt, ## args)

#endif /* ! CONFIG_H */
