/*
 * Copyright (C) 2002 Pascal Haakmat.
 */

#ifndef GRID_H
#define GRID_H

#include <audiofile.h>

enum grid_measurement {
    GRID_FRAMES,
    GRID_SECONDS,
    GRID_BEATS
};

struct grid {
    enum grid_measurement measurement;
    double units;
    double bpm;
    double rate;
    AFframecount gap;
};

void
grid_measurement_set(struct grid *g,
                     enum grid_measurement m);

void
grid_units_set(struct grid *g,
               double u);

void
grid_bpm_set(struct grid *g,
             double b);

void
grid_bpm_from_frames_set(struct grid *g,
                         AFframecount frame_count);

void
grid_rate_set(struct grid *g,
              double r);

void
grid_frames_to_bpm(struct grid *g,
                   AFframecount frame_count);

void
grid_format(struct grid *g,
            AFframecount frame_offset,
            char *s,
            int n);

#endif /* ! GRID_H */

