/*
 * Copyright (C) 2002 Pascal Haakmat.
 */

/* Module state. Every shell maintains an array of these structures to
 * track the state for every open module in the shell. It is the
 * responsibility of the module to set up the fields in its slot on
 * module_open().
 */

typedef struct _module_state {
    
    /* This flag specifies whether the module is open. The module should
       set this flag to true when module_open() succeeds and should unset it
       again when module_close() is invoked. */

    int is_open;

    /* Pointer to module specific state data. */

    void *data;

} mod_state;

