/*
 * Copyright (C) 2002 Pascal Haakmat.
 */

#include "../modutils.h"

module modinfo;

module *
module_new() {
    MODULE_INIT(&modinfo, "Auto Zero");
    return &modinfo;
}

action_group *
module_execute(shell *shl, 
               int undo) {
    AFframecount old_ss = shl->select_start,
        old_se = shl->select_end,
        old_sc = shl->select_channel_map,
        first = 0, last = 0;
    action_group *undo_ag = NULL;
    int t;

    rwlock_rlock(&shl->sr->rwl);

    for(t = 0; t < snd_track_count(shl->sr); t++) {
        if((1 << t) & shl->select_channel_map) {
            first = find_zero(shl,
                              t,
                              shl->select_start,
                              shl->select_end);
            last = find_zero(shl,
                             t,
                             shl->select_end,
                             shl->select_start);
        }
    }

    if(first && last) {
        shl->select_start = first;
        shl->select_end = last;
    }
    
    if(undo)
        undo_ag = action_group_new(1,
                                   ACTION_SELECT_NEW(DONT_UNDO,
                                                     shl,
                                                     shl->sr,
                                                     old_sc,
                                                     old_ss,
                                                     old_se - old_ss));
    
    rwlock_runlock(&shl->sr->rwl);

    return undo_ag;
}
