/* Copyright (C) 2002 Pascal Haakmat */

#ifndef SHELL_H
#define SHELL_H

#include <gnome.h>
#include <pthread.h>
#include <audiofile.h>
#include "snd.h"
#include "mixer.h"
#include "modstate.h"
#include "marker.h"
#include "grid.h"

#define SLOPE_ENABLED(track, type) \
  ((shl->markers[track]->marker_types_enabled & type) == type)
#define PIXEL_TO_FRAME(x) (shl->hadjust->value + ((x) * shl->hres))
#define LOOP_IS_ACTIVE(shl) ((shl)->loop && (shl)->loop_start != (shl)->loop_end)
#define DISTANCE(x, y) (((x) - (y)) < 0 ? -((x) - (y)) : ((x) - (y)))

#define DEBUG_FLAG_STEP_MODE   0x01
#define DEBUG_FLAG_DRAW_BLOCKS 0x02

typedef struct {
    char *widget_name;
    char *signal_name;
    GtkSignalFunc signal_func;
} signal_bindings;

typedef struct {
    GtkObject *object;
    int ref;
} action_bindings;

typedef struct {
    pthread_t player_thread;
    pthread_mutex_t player_running_lock;
    pthread_cond_t player_running_cond;
    int player_running;
    int player_cancel_honored;
    int player_cancel_requested;
    int play_audio_fd;
    int rec_audio_fd;
    int record_mode;
    int replace_mode;
    _frame_bits muxbuf;
    _frame_bits srcbufs[MAX_TRACKS];
    AFframecount player_pos;
    AFframecount undo_start_offset;
    AFframecount undo_end_offset;
    int undo_channel_map;
    snd *undo_sr;
} player;

struct properties {
    float sample_rate;
    int sample_width;
    GtkToggleButton *resample;
    GtkLabel *new_label;
    GtkLabel *cur_label;
    GnomeDialog *dialog;
};

typedef struct {
    snd *sr;
    GList *undo_stack;
    player player;
    action_bindings *bindings;

    struct grid grid;

    /* The id of the module that is currently being executed or -1 if
       none. */

    int active_module_id;

    /* This flag is set when the user requests that a module cancels
       the current operation (this flag only makes sense when
       active_module_id is not -1). */

    int module_cancel_requested;

    /* State for the modules in this shell. Every loaded module gets a
       slot in this array to store their state. */

    mod_state module_state[MAX_MODULES];

    /* Loop start and end. */

    AFframecount loop_start;
    AFframecount loop_end;

    /* Selection; select_channel_map is a bitfield specifying which
       channels are selected. */

    int select_channel_map;
    AFframecount select_start;
    AFframecount select_end;
    AFframecount select_pivot;
    AFframecount select_flex;

    /* Horizontal resolution, power of 2. E.g. 128 specifies a scale
       of 1:128, while 0.25 specifies 4:1 magnification. */

    float hres;

    /* Vertical resolution, e.g. 128 or 256. */

    int vres;

    /* Flags. */

    int loop;
    int has_changed;
    int has_name;
    int follow_playback;
    int draw_zero;
    int draw_envelope;
    int envelope_enabled;
    int show_grid;
    int snap_to_grid;
    int record_mode;
    int replace_mode;
    int debug_flags;

    /* Buffers. */

    _graph_bits graph_bits_buffer;
    GdkPixmap *pixmap;
    GdkPixmap *mixerpixmap;

    /* Properties dialog. */
    
    struct properties props;

    /* UI elements. */

    GnomeApp *appwindow;
    GnomeAppBar *appbar;
    GtkDrawingArea *canvas;
    GtkDrawingArea *infocanvas;
    GtkDrawingArea *mixercanvas;
    GtkAdjustment *hadjust;
    GtkAdjustment *vadjust;
    GtkRange *hscrollbar;
    GtkRange *vscrollbar;
    GtkHRuler *hruler;
    GtkProgress *progress;
    GtkSpinButton *gridunits;
    GtkSpinButton *gridbpm;
    GtkOptionMenu *gridmeasurement;
    GdkDrawable *drawable;
    GtkMenuItem *cancelmodule;
    GdkGC *gc;

    /* Need to keep track of mouse position over waveform. */

    gdouble last_mouse_x;
    gdouble last_mouse_y;

    /* Markers. */

    struct marker *marker_being_dragged;
    int marker_dragged_on_track;
    struct marker_list *markers[MAX_TRACKS];

    /* Mixer. */

    mixer *mixer;
    int target_channel_being_dragged;
    int source_channel_being_dragged;
    //    AFframecount prev_hadjust_value;
} shell;


shell *
shell_new();

void 
shell_cursor_set(shell *shl, 
                 GdkCursorType type);

char *
shell_path_strip(const char *p);

void
shell_status_default_set(shell *shl);

void
shell_status_push(shell *shl, 
                  const char *format, 
                  ...);

void
shell_status_pop(shell *shl);

void
shell_redraw(shell *shl);

void
shell_viewport_center(shell *shl, 
                      AFframecount start,
                      AFframecount end);

GtkObject *
shell_bindings_find(shell *shl,
                    const char *name);

void
shell_bindings_disable(shell *shl,
                       char *names[]);

#endif /* ! SHELL_H */
