/* Copyright (C) 2002 Pascal Haakmat */

#ifndef TRACK_H
#define TRACK_H

#include <glib.h>
#include "config.h"
#include "snd.h"
#include "cache.h"
#include "block.h"
#include "rwlock.h"
#include "blocklist.h"

typedef enum {

    /* DUMMY is filler to equalize values with snd_clone_method */

    CLONE_DUMMY1,
    CLONE_DUMMY2,
    CLONE_DATA
} track_clone_method;

typedef struct _track {

    /* Read/write lock. The track_* functions acquire this lock when
       necessary, but if you require atomicity across multiple track_*
       invocations, you can acquire this lock for reading/writing
       yourself. */

    rwlock rwl;
    int frame_width;
    float graph_hres;
    struct blocklist *bl;
} track;

void
track_compact(track *tr);

track *
track_new(int frame_width,
          AFframecount frame_count);

track *
track_clone(track *tr,
            track_clone_method method);

void
track_destroy(track *tr);

int
track_frame_buffer_put(track *tr,
                       _frame_bits frame_bits,
                       AFframecount frame_offset,
                       AFframecount frame_count);

AFframecount
track_int32_frame_buffer_get(track *tr,
                             int32_t *int32_frame_bits,
                             AFframecount frame_offset,
                             AFframecount frame_count);

int
track_int32_frame_buffer_put(track *tr,
                             int32_t *int32_frame_bits,
                             AFframecount frame_offset,
                             AFframecount frame_count);

int
track_int32_frame_buffer_replace(track *tr,
                                 int32_t *int32_frame_bits,
                                 AFframecount frame_offset,
                                 AFframecount frame_count);

AFframecount
track_frame_buffer_get(track *tr,
                       _frame_bits frame_bits,
                       AFframecount frame_offset,
                       AFframecount frame_count);

AFframecount
track_graph_buffer_get(track *tr, 
                       _graph_bits gbp,
                       AFframecount frame_offset,
                       AFframecount frame_count,
                       float hres);

GList *
track_delete(track *tr,
             AFframecount frame_offset,
             AFframecount frame_count);

int
track_insert(track *tr,
             GList *l,
             AFframecount frame_offset);

void
track_null_insert(track *tr,
                  AFframecount frame_offset,
                  AFframecount frame_count);

AFframecount
track_frame_count(track *tr);

#endif /* ! TRACK_H */
