/*
     Copyright (C) 2001 CodeFactory AB
     Copyright (C) 2001 Thomas Nyberg <thomas@codefactory.se>
 
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
 
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
 
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <sys/asoundlib.h>
#include <stdio.h>


#define MK_FMT(a, b) {SND_PCM_FMT_##a, b}
struct {
	int val;
	char *name;
} formats[] = {
	MK_FMT(S8, "S8"),
	MK_FMT(U8, "U8"),
	MK_FMT(S16_LE, "S16_LE"),
	MK_FMT(S16_BE, "S16_BE"),
	MK_FMT(U16_LE, "U16_LE"),
	MK_FMT(U16_BE, "U16_BE"),
	MK_FMT(S24_LE, "S24_LE"),
	MK_FMT(S24_BE, "S24_BE"),
	MK_FMT(U24_LE, "U24_LE"),
	MK_FMT(U24_BE, "U24_BE"),
	MK_FMT(S32_LE, "S32_LE"),
	MK_FMT(S32_BE, "S32_BE"),
	MK_FMT(U32_LE, "U32_LE"),
	MK_FMT(U32_BE, "U32_BE"),
	MK_FMT(FLOAT_LE, "FLOAT_LE"),
	MK_FMT(FLOAT_BE, "FLOAT_BE"),
	MK_FMT(FLOAT64_LE, "FLOAT64_LE"),
	MK_FMT(FLOAT64_BE, "FLOAT64_BE"),	
};

#define MK_RATE(a, b) {SND_PCM_RATE_##a, b}
struct {
	int val;
	char *name;
} rates[] = {
	MK_RATE(8000, "8000"),
	MK_RATE(11025, "11025"),
	MK_RATE(16000, "16000"),
	MK_RATE(22050, "22050"),
	MK_RATE(32000, "32000"),
	MK_RATE(44100, "44100"),
	MK_RATE(48000, "48000"),
	MK_RATE(88200, "88200"),
	MK_RATE(96000, "96000"),
	MK_RATE(176400, "176400"),
	MK_RATE(192000, "192000"),
};

#define NUM_FORMATS (sizeof(formats) / sizeof(formats[0]))
#define NUM_RATES (sizeof(rates) / sizeof(rates[0]))

int 
main(int argc, char **argv)
{
	int i, j, k, m;
	char *name;
	snd_ctl_t *ctrl_handle;
	int ret;
	struct snd_ctl_hw_info hw_info;
	snd_pcm_info_t pcm_info;
	snd_pcm_channel_info_t chan_info;
	snd_pcm_t *handle;

	for (i = 0;i < snd_cards();i++) {
		snd_card_get_longname(i, &name);
		
		printf("Longname: %s\n", name);
		snd_card_get_name(i, &name);
		printf("Shortname: %s\n", name);

		printf("Default pcm: %d\nDefault pcm-device: %d\n", 
		       snd_defaults_pcm_card(), snd_defaults_pcm_device());

		if ((ret = snd_ctl_open(&ctrl_handle, i))) {
			fprintf(stderr, "Error: %s\n", snd_strerror(ret));
			continue;
		}

		if ((ret = snd_ctl_hw_info(ctrl_handle, &hw_info))) {
			fprintf(stderr, "Error: %s\n", snd_strerror(ret));
			continue;
		}

		printf("Hardware dependent devices: %d\n", hw_info.hwdepdevs);
		printf("Pcmdevs: %d\n", hw_info.pcmdevs);
		
		for (j = 0;j < hw_info.pcmdevs;j++) {
			if ((ret = snd_ctl_pcm_info(ctrl_handle, j, &pcm_info))) {
				fprintf(stderr, "Error: %s\n", snd_strerror(ret));
				continue;
			}
			printf("PCM-dev-name: %s\n", pcm_info.name);

			printf("Supports:");
			if (pcm_info.flags & SND_PCM_INFO_PLAYBACK)
				printf(" playback");
			if (pcm_info.flags & SND_PCM_INFO_CAPTURE)
				printf(" capture");
			if (pcm_info.flags & SND_PCM_INFO_DUPLEX)
				printf(" full_duplex");
			printf("\n");

			printf("Number of playback-devices: %d\n", pcm_info.playback + 1);
			printf("Number of capture-devices: %d\n", pcm_info.capture + 1);

			snd_pcm_open(&handle, i, j, SND_PCM_OPEN_PLAYBACK);

			printf("Playback:\n");
			for (k = 0;k < pcm_info.playback + 1;k++) {
				if ((ret = snd_ctl_pcm_channel_info(ctrl_handle, i, SND_PCM_CHANNEL_PLAYBACK, k, &chan_info))) {
					fprintf(stderr, "Error: %s\n", snd_strerror(ret));
					continue;
				}

				printf("Subdevice(%d): %s\n", chan_info.subdevice, chan_info.subname);
				printf("Rate: %d-%dHz\n", chan_info.min_rate, chan_info.max_rate);
				printf("Channels: %d-%d\n", chan_info.min_voices, chan_info.max_voices);

				printf("Supports:");
				if (chan_info.flags & SND_PCM_CHNINFO_MMAP)
					printf(" mmap");
				if (chan_info.flags & SND_PCM_CHNINFO_STREAM)
					printf(" stream-mode");
				if (chan_info.flags & SND_PCM_CHNINFO_BLOCK)
					printf(" blockmode");
				printf("\n");
				printf("Formats:");
				for (m = 0;m < NUM_FORMATS;m++)
					if (chan_info.formats & formats[m].val)
						printf(" %s", formats[m].name);
				printf("\n");

				printf("Rates:");
				for (m = 0;m < NUM_RATES;m++)
					if (chan_info.rates & rates[m].val)
						printf(" %s", rates[m].name);
				printf("\n");
			}
			snd_pcm_close(handle);

			snd_pcm_open(&handle, i, j, SND_PCM_OPEN_CAPTURE);
			printf("Capture:\n");
			for (k = 0;k < pcm_info.capture + 1;k++) {
				if ((ret = snd_ctl_pcm_channel_info(ctrl_handle, i, SND_PCM_CHANNEL_CAPTURE, k, &chan_info))) {
					fprintf(stderr, "Error: %s\n", snd_strerror(ret));
					continue;
				}

				printf("Subdevice(%d): %s\n", chan_info.subdevice, chan_info.subname);
				printf("Rate: %d-%dHz\n", chan_info.min_rate, chan_info.max_rate);
				printf("Channels: %d-%d\n", chan_info.min_voices, chan_info.max_voices);
				printf("Formats: %d\n", chan_info.formats);
				printf("Buffersize: %d\n", chan_info.buffer_size);
				printf("Supports:");
				if (chan_info.flags & SND_PCM_CHNINFO_MMAP)
					printf(" mmap");
				if (chan_info.flags & SND_PCM_CHNINFO_STREAM)
					printf(" stream-mode");
				if (chan_info.flags & SND_PCM_CHNINFO_BLOCK)
					printf(" blockmode");
				printf("\n");
				printf("Formats:");
				for (m = 0;m < NUM_FORMATS;m++)
					if (chan_info.formats & formats[m].val)
						printf(" %s", formats[m].name);
				printf("\n");
				printf("Rates:");
				for (m = 0;m < NUM_RATES;m++)
					if (chan_info.rates & rates[m].val)
						printf(" %s", rates[m].name);
				printf("\n");
			}
			snd_pcm_close(handle);
		}
	}


	return 0;
}



