/*
 * Mpeg Layer-2 audio decoder 
 * --------------------------
 * copyright (c) 1995 by Michael Hipp, All rights reserved. See also 'README'
 *
 */

#include <stdlib.h>
#include <math.h>
#include "mpg123.h"
#include "l2tables.h"

#define MAX(a,b) (((a) > (b)) ? (a) : (b))

void II_step_one(struct mpg123_frame *fr,unsigned int *bit_alloc,
                 int *scale) {
    int stereo = fr->stereo-1;
    int sblimit = fr->II_sblimit;
    int jsbound = fr->jsbound;
    int sblimit2 = fr->II_sblimit<<stereo;
    struct al_table *alloc1 = fr->alloc;
    int i;
    static unsigned int scfsi_buf[64];
    unsigned int *scfsi,*bita;
    int sc,step;

    bita = bit_alloc;
    if(stereo)
    {
      for (i=jsbound;i;i--,alloc1+=(1<<step))
      {
	step = alloc1->bits;
        *bita++ = (char) gst_getbitsn(&fr->gb,step);
        *bita++ = (char) gst_getbitsn(&fr->gb,step);
      }
      for (i=sblimit-jsbound;i;i--,alloc1+=(1<<step))
      {
	step = alloc1->bits;
        bita[0] = (char) gst_getbitsn(&fr->gb,step);
        bita[1] = bita[0];
        bita+=2;
      }
      bita = bit_alloc;
      scfsi=scfsi_buf;
      for (i=sblimit2;i;i--)
        if (*bita++)
          *scfsi++ = (char) gst_getbits2(&fr->gb);
    }
    else /* mono */
    {
      for (i=sblimit;i;i--,alloc1+=(1<<step)) {
        step = alloc1->bits;
        *bita++ = (char) gst_getbitsn(&fr->gb,step);
      }
      bita = bit_alloc;
      scfsi=scfsi_buf;
      for (i=sblimit;i;i--)
        if (*bita++)
          *scfsi++ = (char) gst_getbits2(&fr->gb);
    }

    bita = bit_alloc;
    scfsi=scfsi_buf;
    for (i=sblimit2;i;i--) 
      if (*bita++)
        switch (*scfsi++) 
        {
          case 0: 
                *scale++ = gst_getbits6(&fr->gb);
                *scale++ = gst_getbits6(&fr->gb);
                *scale++ = gst_getbits6(&fr->gb);
                break;
          case 1 : 
                *scale++ = sc = gst_getbits6(&fr->gb);
                *scale++ = sc;
                *scale++ = gst_getbits6(&fr->gb);
                break;
          case 2: 
                *scale++ = sc = gst_getbits6(&fr->gb);
                *scale++ = sc;
                *scale++ = sc;
                break;
          default:              /* case 3 */
                *scale++ = gst_getbits6(&fr->gb);
                *scale++ = sc = gst_getbits6(&fr->gb);
                *scale++ = sc;
                break;
        }

}

void II_step_two(struct mpg123_frame *fr,unsigned int *bit_alloc,
                 double fraction[2][4][SBLIMIT],int *scale,int x1) {
    struct mpg123_layer1_tables *l1t= &(fr->decoder->l1_tables);
    int i,j,k,ba;
    int stereo = fr->stereo;
    int sblimit = fr->II_sblimit;
    int jsbound = fr->jsbound;
    struct al_table *alloc2,*alloc1 = fr->alloc;
    unsigned int *bita=bit_alloc;
    int d1,step;

    for (i=0;i<jsbound;i++,alloc1+=(1<<step))
    {
      step = alloc1->bits;
      for (j=0;j<stereo;j++)
      {
        if ( (ba=*bita++) ) 
        {
          k=(alloc2 = alloc1+ba)->bits;
          if( (d1=alloc2->d) < 0) 
          {
            double cm=l1t->muls[k][scale[x1]];
            int a = gst_getbitsn(&fr->gb,k);
            int b = gst_getbitsn(&fr->gb,k);
            int c = gst_getbitsn(&fr->gb,k);
//fprintf(stderr,"got %d,%d,%d with d1 %d and cm %f\n",a,b,c,d1,cm);
            fraction[j][0][i] = (double)(a + d1) * cm;
            fraction[j][1][i] = (double)(b + d1) * cm;
            fraction[j][2][i] = (double)(c + d1) * cm;
/*
            fraction[j][0][i] = ((double) ((int)getbits(&fr->gb,k) + d1)) * cm;
            fraction[j][1][i] = ((double) ((int)getbits(&fr->gb,k) + d1)) * cm;
            fraction[j][2][i] = ((double) ((int)getbits(&fr->gb,k) + d1)) * cm;
*/
          }        
          else 
          {
            static int *table[12];
            unsigned int idx,*tab,m=scale[x1];
            memset(table,0,sizeof(table));
            table[3] = l1t->grp_3tab;
            table[5] = l1t->grp_5tab;
            table[9] = l1t->grp_9tab;
            idx = (unsigned int) gst_getbitsn(&fr->gb,k);
            tab = (unsigned int *) (table[d1] + idx + idx + idx);
            fraction[j][0][i] = l1t->muls[*tab++][m];
            fraction[j][1][i] = l1t->muls[*tab++][m];
            fraction[j][2][i] = l1t->muls[*tab][m];
          }
          scale+=3;
        }
        else
          fraction[j][0][i] = fraction[j][1][i] = fraction[j][2][i] = 0.0;
//fprintf(stderr,"fraction[%d][x][%d] = [%f,%f,%f]\n",j,i,
//        fraction[j][0][i],fraction[j][1][i],fraction[j][2][i]);
      }
    }

    for (i=jsbound;i<sblimit;i++,alloc1+=(1<<step))
    {
      step = alloc1->bits;
      bita++;	/* channel 1 and channel 2 bitalloc are the same */
      if ( (ba=*bita++) )
      {
        k=(alloc2 = alloc1+ba)->bits;
        if( (d1=alloc2->d) < 0)
        {
          double cm;
          int a = gst_getbitsn(&fr->gb,k);
          int b = gst_getbitsn(&fr->gb,k);
          int c = gst_getbitsn(&fr->gb,k);
          cm=l1t->muls[k][scale[x1+3]];
//fprintf(stderr,"k is %d, x1+3 is %d, scale[x1+3] is %d, cm is %lf\n",
//        k,x1+3,scale[x1+3],cm);
//fprintf(stderr,"got %d,%d,%d with d1 %d and cm %f\n",a,b,c,d1,cm);
          fraction[1][0][i] = (fraction[0][0][i] = (double) (a + d1) ) * cm;
          fraction[1][1][i] = (fraction[0][1][i] = (double) (b + d1) ) * cm;
          fraction[1][2][i] = (fraction[0][2][i] = (double) (c + d1) ) * cm;
          cm=l1t->muls[k][scale[x1]];
          fraction[0][0][i] *= cm;
          fraction[0][1][i] *= cm;
          fraction[0][2][i] *= cm;
        }
        else
        {
          static int *table[12];
          unsigned int idx,*tab,m1,m2;
          memset(table,0,sizeof(table));
          table[3] = l1t->grp_3tab;
          table[5] = l1t->grp_5tab;
          table[9] = l1t->grp_9tab;
          m1 = scale[x1]; m2 = scale[x1+3];
          idx = (unsigned int) gst_getbitsn(&fr->gb,k);
//fprintf(stderr,"d1 is %d, idx is %d\n",d1,idx);
          tab = (unsigned int *) (table[d1] + idx + idx + idx);
//fprintf(stderr,"table is %p, tab is %p\n",table,tab);
          fraction[0][0][i] = l1t->muls[*tab][m1];
          fraction[0][1][i] = l1t->muls[*tab][m1];
          fraction[0][2][i] = l1t->muls[*tab][m1];
          fraction[1][0][i] = l1t->muls[*tab++][m2];
          fraction[1][1][i] = l1t->muls[*tab++][m2];
          fraction[1][2][i] = l1t->muls[*tab][m2];
        }
        scale+=6;
      }
      else {
        fraction[0][0][i] = fraction[0][1][i] = fraction[0][2][i] =
        fraction[1][0][i] = fraction[1][1][i] = fraction[1][2][i] = 0.0;
      }
//fprintf(stderr,"fraction[0][x][%d] = [%f,%f,%f]\n",i,
//        fraction[0][0][i],fraction[0][1][i],fraction[0][2][i]);
//fprintf(stderr,"fraction[1][x][%d] = [%f,%f,%f]\n",i,
//        fraction[1][0][i],fraction[1][1][i],fraction[1][2][i]);
/* 
   should we use individual scalefac for channel 2 or
   is the current way the right one , where we just copy channel 1 to
   channel 2 ?? 
   The current 'strange' thing is, that we throw away the scalefac
   values for the second channel ...!!
-> changed .. now we use the scalefac values of channel one !! 
*/
    }

    if(sblimit > (fr->down_sample_sblimit) )
      sblimit = fr->down_sample_sblimit;

    for(i=sblimit;i<SBLIMIT;i++)
      for (j=0;j<stereo;j++)
        fraction[j][0][i] = fraction[j][1][i] = fraction[j][2][i] = 0.0;

}

static void II_select_table(struct mpg123_frame *fr)
{
  static int translate[3][2][16] =
   { { { 0,2,2,2,2,2,2,0,0,0,1,1,1,1,1,0 } ,
       { 0,2,2,0,0,0,1,1,1,1,1,1,1,1,1,0 } } ,
     { { 0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0 } ,
       { 0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0 } } ,
     { { 0,3,3,3,3,3,3,0,0,0,1,1,1,1,1,0 } ,
       { 0,3,3,0,0,0,1,1,1,1,1,1,1,1,1,0 } } };

  int table,sblim;
  static struct al_table *tables[5] =
       { alloc_0, alloc_1, alloc_2, alloc_3 , alloc_4 };
  static int sblims[5] = { 27 , 30 , 8, 12 , 30 };

  if(fr->lsf)
    table = 4;
  else
    table = translate[fr->samplerate_index][2-fr->stereo][fr->bitrate_index];
  sblim = sblims[table];

  fr->alloc      = tables[table];
  fr->II_sblimit = sblim;
}


int mpg123_do_layer2(struct mpg123_frame *fr) {
  int clip=0;
  int i,j;
  int stereo = fr->stereo;
  double fraction[2][4][SBLIMIT]; /* pick_table clears unused subbands */
  unsigned int bit_alloc[64];
  int scale[192];
  int single = fr->single;
  int pcm_point = 0;
  //int k;
  //double max;

  II_select_table(fr);
  fr->jsbound = (fr->mode == MPG_MD_JOINT_STEREO) ?
     (fr->mode_ext<<2)+4 : fr->II_sblimit;

//  fprintf(stderr,"stereo is %d, single is %d\n",stereo,single);
  if(stereo == 1 || single == 3)
    single = 0;

  II_step_one(fr,bit_alloc, scale);

//max=0;
  for (i=0;i<SCALE_BLOCK;i++) 
  {
    II_step_two(fr,bit_alloc,fraction,scale,i>>2);
    for (j=0;j<3;j++) 
    {
//      for (k=0;k<SBLIMIT;k++)
//        max = max + fabs(fraction[0][j][k]) + fabs(fraction[1][j][k]);
//        max = MAX(max,MAX(fraction[0][j][k],fraction[1][j][k]));
      if(single >= 0)
      {
        clip += (fr->synth_mono)(fr,fraction[single][j],fr->outbuf,&pcm_point);
      }
      else {
          int p1 = pcm_point;
          clip += (fr->synth)(fr,fraction[0][j],0,fr->outbuf,&p1);
          clip += (fr->synth)(fr,fraction[1][j],1,fr->outbuf,&pcm_point);
      }
    }
  }

  fr->outlen = pcm_point;

//  fprintf(stderr,"fraction max is %f\n",max);
  return clip;
}
