#include <stdio.h>
#include <stdlib.h>
#include <glib.h>
#include "mpg123.h"

//#define DEBUG

struct mpg123_decoder *mpg123_init_decoder() {
  struct mpg123_decoder *de;

  // allocate the decoder struct
  de = malloc(sizeof(struct mpg123_decoder));
  memset(de,0,sizeof(struct mpg123_decoder));

  de->fr.bsspace = malloc(sizeof(struct mpg123_bufferspace));
  de->fr.bpfold=0;
  de->fr.bsnum=0;
  de->fr.bsbuf=de->fr.bsspace->buffer[1];

  de->fr.synth = mpg123_synth_1to1;
  de->fr.synth_mono = mpg123_synth_1to1_mono;
  de->fr.down_sample_sblimit = 32;

  // initialize some pointers
  de->fr.decoder = de;
  de->buffer = NULL;

  // set some defaults
  de->down_sample = 0;
  de->mono = 0;
  de->channels = -1;
  de->samplerate = -1;

  // initialize various tables
  mpg123_init_layer1(de);
  mpg123_init_layer3(de,SBLIMIT);
  mpg123_init_decode_tables(de,32768);

  // set up the getbits struct
  gst_getbits_init(&(de->fr.gb), NULL, NULL);

  return de;
}

void mpg123_destroy_decoder(struct mpg123_decoder *de) {
	free(de->fr.bsspace);
	free(de);
}

int mpg123_decode_frame(struct mpg123_decoder *de,
                        unsigned char *inbuf,long inlen,
                        unsigned char *outbuf,long *outlen) {
  struct mpg123_frame *fr = &(de->fr);
  int ret = 0;

  fr->inbuf = inbuf;
  fr->inlen = inlen;
  fr->outbuf = outbuf;
  fr->fsizeold = fr->framesize;

  mpg123_decode_header(fr,GULONG_FROM_BE(*((unsigned long *)inbuf)));

  fr->bsbufold = fr->bsbuf;
  fr->bsbuf = fr->bsspace->buffer[fr->bsnum]+512;
  fr->bsnum = (fr->bsnum + 1) & 1;

  memcpy(fr->bsbuf, inbuf+4, MIN(inlen, fr->bpf));

  gst_getbits_newbuf(&fr->gb, fr->bsbuf,inlen);
  //fprintf(stderr,"have %d byte frame in %p\n",fr->bpf, fr->bsbuf);
  switch (fr->layer) {
    case MPG_LAYER_3: mpg123_do_layer3(fr);break;
    case MPG_LAYER_2: mpg123_do_layer2(fr);break;
    case MPG_LAYER_1: mpg123_do_layer1(fr);break;
    default: break;
  }
  *outlen = fr->outlen;
  if (fr->samplerate != de->samplerate) {
    de->samplerate = fr->samplerate;
    ret = 1;
  }
  if (fr->stereo != de->channels) {
    de->channels = fr->stereo;
    ret = 1;
  }
  return ret;
}
