/*
 * mpg123 defines 
 * used source: musicout.h from mpegaudio package
 */

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <unistd.h>

#include <math.h>

//#define GST_GETBITS_INLINE
#include <libs/getbits/gstgetbits.h>
#include "config.h"


#define SKIP_JUNK 1

#define MAX_NAME_SIZE   81
#define SBLIMIT		32
#define SCALE_BLOCK	12
#define SSLIMIT		18

#define MPG_VER_1	0x3
#define MPG_VER_2	0x2
#define MPG_VER_25	0x0

#define MPG_LAYER_1	1
#define MPG_LAYER_2	2
#define MPG_LAYER_3	3

#define MPG_MD_STEREO		0
#define MPG_MD_JOINT_STEREO	1
#define MPG_MD_DUAL_CHANNEL	2
#define MPG_MD_MONO		3

/* Pre Shift fo 16 to 8 bit converter table */
#define AUSHIFT (3)

#define MAXFRAMESIZE 1792

typedef struct mpg123_decoder _mpg123_decoder;
typedef struct mpg123_frame _mpg123_frame;
//typedef unsigned char[2][MAXFRAMESIZE+512] BUFFERSPACE;
typedef struct mpg123_bufferspace _mpg123_bufferspace;

struct mpg123_bufferspace {
	unsigned char buffer[2][MAXFRAMESIZE+512];
};

// global tables
struct mpg123_decode_tables {
#ifdef USE_3DNOW
  double decwin[2*(512+32)];
  double cos64[32],cos32[16],cos16[8],cos8[4],cos4[2];
#else
  double decwin[512+32];
  double cos64[16],cos32[8],cos16[4],cos8[2],cos4[1];
#endif

  double *pnts[5];

  unsigned char *conv16to8_buf;
  unsigned char *conv16to8;
};

struct mpg123_layer1_tables {
  double muls[27][64];

  int grp_3tab[32 * 3];   /* used: 27 */
  int grp_5tab[128 * 3];  /* used: 125 */
  int grp_9tab[1024 * 3]; /* used: 729 */
};

struct mpg123_layer3_tables {
  double ispow[8207];
  double aa_ca[8], aa_cs[8];
  double COS1[12][6];    
  double win[4][36];   
  double win1[4][36]; 
  double gainpow2[256+118+4];
  double COS9[9];
  double COS6_1,COS6_2;
  double tfcos36[9];
  double tfcos12[3];
  double cos9[3],cos18[3];
  
  int mapbuf0[9][152];
  int mapbuf1[9][156];
  int mapbuf2[9][44];
  int *map[9][3];
  int *mapend[9][3];

  unsigned int n_slen2[512];	/* MPEG 2.0 slen for 'normal' mode */
  unsigned int i_slen2[256];	/* MPEG 2.0 slen for intensity stereo */

  double tan1_1[16], tan2_1[16], tan1_2[16], tan2_2[16];
  double pow1_1[2][16], pow2_1[2][16], pow1_2[2][16], pow2_2[2][16];

  int longLimit[9][23];
  int shortLimit[9][14];
};

struct al_table {
  short bits;
  short d;
};

struct mpg123_frame {
  _mpg123_decoder *decoder;

  unsigned char *inbuf;
  int inlen;
  unsigned char *outbuf;
  int outlen;

  //BUFFERSPACE *bsspace; /* MAXFRAMESIZE */
  _mpg123_bufferspace *bsspace;
  unsigned char *bsbuf;
  unsigned char *bsbufold;
  int bsnum;

  gst_getbits_t gb;

  int mpegver;
  int layer_index;
  int bitrate_index;
  int samplerate_index;
  int protection;
  int padding;
  int extension;
  int mode;
  int mode_ext;
  int copyright;
  int original;
  int emphasis;

  int layer;
  int bitrate;
  int samplerate;

  int mpeg25;
  int lsf;
  int stereo;
  int jsbound;
  int single;
  int II_sblimit;
  int down_sample_sblimit;
  int down_sample;
  int header_change;
  int ssize;
  int framesize;
  int fsizeold;

  int bpf;
  int bpfold;
  double tpf;

  int (*synth)(struct mpg123_frame *,double *,int,unsigned char *,int *);
  int (*synth_mono)(struct mpg123_frame *,double *,unsigned char *,int *);

  struct al_table *alloc;
};

struct mpg123_decoder {
  struct mpg123_decode_tables decode_tables;
  struct mpg123_layer1_tables l1_tables;
  struct mpg123_layer3_tables l3_tables;

  _mpg123_frame fr;

  unsigned char *buffer;

  // control vars, these specify what comes out (sorta)
  int mono;
  int down_sample;

  // state vars, these say what really is coming out
  int channels;
  int samplerate;
};

struct mpg123_gr_info_s {
  int scfsi;
  unsigned part2_3_length;
  unsigned big_values;  
  unsigned scalefac_compress;
  unsigned block_type;
  unsigned mixed_block_flag;  
  unsigned table_select[3];
  unsigned subblock_gain[3];
  unsigned maxband[3];
  unsigned maxbandl;
  unsigned maxb;
  unsigned region1start;
  unsigned region2start;    
  unsigned preflag;
  unsigned scalefac_scale;
  unsigned count1table_select;
  double *full_gain[3];
  double *pow2gain;
};

struct mpg123_III_sideinfo {
  unsigned main_data_begin;
  unsigned private_bits;
  struct {
    struct mpg123_gr_info_s gr[2];
  } ch[2];
};

/* ------ Declarations from "common.c" ------ */

struct mpg123_decoder *mpg123_init_decoder();

int mpg123_decode_frame(struct mpg123_decoder *de,
							          unsigned char *inbuf,long inlen,
							          unsigned char *outbuf,long *outlen);

int mpg123_decode_header(struct mpg123_frame *fr,unsigned long header);

extern void mpg123_init_layer1(struct mpg123_decoder *);
extern void mpg123_init_layer3(struct mpg123_decoder *,int);
extern void mpg123_init_decode_tables(struct mpg123_decoder *de,long scale);
extern void mpg123_init_conv16to8_table(void);

extern int mpg123_head_check(unsigned long);
extern int mpg123_do_layer1(struct mpg123_frame *fr);
extern int mpg123_do_layer2(struct mpg123_frame *fr);
extern int mpg123_do_layer3(struct mpg123_frame *fr);

extern void mpg123_rewindNbits(struct mpg123_frame *fr,int bits);
extern int mpg123_hsstell();
extern void mpg123_set_pointer(struct mpg123_frame *fr,long);
extern void mpg123_huffman_decoder(int, int *);
extern void mpg123_huffman_count1(int, int *);
extern int mpg123_get_songlen(struct mpg123_frame *fr, int no);

extern void mpg123_synth_ntom_set_step(long, long);

long mpg123_compute_bpf(struct mpg123_frame *fr);
long mpg123_bpf_from_header(unsigned long header);
double mpg123_compute_tpf(struct mpg123_frame *fr);

extern unsigned char *mpg123_conv16to8;
extern long mpg123_freqs[9];
extern double mpg123_muls[27][64];
double *mpg123_decwin;
extern double *mpg123_pnts[5];

void dct64(struct mpg123_decode_tables *dt,double *out0,double *out1,
								           double *samples);

#ifdef HAVE_CPU_I386
void dct64_486(int *a,int *b,double *samples);
int mpg123_synth_1to1_486(struct mpg123_frame *fr,double *bandPtr,
                int channel,unsigned char *out,int nb_blocks);
#endif

int mpg123_synth_1to1_pent(double *bandPtr,
                int channel,unsigned char *out);

int mpg123_synth_1to1(struct mpg123_frame *fr,double *bandPtr,int channel,
               unsigned char *out,int *pnt);
int mpg123_synth_1to1_mono(struct mpg123_frame *fr,double *bandPtr,
                    unsigned char *samples,int *pnt);
