/* Gnome-Streamer
 * Copyright (C) <1999> Erik Walthinsen <omega@cse.ogi.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#define PCM_BUFFER_SIZE		(1152*4)

#include <gstxa.h>


/* elementfactory information */
GstElementDetails gst_xa_details = {
  "XAudio mp3 decoder",
  "Filter/Decoder/Audio",
  "Uses XAudio library to decode mp3 streams",
  VERSION,
  "Erik Walthinsen <omega@cse.ogi.edu>",
  "(C) 1999",
};

GstTypeFactory mp3factory = {
  "audio/mpeg",
  ".mp3",
  NULL,
};

/* Xa signals and args */
enum {
  /* FILL ME */
  LAST_SIGNAL
};

enum {
  ARG_0,
  /* FILL ME */
};


static void gst_xa_class_init(GstXaClass *klass);
static void gst_xa_init(GstXa *xa);


static GstElementClass *parent_class = NULL;
static guint gst_xa_signals[LAST_SIGNAL] = { 0 };

GtkType
gst_xa_get_type(void) {
  static GtkType xa_type = 0;

  if (!xa_type) {
    static const GtkTypeInfo xa_info = {
      "GstXa",
      sizeof(GstXa),
      sizeof(GstXaClass),
      (GtkClassInitFunc)gst_xa_class_init,
      (GtkObjectInitFunc)gst_xa_init,
      (GtkArgSetFunc)NULL,
      (GtkArgGetFunc)NULL,
      (GtkClassInitFunc)NULL,
    };
    xa_type = gtk_type_unique(GST_TYPE_ELEMENT,&xa_info);
  }
  return xa_type;
}

static void
gst_xa_class_init(GstXaClass *klass) {
  GstElementClass *gstelement_class;

  gstelement_class = (GstElementClass*)klass;

  parent_class = gtk_type_class(GST_TYPE_ELEMENT);
}

static void gst_xa_init(GstXa *xa) {
  xa->sinkpad = gst_pad_new("sink",GST_PAD_SINK);
  gst_element_add_pad(GST_ELEMENT(xa),xa->sinkpad);
  gst_pad_set_chain_function(xa->sinkpad,gst_xa_chain);
  xa->srcpad = gst_pad_new("src",GST_PAD_SRC);
  gst_element_add_pad(GST_ELEMENT(xa),xa->srcpad);

  xa->sentmeta = FALSE;

  if (decoder_new(&xa->decoder) != XA_SUCCESS) {
    g_print("couldn't create decoder\n");
    return;
  }

  memory_input_module_register(&xa->input);
  decoder_input_module_register(xa->decoder, &xa->input);

  if (decoder_input_new(xa->decoder,NULL,XA_DECODER_INPUT_AUTOSELECT) !=
      XA_SUCCESS) { 
    g_print("couldn't create input\n");
    return;
  }
  if (decoder_input_open(xa->decoder) != XA_SUCCESS) {
    g_print("couldn't open input\n");
    return;
  }
}

GstElement *gst_xa_new(gchar *name) {
  GstElement *xa = GST_ELEMENT(gtk_type_new(GST_TYPE_XA));
  gst_element_set_name(GST_ELEMENT(xa),name);
  return xa;
}

void gst_xa_chain(GstPad *pad,GstBuffer *buf) {
  GstXa *xa;
  gchar *data;
  glong size;
  gint status;
  guchar *pcm_buffer;

  g_return_if_fail(pad != NULL);
  g_return_if_fail(GST_IS_PAD(pad));
  g_return_if_fail(buf != NULL);
//  g_return_if_fail(GST_IS_BUFFER(buf));

  xa = GST_XA(pad->parent);
  data = (guchar *)GST_BUFFER_DATA(buf);
  size = GST_BUFFER_SIZE(buf);

  /* feed the input buffer to the decoder */
  memory_input_feed(xa->decoder->input->device,GST_BUFFER_DATA(buf),
                    GST_BUFFER_SIZE(buf));

  gst_trace_add_entry(NULL,0,buf,"xa: processed buffer");
  gst_buffer_unref(buf);

  /* now try to extract all the frames from it */
  do {
    /* first create a buffer to store things in */
    pcm_buffer = (guchar *)malloc(PCM_BUFFER_SIZE);

    /* try to decode it */
    status = decoder_decode(xa->decoder,pcm_buffer);

    if (status == XA_SUCCESS) {
      GstBuffer *newbuf;
      MetaAudioRaw *meta;

      /* construct a new buffer around the decoded data */
      newbuf = GST_BUFFER(gst_buffer_new());
      g_return_if_fail(newbuf != NULL);

/*
      GST_BUFFER_META(newbuf) = NULL;
      if (xa->sentmeta == FALSE) {
        meta = (gpointer)malloc(sizeof(MetaAudioRaw));
        gst_trace_add_entry(NULL,0,meta,"xa: created meta\n");
        if (xa->decoder->output_buffer->bytes_per_sample == 1)
          meta->format = AFMT_U8;
        else if (xa->decoder->output_buffer->bytes_per_sample == 2)
          meta->format = AFMT_S16_LE;
        else
          meta->format = 0;
        meta->channels = xa->decoder->output_buffer->stereo + 1;
        meta->frequency = xa->decoder->output_buffer->sample_rate;
        GST_BUFFER_META(newbuf) = (gpointer)meta;
        xa->sentmeta = TRUE;
      }
*/

      GST_BUFFER_DATA(newbuf) = pcm_buffer;
      GST_BUFFER_SIZE(newbuf) = xa->decoder->output_buffer->size;

      gst_trace_add_entry(NULL,0,newbuf,"xa: built decoded buffer");

      /* and send it on its way */
      gst_pad_push(xa->srcpad,newbuf);
    } else
      g_free(pcm_buffer);
  } while ((status == XA_SUCCESS) || (status == XA_ERROR_INVALID_FRAME));
}


static gboolean
plugin_init (GModule *module, GstPlugin *plugin)
{
  GstElementFactory *factory;
  guint16 mp3type, rawtype;

  /* create an elementfactory for the xa element */
  factory = gst_elementfactory_new("xa",GST_TYPE_XA,
                                   &gst_xa_details);
  g_return_val_if_fail(factory != NULL, FALSE);
  gst_plugin_add_factory(plugin,factory);
  gst_info("xa: added 'xa' element\n");

  /* register the 'mp3' format */
  mp3type = gst_type_find_by_mime("audio/mp3");
  g_return_val_if_fail(mp3type != 0, FALSE);
  gst_type_add_sink(mp3type,factory);

  /* this filter outputs raw audio */
  rawtype = gst_type_find_by_mime("audio/raw");
  g_return_val_if_fail(rawtype != 0, FALSE);
  gst_type_add_src(rawtype,factory);

  return TRUE;
}

GstPluginDesc plugin_desc = {
  GST_VERSION_MAJOR,
  GST_VERSION_MINOR,
  "xa",
  plugin_init
};
