/* Gnome-Streamer
 * Copyright (C) <1999> Erik Walthinsen <omega@cse.ogi.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef __GST_XA_H__
#define __GST_XA_H__


#include <config.h>
#include <gst/gst.h>
#include <gst/meta/audioraw.h>


#include <xaudio/decoder.h>
#include <xaudio/memory_input.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GST_TYPE_XA \
  (gst_xa_get_type())
#define GST_XA(obj) \
  (GTK_CHECK_CAST((obj),GST_TYPE_XA,GstXa))
#define GST_XA_CLASS(klass) \
  (GTK_CHECK_CLASS_CAST((klass),GST_TYPE_XA,GstXa))
#define GST_IS_XA(obj) \
  (GTK_CHECK_TYPE((obj),GST_TYPE_XA))
#define GST_IS_XA_CLASS(obj) \
  (GTK_CHECK_CLASS_TYPE((klass),GST_TYPE_XA)))

typedef struct _GstXa GstXa;
typedef struct _GstXaClass GstXaClass;

struct _GstXa {
  GstElement element;

  GstPad *sinkpad,*srcpad;

  XA_DecoderInfo *decoder;
  XA_InputModule input;

  MetaAudioRaw meta;
  gboolean sentmeta;
};

struct _GstXaClass {
  GstElementClass parent_class;
};

GtkType gst_xa_get_type(void);
GstElement *gst_xa_new(gchar *name);
void gst_xa_chain(GstPad *pad,GstBuffer *buf);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GST_XA_H__ */
