/* Gnome-Streamer
 * Copyright (C) <1999> Erik Walthinsen <omega@cse.ogi.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef __GST_RTP_H__
#define __GST_RTP_H__

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <glib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netdb.h>
#include <fcntl.h>

#include <rtp/rtp-packet.h>
#include <rtp/rtcp-packet.h>
#include <rtp/rtp-audio.h>

struct rtp_sender_info {
 
  int send_sock;
  struct sockaddr_in send_addr;
  guint32 ssrc;
  guint16 seq;
  guint32 timestamp;
  gchar* dest_hostname;
  guint dest_port;
  guint32 packets_sent;
  guint32 octets_sent;
};

int
find_host(gchar *host_name, struct in_addr *address);

void
rtp_send(struct rtp_sender_info* sen,
	 gchar *buf, int nbytes, 
	 rtp_payload_t pt, guint32 nsamp);
void
rtp_client_connection(struct rtp_sender_info* sen);
void
rtcp_send(struct rtp_sender_info* sen);
int
rtp_connection_call(struct rtp_sender_info* sen,
		    gchar *hostname,
		    guint port);


#endif


