#ifndef __GST_XVIMAGE_H__
#define __GST_XVIMAGE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <glib.h>
#include <X11/Xlib.h>

#ifdef HAVE_LIBXV
# include <X11/extensions/Xv.h>
# include <X11/extensions/Xvlib.h>
#endif

#include "gstxwindow.h"

typedef struct _GstXvImage	      GstXvImage;
typedef guint64                       GstXvImageType;

#define GST_XVIMAGE(img)	(GstXvImage *)(img)
#define GST_XVIMAGE_DATA(img)	((img)->data)

struct _GstXvImage
{
  GstXWindow *window;
  GstXvImageType  type;
#ifdef HAVE_LIBXV
  XvImage *ximage;
#else
  gpointer ximage;
#endif
  gpointer x_shm_info;
  gint im_adaptor;
  gint im_port;
  gint im_format;
  gint width, height;
  guchar *data;
};

void 		gst_xvimage_init		(void);
gboolean 	gst_xvimage_check_xvideo	(void);

GstCaps* 	gst_xvimage_get_capslist	(void);

GstXvImage*  	gst_xvimage_new    		(GstXvImageType type,
						 GstXWindow *window,
				 		 gint width,
				 		 gint height);

void	   	gst_xvimage_destroy   		(GstXvImage *image);

void 		gst_xvimage_put 		(GstXWindow *window, GstXvImage *image);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GST_XVIMAGE_H__ */
