/* Gnome-Streamer
 * Copyright (C) <1999> Erik Walthinsen <omega@cse.ogi.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include "gstwindec.h"
#include "gstwinenc.h"

GST_PADTEMPLATE_FACTORY (sink_factory,
  "sink",
  GST_PAD_SINK,
  GST_PAD_ALWAYS,
  GST_CAPS_NEW (
    "wincodec_sink",
    "video/avi",
      "format",		GST_PROPS_STRING ("strf_vids")
  )
)


GST_PADTEMPLATE_FACTORY (src_factory,
  "src",
  GST_PAD_SRC,
  GST_PAD_ALWAYS,
  GST_CAPS_NEW (
    "wincodec_src",
    "video/raw",
      "format",    	GST_PROPS_LIST (
       	           	  GST_PROPS_FOURCC (GST_MAKE_FOURCC ('Y','U','Y','2')),
               	   	  GST_PROPS_FOURCC (GST_MAKE_FOURCC ('R','G','B',' '))
               	   	),
      "width",     	GST_PROPS_INT_RANGE (16, 4096),
      "height",    	GST_PROPS_INT_RANGE (16, 4096)
  )
)

/* elementfactory information */
extern GstElementDetails gst_windec_details;
extern GstElementDetails gst_winenc_details;

GstPadTemplate *wincodec_src_temp;
GstPadTemplate *wincodec_sink_temp;

static gboolean
plugin_init (GModule *module, GstPlugin *plugin)
{
  GstElementFactory *dec, *enc;

  /* create an elementfactory for the windec element */
  enc = gst_elementfactory_new("winenc",GST_TYPE_WINENC,
                                   &gst_winenc_details);
  g_return_val_if_fail(enc != NULL, FALSE); 
  gst_plugin_add_factory(plugin,enc);

  /* create an elementfactory for the windec element */
  dec = gst_elementfactory_new("windec",GST_TYPE_WINDEC,
                                   &gst_windec_details);
  g_return_val_if_fail(dec != NULL, FALSE); 

  wincodec_src_temp = GST_PADTEMPLATE_GET (src_factory);
  gst_elementfactory_add_padtemplate (dec, wincodec_src_temp);
  wincodec_sink_temp = GST_PADTEMPLATE_GET (sink_factory);
  gst_elementfactory_add_padtemplate (dec, wincodec_sink_temp);
  
  gst_plugin_add_factory(plugin,dec);

  return TRUE;
}

GstPluginDesc plugin_desc = {
  GST_VERSION_MAJOR,
  GST_VERSION_MINOR,
  "wincodec",
  plugin_init
};

