/* Gnome-Streamer
 * Copyright (C) <2001> Steve Baker <stevebaker_org@yahoo.co.uk>
 *
 * float2int.h
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef __GST_FLOAT2INT_H__
#define __GST_FLOAT2INT_H__


#include <config.h>
#include <gst/gst.h>
#include "intfloatconvert.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GST_TYPE_FLOAT2INT \
  (gst_float2int_get_type())
#define GST_FLOAT2INT(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_FLOAT2INT,GstFloat2Int))
#define GST_FLOAT2INT_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_FLOAT2INT,GstFloat2Int))
#define GST_IS_FLOAT2INT(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_FLOAT2INT))
#define GST_IS_FLOAT2INT_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_FLOAT2INT))

#define GST_FLOAT2INT_SINKPAD(list)   ((GstPad*)(list->data))

typedef struct _GstFloat2Int GstFloat2Int;
typedef struct _GstFloat2IntClass GstFloat2IntClass;

struct _GstFloat2Int {
  GstElement element;

  GstPad *srcpad;
  GSList *sinkpads;
  GstBuffer **buffers;
  
  gboolean trying_proxy_caps;
  
  gint channels,numsinkpads,numbuffers,minbuffersize;
  
  gint width;
  gint depth;
  gfloat intercept;
  gfloat slope;
};

struct _GstFloat2IntClass {
  GstElementClass parent_class;
};

GType gst_float2int_get_type(void);
gboolean gst_float2int_factory_init (GstPlugin *plugin);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GST_FLOAT2INT_H__ */
