/* Gnome-Streamer
 * Copyright (C) <1999> Erik Walthinsen <omega@cse.ogi.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef __GST_MPG123_H__
#define __GST_MPG123_H__


#include <config.h>
#include <gst/gst.h>

#include "mpg123.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GST_TYPE_MPG123 \
  (gst_mpg123_get_type())
#define GST_MPG123(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_MPG123,GstMpg123))
#define GST_MPG123_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_MPG123,GstMpg123))
#define GST_IS_MPG123(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_MPG123))
#define GST_IS_MPG123_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_MPG123))

typedef struct _GstMpg123 GstMpg123;
typedef struct _GstMpg123Class GstMpg123Class;

struct _GstMpg123 {
  GstElement element;

  gboolean in_flush;
  // the timestamp of the next frame
  guint64 next_time;
  // the interval between frames
  guint64 time_interval;

  /* pads */
  GstPad *sinkpad,*srcpad;

  /* state */
  struct mpg123_decoder *decoder;
};

struct _GstMpg123Class {
  GstElementClass parent_class;
};

GType gst_mpg123_get_type(void);


#define MPEGVER1 0x3
#define MPEGVER2 0x2
#define MPEGVER25 0x0

#define MPEGLAYER1 0x3
#define MPEGLAYER2 0x2
#define MPEGLAYER3 0x1


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GST_MPG123_H__ */
