/* 
 * Mpeg Layer-1 audio decoder 
 * --------------------------
 * copyright (c) 1995 by Michael Hipp, All rights reserved. See also 'README'
 * near unoptimzed ...
 *
 * may have a few bugs after last optimization ... 
 *
 */

#include <stdlib.h>
#include "mpg123.h"
//#include "huffman.h"

void mpg123_init_layer1(struct mpg123_decoder *de) {
  struct mpg123_layer1_tables *l1t= &(de->l1_tables);
  static double mulmul[27] = {
    0.0 , -2.0/3.0 , 2.0/3.0 ,
    2.0/7.0 , 2.0/15.0 , 2.0/31.0, 2.0/63.0 , 2.0/127.0 , 2.0/255.0 ,
    2.0/511.0 , 2.0/1023.0 , 2.0/2047.0 , 2.0/4095.0 , 2.0/8191.0 ,
    2.0/16383.0 , 2.0/32767.0 , 2.0/65535.0 ,
    -4.0/5.0 , -2.0/5.0 , 2.0/5.0, 4.0/5.0 ,
    -8.0/9.0 , -4.0/9.0 , -2.0/9.0 , 2.0/9.0 , 4.0/9.0 , 8.0/9.0 };
  static int base[3][9] = {
     { 1 , 0, 2 , } ,  
     { 17, 18, 0 , 19, 20 , } ,
     { 21, 1, 22, 23, 0, 24, 25, 2, 26 } };
  int i,j,k,l,len;
  double *table;
  static int tablen[3] = { 3 , 5 , 9 };
  static int *itable,*tables[3];

  memset(l1t->grp_3tab,0,32*3*sizeof(int));
  memset(l1t->grp_5tab,0,128*3*sizeof(int));
  memset(l1t->grp_9tab,0,1024*3*sizeof(int));

  tables[0] = l1t->grp_3tab;
  tables[1] = l1t->grp_5tab;
  tables[2] = l1t->grp_9tab;

  for(i=0;i<3;i++)
  {
    itable = tables[i];
    len = tablen[i];
    for(j=0;j<len;j++)
      for(k=0;k<len;k++)
        for(l=0;l<len;l++)
        {
          *itable++ = base[i][l];
          *itable++ = base[i][k];
          *itable++ = base[i][j];
        }
  }
  
  for(k=0;k<27;k++)
  {
    double m=mulmul[k];
    table = l1t->muls[k];
    for(j=3,i=0;i<63;i++,j--)
      *table++ = m * pow(2.0,(double) j / 3.0);
    *table++ = 0.0; 
  }
//  printf("mpg123: initialized layer1&2 tables\n");
}


void I_step_one(struct mpg123_frame *fr,unsigned int balloc[],
                unsigned int scale_index[2][SBLIMIT]) {
  unsigned int *ba=balloc;
  unsigned int *sca = (unsigned int *) scale_index;

  if(fr->stereo) {
    int i;
    int jsbound = fr->jsbound;
    for (i=0;i<jsbound;i++) { 
      *ba++ = gst_getbits4(&fr->gb);
      *ba++ = gst_getbits4(&fr->gb);
    }
    for (i=jsbound;i<SBLIMIT;i++)
      *ba++ = gst_getbits4(&fr->gb);

    ba = balloc;

    for (i=0;i<jsbound;i++) {
      if ((*ba++))
        *sca++ = gst_getbits6(&fr->gb);
      if ((*ba++))
        *sca++ = gst_getbits6(&fr->gb);
    }
    for (i=jsbound;i<SBLIMIT;i++)
      if ((*ba++)) {
        *sca++ =  gst_getbits6(&fr->gb);
        *sca++ =  gst_getbits6(&fr->gb);
      }
  }
  else {
    int i;
    for (i=0;i<SBLIMIT;i++)
      *ba++ = gst_getbits4(&fr->gb);
    ba = balloc;
    for (i=0;i<SBLIMIT;i++)
      if ((*ba++))
        *sca++ = gst_getbits6(&fr->gb);
  }
}

void I_step_two(struct mpg123_frame *fr,double fraction[2][SBLIMIT],
                unsigned int balloc[2*SBLIMIT],
                unsigned int scale_index[2][SBLIMIT]) {
  struct mpg123_layer1_tables *l1t= &(fr->decoder->l1_tables);
  int i,n;
  int smpb[2*SBLIMIT]; /* values: 0-65535 */
  int *sample;
  register unsigned int *ba;
  register unsigned int *sca = (unsigned int *) scale_index;

  if(fr->stereo) {
    int jsbound = fr->jsbound;
    register double *f0 = fraction[0];
    register double *f1 = fraction[1];
    ba = balloc;
    for (sample=smpb,i=0;i<jsbound;i++)  {
      if ((n = *ba++))
        *sample++ = gst_getbitsn(&fr->gb,n+1);
      if ((n = *ba++))
        *sample++ = gst_getbitsn(&fr->gb,n+1);
    }
    for (i=jsbound;i<SBLIMIT;i++) 
      if ((n = *ba++))
        *sample++ = gst_getbitsn(&fr->gb,n+1);

    ba = balloc;
    for (sample=smpb,i=0;i<jsbound;i++) {
      if((n=*ba++))
        *f0++ = (double)( ((-1)<<n) + (*sample++) + 1) *
l1t->muls[n+1][*sca++];
      else
        *f0++ = 0.0;
      if((n=*ba++))
        *f1++ = (double)( ((-1)<<n) + (*sample++) + 1) *
l1t->muls[n+1][*sca++];
      else
        *f1++ = 0.0;
    }
    for (i=jsbound;i<SBLIMIT;i++) {
      if ((n=*ba++)) {
        double samp = ( ((-1)<<n) + (*sample++) + 1);
        *f0++ = samp * l1t->muls[n+1][*sca++];
        *f1++ = samp * l1t->muls[n+1][*sca++];
      }
      else
        *f0++ = *f1++ = 0.0;
    }
    for(i=fr->down_sample_sblimit;i<32;i++)
      fraction[0][i] = fraction[1][i] = 0.0;
  }
  else {
    register double *f0 = fraction[0];
    ba = balloc;
    for (sample=smpb,i=0;i<SBLIMIT;i++)
      if ((n = *ba++))
        *sample++ = gst_getbitsn(&fr->gb,n+1);
    ba = balloc;
    for (sample=smpb,i=0;i<SBLIMIT;i++) {
      if((n=*ba++))
        *f0++ = (double)( ((-1)<<n) + (*sample++) + 1) *
l1t->muls[n+1][*sca++];
      else
        *f0++ = 0.0;
    }
    for(i=fr->down_sample_sblimit;i<32;i++)
      fraction[0][i] = 0.0;
  }
}

int mpg123_do_layer1(struct mpg123_frame *fr) {
  int clip=0;
  int i,stereo = fr->stereo;
  unsigned int balloc[2*SBLIMIT];
  unsigned int scale_index[2][SBLIMIT];
  double fraction[2][SBLIMIT];
  int single = fr->single;
  int pcm_point = 0;

//  fprintf(stderr,"in do_layer1\n");

  fr->jsbound = (fr->mode == MPG_MD_JOINT_STEREO) ? (fr->mode_ext<<2)+4 : 32;

  if(stereo == 1 || single == 3)
    single = 0;

  I_step_one(fr,balloc,scale_index);

  for (i=0;i<SCALE_BLOCK;i++)
  {
    I_step_two(fr,fraction,balloc,scale_index);

    if(single >= 0)
    {
      clip += (fr->synth_mono)(fr,(double *)fraction[single],fr->outbuf,&pcm_point);
    }
    else {
        int p1 = pcm_point;
        clip += (fr->synth)(fr,(double *)fraction[0],0,fr->outbuf,&p1);
        clip += (fr->synth)(fr,(double *)fraction[1],1,fr->outbuf,&pcm_point);
    }
  }

  fr->outlen = pcm_point;

  return clip;
}
