/* Gnome-Streamer
 * Copyright (C) <1999> Erik Walthinsen <omega@cse.ogi.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef __MPEG1PARSE_H__
#define __MPEG1PARSE_H__


#include <config.h>
#include <gst/gst.h>
#include <gst/gstclock.h>
#include <libs/getbits/gstgetbits.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


typedef struct _Mpeg1Meta Mpeg1Meta;

struct _Mpeg1Meta {
  guint16 packet_length;

  guint16 PES_scrambling_control:2;
  guint16 PES_priority:1;
  guint16 data_alignment_indicator:1;
  guint16 copyright:1;
  guint16 original_or_copy:1;
  guint16 PTS_DTS_flags:2;
  guint16 ESCR_flag:1;
  guint16 ES_rate_flag:1;
  guint16 DSM_trick_mode_flag:1;
  guint16 additional_copy_info_flag:1;
  guint16 CRC_flag:1;
  guint16 PES_extension_flag:1;

  guint8 PES_header_data_length;

  guint64 PTS;
  guint64 DTS;

  guint64 ESCR_base:33;
  guint64 ESCR_extension:9;

  guint32 ES_rate;

  guint8 trick_mode_control:3;
  union {
    struct {
      guint8 field_id:2;
      guint8 intra_slice_refresh:1;
      guint8 frequency_truncation:2;
    } fast;
    struct {
      guint8 field_rep_cntrl:5;
    } slow;
    struct {
      guint field_id:2;
    } freeze;
  } trick_mode;

  guint8 additional_copy_info;

  guint16 previous_packet_CRC;
};


#define GST_TYPE_MPEG1PARSE \
  (mpeg1parse_get_type())
#define GST_MPEG1PARSE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_MPEG1PARSE,Mpeg1Parse))
#define GST_MPEG1PARSE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_MPEG1PARSE,Mpeg1Parse))
#define GST_IS_MPEG1PARSE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_MPEG1PARSE))
#define GST_IS_MPEG1PARSE_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_MPEG1PARSE)))

typedef struct _Mpeg1Parse Mpeg1Parse;
typedef struct _Mpeg1Stream Mpeg1Stream;
typedef struct _Mpeg1ParseClass Mpeg1ParseClass;

#define MPEG2_PACKHEAD	0
#define MPEG2_SYSHEAD	1

struct _Mpeg1Stream {
	guchar stream_id;
	gint8 STD_buffer_bound_scale;
	gint16 STD_buffer_size_bound;
};

struct _Mpeg1Parse {
  GstElement element;

  GstPad *sinkpad,*srcpad;

  GstClock *clock;

  /* current parse state */
  gboolean have_sync;
  gint sync_zeros;
  guchar id;

  /* previous partial chunk and bytes remaining in it */
  GstBuffer *prevbuf;
  gboolean in_flush;

  gst_getbits_t gb;

  /* counters */
  gulong packs;

  /* pack header values */
  gboolean have_packhead;
  guint64 scr;
  gboolean sync;
  guint32 bit_rate;

  /* program stream header values */
  gboolean have_syshead;
  guint16 header_length;
  guint32 rate_bound;
  guint8 audio_bound;
  gboolean fixed;
  gboolean constrained;
  gboolean audio_lock;
  gboolean video_lock;
  guint8 video_bound;
  gboolean packet_rate_restriction;
  struct _Mpeg1Stream STD_buffer_info[48];

  guint64 last_pts;

  // stream output pads
  GstPad *private_1_pad[8];	// up to 8 ac3 audio tracks <grumble>
  GstPad *private_2_pad;
  GstPad *video_pad[16];
  gulong video_offset[16];
  gboolean video_need_flush[16];
  GstPad *audio_pad[32];
  gulong audio_offset[32];
  gboolean audio_need_flush[32];
};

struct _Mpeg1ParseClass {
  GstElementClass parent_class;
};

GType gst_mpeg1parse_get_type(void);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __MPEG1PARSE_H__ */
