/* Gnome-Streamer
 * Copyright (C) <1999> Erik Walthinsen <omega@cse.ogi.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef __AC3DEC_H__
#define __AC3DEC_H__


#include <config.h>
#include <gst/gst.h>

#include "ac3.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GST_TYPE_AC3DEC \
  (gst_ac3dec_get_type())
#define GST_AC3DEC(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_AC3DEC,Ac3Dec))
#define GST_AC3DEC_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_AC3DEC,Ac3Dec))
#define GST_IS_AC3DEC(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_AC3DEC))
#define GST_IS_AC3DEC_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_AC3DEC))

typedef struct _Ac3Dec Ac3Dec;
typedef struct _Ac3DecClass Ac3DecClass;

struct _Ac3Dec {
  GstElement element;

  /* pads */
  GstPad *sinkpad,*srcpad;

  ao_functions_t functions;
};

struct _Ac3DecClass {
  GstElementClass parent_class;
};



#define MPEGVER1 0x3
#define MPEGVER2 0x2
#define MPEGVER25 0x0

#define MPEGLAYER1 0x3
#define MPEGLAYER2 0x2
#define MPEGLAYER3 0x1


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __AC3DEC_H__ */
