/* Gnome-Streamer
 * Copyright (C) <1999> Erik Walthinsen <omega@cse.ogi.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef __MP2VIDEOPARSE_H__
#define __MP2VIDEOPARSE_H__


#include <config.h>
#include <gst/gst.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GST_TYPE_MP2VIDEOPARSE \
  (mp2videoparse_get_type())
#define GST_MP2VIDEOPARSE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_MP2VIDEOPARSE,Mp2VideoParse))
#define GST_MP2VIDEOPARSE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_MP2VIDEOPARSE,Mp2VideoParse))
#define GST_IS_MP2VIDEOPARSE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_MP2VIDEOPARSE))
#define GST_IS_MP2VIDEOPARSE_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_MP2VIDEOPARSE))

typedef struct _Mp2VideoParse Mp2VideoParse;
typedef struct _Mp2VideoParseClass Mp2VideoParseClass;

struct _Mp2VideoParse {
  GstElement element;

  GstPad *sinkpad,*srcpad;

  GstBuffer *partialbuf;	// previous buffer (if carryover)
  gulong next_buffer_offset;
  gboolean need_resync;
  gboolean in_flush;
  guint64 last_pts;
  gint picture_in_buffer;

};

struct _Mp2VideoParseClass {
  GstElementClass parent_class;
};

GType gst_mp2videoparse_get_type(void);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __MP2VIDEOPARSE_H__ */
