/*
    Copyright (C) 2001 CodeFactory AB
    Copyright (C) 2001 Thomas Nyberg <thomas@codefactory.se>
                            
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef __GST_ALSA_H__
#define __GST_ALSA_H__

#include <sys/asoundlib.h>
#include <linux/asound.h>
#include <gst/gst.h>
#include <glib.h>

/*
#define GST_ALSA(obj) G_TYPE_CHECK_INSTANCE_CAST(obj, GST_TYPE_ALSA, GstALSA)
#define GST_ALSA_CLASS(klass) G_TYPE_CHECK_CLASS_CAST(klass, GST_TYPE_ALSA, GstALSAClass)
#define GST_IS_ALSA(obj) G_TYPE_CHECK_INSTANCE_TYPE(obj, GST_TYPE_ALSA)
#define GST_IS_ALSA_CLASS(klass) G_TYPE_CHECK_CLASS_TYPE(klass, GST_TYPE_ALSA)
#define GST_TYPE_ALSA gst_alsa_get_type()
*/

#define GST_ALSA_VERSION "0.0.1"

#define ALSA_BUFFER_SIZE (4096) /* size of buffer for block-mode */
#define ALSA_QUEUE_SIZE (2 * 4096) /* size of buffer for stream-mode */
#define ALSA_SLEEP_DELAY 10 /* time to wait before trying again(in ms) */

#define GST_TYPE_ALSA_CHANNELS _gst_alsa_channels_get_type()
#define GST_TYPE_ALSA_FORMATS _gst_alsa_formats_get_type()

#ifdef ALSA_DEBUG
# define ALSA_ERROR(err_string) g_print("alsa: Error: %s at %s(%d)\n", err_string, __FUNCTION__, __LINE__)
# define ALSA_DEBUG_MSG(string) g_print("alsa: %s\n", string)
# define ALSA_DEBUG_PRINT(s...) g_print("alsa: "  ##s)
#else /* ALSA_DEBUG */
# define ALSA_ERROR(err_string)
# define ALSA_DEBUG_MSG(string)
# define ALSA_DEBUG_PRINT(s...)
#endif /* ALSA_DEBUG */

typedef struct _GstALSA GstALSA;
typedef struct _GstALSAClass GstALSAClass;
typedef struct _ALSACard ALSACard;
typedef struct _ALSACardCap ALSACardCap;

typedef void (*ALSACardFound)(gint card, gint dev, const gchar *name);

enum {
	GST_ALSA_OPEN = GST_ELEMENT_FLAG_LAST,
	GST_ALSA_FLAG_LAST = GST_ELEMENT_FLAG_LAST + 2,
};

struct _ALSACard {
	gint card;
	gint device;
	gint subdevice; /* not used */
	gint channel;
	gint mode;
};

struct _ALSACardCap {
	gint min_rate;
	gint max_rate;
	gint min_channels;
	gint max_channels;
	gint buffer_size;

	gint formats;

	gint mmap_support:1;
	gint stream_support:1;
	gint block_support:1;
};

struct _GstALSA {
	GstElement parent;

	GstPad *pad;
	GstClock *clock;

	ALSACard *card;
	ALSACardCap *cap;
	snd_pcm_t *handle;

	gchar *buffer;
	gint count;

	int format;
	int rate;
	int channels;

	int bytes_per_read;
	int cur_offset;
};

struct _GstALSAClass {
	GstElementClass parent_class;
};

void _gst_alsa_probe_cards(ALSACardFound playback_func, ALSACardFound capture_func);
ALSACardCap *_gst_alsa_probe_capabilities(const ALSACard *card);
GstCaps *_gst_alsa_create_caps(GstALSA *this);
GstPadNegotiateReturn _gst_alsa_negotiate(GstPad *pad, GstCaps **caps, gpointer *user_data);

void _gst_alsa_close_audio(GstALSA *this);
gboolean _gst_alsa_open_audio(GstALSA *this);

gint _gst_oss_format_to_alsa_format(gint format);
gint _gst_alsa_format_to_oss_format(gint format);
gboolean _gst_alsa_channel_prepare(GstALSA *this);

void _gst_alsa_flush(GstALSA *this);

GType _gst_alsa_channels_get_type(void);
GType _gst_alsa_formats_get_type(void);

#endif /* __ALSA_H__ */



