/* Gnome-Streamer
 * Copyright (C) <1999> Erik Walthinsen <omega@cse.ogi.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include <string.h>

//#define DEBUG_ENABLED
#include <audioscale.h>

/* elementfactory information */
static GstElementDetails audioscale_details = {
  "Audio scaler",
  "Filter/Audio/Scaler",
  "Resizes audio",
  VERSION,
  "Wim Taymans <wim.taymans@chello.be>",
  "(C) 2000",
};

/* Audioscale signals and args */
enum {
  /* FILL ME */
  LAST_SIGNAL
};

enum {
  ARG_0,
  ARG_FREQUENCY,
  /* FILL ME */
};



static void	gst_audioscale_class_init	(AudioscaleClass *klass);
static void	gst_audioscale_init		(Audioscale *audioscale);

static void	gst_audioscale_chain		(GstPad *pad, GstBuffer *buf);

static void	gst_audioscale_set_property		(GObject *object, guint prop_id, const GValue *value, GParamSpec *pspec);
static void	gst_audioscale_get_property		(GObject *object, guint prop_id, GValue *value, GParamSpec *pspec);

static GstElementClass *parent_class = NULL;
//static guint gst_audioscale_signals[LAST_SIGNAL] = { 0 };

GType
audioscale_get_type (void)
{
  static GType audioscale_type = 0;

  if (!audioscale_type) {
    static const GTypeInfo audioscale_info = {
      sizeof(AudioscaleClass),      NULL,
      NULL,
      (GClassInitFunc)gst_audioscale_class_init,
      NULL,
      NULL,
      sizeof(Audioscale),
      0,
      (GInstanceInitFunc)gst_audioscale_init,
    };
    audioscale_type = g_type_register_static(GST_TYPE_ELEMENT, "Audioscale", &audioscale_info, 0);
  }
  return audioscale_type;
}

static void
gst_audioscale_class_init (AudioscaleClass *klass)
{
  GObjectClass *gobject_class;
  GstElementClass *gstelement_class;

  gobject_class = (GObjectClass*)klass;
  gstelement_class = (GstElementClass*)klass;

  g_object_class_install_property(G_OBJECT_CLASS(klass), ARG_FREQUENCY,
    g_param_spec_int("frequency","frequency","frequency",
                     G_MININT,G_MAXINT,0,G_PARAM_READWRITE)); // CHECKME

  parent_class = g_type_class_ref(GST_TYPE_ELEMENT);

  gobject_class->set_property = gst_audioscale_set_property;
  gobject_class->get_property = gst_audioscale_get_property;

}

static void
gst_audioscale_init (Audioscale *audioscale)
{
  audioscale->sinkpad = gst_pad_new("sink",GST_PAD_SINK);
  gst_element_add_pad(GST_ELEMENT(audioscale),audioscale->sinkpad);
  gst_pad_set_chain_function(audioscale->sinkpad,gst_audioscale_chain);
  audioscale->srcpad = gst_pad_new("src",GST_PAD_SRC);
  gst_element_add_pad(GST_ELEMENT(audioscale),audioscale->srcpad);

  audioscale->targetfrequency = -1;
  audioscale->buffer = NULL;
  audioscale->buffersize = 0;
}


static void
gst_audioscale_chain (GstPad *pad, GstBuffer *buf)
{
  Audioscale *audioscale;
  guchar *data;
  gulong size;
  GstBuffer *outbuf;
  int i;
  int pos;

  g_return_if_fail(pad != NULL);
  g_return_if_fail(GST_IS_PAD(pad));
  g_return_if_fail(buf != NULL);

  audioscale = GST_AUDIOSCALE (gst_pad_get_parent (pad));
  data = GST_BUFFER_DATA(buf);
  size = GST_BUFFER_SIZE(buf);

  GST_DEBUG (0,"gst_audioscale_chain: got buffer of %ld bytes in '%s'\n",size,
		              gst_element_get_name (GST_ELEMENT (audioscale)));

  /* first deal with audio metadata */
  /*
  meta = gst_buffer_get_first_meta(buf);
  if (meta) {
    if (audioscale->format != ((MetaAudioRaw *)meta)->format ||
        audioscale->channels  != ((MetaAudioRaw *)meta)->channels ||
        audioscale->frequency != ((MetaAudioRaw *)meta)->frequency) {

      audioscale->format = ((MetaAudioRaw *)meta)->format;
      audioscale->channels  = ((MetaAudioRaw *)meta)->channels;
      audioscale->frequency = ((MetaAudioRaw *)meta)->frequency;

    }
  }
  */
  if (audioscale->buffer == NULL) {
    audioscale->buffer = g_malloc(size);
    memcpy(audioscale->buffer, data, size);
    audioscale->buffersize = size;
  }
  else {
    audioscale->buffer = g_realloc(audioscale->buffer, audioscale->buffersize + size);
    memcpy(audioscale->buffer+audioscale->buffersize, data, size);
    audioscale->buffersize += size;
  }

  while (audioscale->buffersize >= audioscale->frequency) {
    outbuf = gst_buffer_new();
    GST_BUFFER_DATA(outbuf) = g_malloc(audioscale->targetfrequency);
    GST_BUFFER_SIZE(outbuf) = audioscale->targetfrequency;
    //memcpy(GST_BUFFER_DATA(outbuf), audioscale->buffer, audioscale->targetfrequency);

    for (i=0; i< audioscale->targetfrequency/4; i++) {
      pos = (i * audioscale->frequency)/audioscale->targetfrequency;
      //printf("%d %d\n", i, pos);
      *(((gulong *)GST_BUFFER_DATA(outbuf))+i) = *(((gulong *)audioscale->buffer)+pos);
    }
    memcpy(audioscale->buffer, audioscale->buffer+audioscale->frequency, audioscale->buffersize-audioscale->frequency);
    audioscale->buffer = g_realloc(audioscale->buffer, audioscale->buffersize-audioscale->frequency);
    audioscale->buffersize -= audioscale->frequency;

    GST_DEBUG (0,"gst_audioscale_chain: pushing buffer of %d bytes in '%s'\n",GST_BUFFER_SIZE(outbuf),
		              gst_element_get_name (GST_ELEMENT (audioscale)));

    gst_pad_push(audioscale->srcpad, outbuf);
  }
  gst_buffer_unref(buf);
}

static void
gst_audioscale_set_property (GObject *object, guint prop_id, const GValue *value, GParamSpec *pspec)
{
  Audioscale *src;

  /* it's not null if we got it, but it might not be ours */
  g_return_if_fail(GST_IS_AUDIOSCALE(object));
  src = GST_AUDIOSCALE(object);

  switch (prop_id) {
    case ARG_FREQUENCY:
      src->targetfrequency = g_value_get_int (value);
      break;
    default:
      break;
  }
}

static void
gst_audioscale_get_property (GObject *object, guint prop_id, GValue *value, GParamSpec *pspec)
{
  Audioscale *src;

  /* it's not null if we got it, but it might not be ours */
  g_return_if_fail(GST_IS_AUDIOSCALE(object));
  src = GST_AUDIOSCALE(object);

  switch (prop_id) {
    case ARG_FREQUENCY:
      g_value_set_int (value, src->targetfrequency);
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
  }
}


static gboolean
plugin_init (GModule *module, GstPlugin *plugin)
{
  GstElementFactory *factory;

  /* create an elementfactory for the audioscale element */
  factory = gst_elementfactory_new("audioscale",GST_TYPE_AUDIOSCALE,
                                   &audioscale_details);
  g_return_val_if_fail(factory != NULL, FALSE);
  gst_plugin_add_factory(plugin,factory);

  return TRUE;
}

GstPluginDesc plugin_desc = {
  GST_VERSION_MAJOR,
  GST_VERSION_MINOR,
  "audioscale",
  plugin_init
};

