/* Gnome-Streamer
 * Copyright (C) <1999> Erik Walthinsen <omega@cse.ogi.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GST_FLX_DECODER_H__
#define __GST_FLX_DECODER_H__

#include <gst/gst.h>

#include "flx_color.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* Definition of structure storing data for this element. */
typedef struct _FlxDec  FlxDec;
struct _FlxDec {
  GstElement element;

  GstPad *sinkpad,*srcpad;

  gboolean active, new_meta, new_buf;

  GstBuffer *buf, *out, *delta, *frame;
  gulong offset, size;

  FlxColorSpaceConverter *converter;

  FlxHeader hdr;
};

/* Standard definition defining a class for this element. */
typedef struct _FlxDecClass FlxDecClass;
struct _FlxDecClass {
  GstElementClass parent_class;
};

/* Standard macros for defining types for this element.  */
#define GST_TYPE_FLXDEC \
  (gst_flxdec_get_type())
#define GST_FLXDEC(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_FLXDEC,FlxDec))
#define GST_FLXDEC_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_FLXDEC,FlxDec))
#define GST_IS_FLXDEC(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_FLXDEC))
#define GST_IS_FLXDEC_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_FLXDEC))

#define FLXDEC_BUFSIZE(buf, offset) \
  ((GST_BUFFER_OFFSET(buf) + GST_BUFFER_SIZE(buf)) - offset)

/* Standard function returning type information. */
GType gst_flxdec_get_type(void);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GST_FLX_DECODER_H__ */
