/* Gnome-Streamer
 * Copyright (C) <1999> Erik Walthinsen <omega@cse.ogi.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef __GST_MPEG_PLAY_H__
#define __GST_MPEG_PLAY_H__


#include <gst/gst.h>

#include "video.h"
#include "proto.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GST_TYPE_MPEG_PLAY \
  (gst_mpeg_play_get_type())
#define GST_MPEG_PLAY(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_MPEG_PLAY,GstMpeg_play))
#define GST_MPEG_PLAY_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_MPEG_PLAY,GstMpeg_play))
#define GST_IS_MPEG_PLAY(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_MPEG_PLAY))
#define GST_IS_MPEG_PLAY_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_MPEG_PLAY))

typedef struct _GstMpeg_play GstMpeg_play;
typedef struct _GstMpeg_playClass GstMpeg_playClass;

struct _GstMpeg_play {
  GstElement element;

  /* pads */
  GstPad *sinkpad,*srcpad;

  mpeg_play_VidStream *decoder;
  gint parse_state;
  gboolean in_flush;

  // the timestamp of the next frame
  guint64 next_time;
  // the interval between frames
  guint64 time_interval;

  // video state
  gint width;
  gint height;
  // the size of the output buffer
  gint outsize;

};

struct _GstMpeg_playClass {
  GstElementClass parent_class;

  /* signals */
  void (*frame_decoded) (GstElement *element, GstPad *pad);
};

GType gst_mpeg_play_get_type(void);
GstElement *gst_mpeg_play_new(gchar *name);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GST_MPEG_PLAY_H__ */
