/*
 * Copyright (c) 1995 The Regents of the University of California.
 * All rights reserved.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

/*
 * Portions of this software Copyright (c) 1995 Brown University.
 * All rights reserved.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement
 * is hereby granted, provided that the above copyright notice and the
 * following two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF BROWN
 * UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * BROWN UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"
 * BASIS, AND BROWN UNIVERSITY HAS NO OBLIGATION TO PROVIDE MAINTENANCE,
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#ifndef MPEG_LIB_VIDEO_HEADER
#define MPEG_LIB_VIDEO_HEADER

#include <stdio.h>
#include <gst/gst.h>
#include <libs/getbits/gstgetbits.h>
#include <libs/idct/gstidct.h>
#include "config.h"

//#undef HAVE_LIBMMX


/*
   Changes to make the code reentrant:
     deglobalized: totNumFrames, realTimeStart, matched_depth,
       filename, curBits, ReconPMBlock statics, stream id
       variables, Parse_done, swap, seekValue, input, EOF_flag, ReadPacket
       statics, sys_layer, curVidStream, curVidStream, jmb_buf env (removed)
     now const: scan
     film_has_ended instead of FilmState
   -lsh@cs.brown.edu (Loring Holden)
 */

#ifndef XMD_H
typedef int INT32;
typedef short INT16;
typedef char INT8;
#endif
typedef unsigned int UINT32;
typedef unsigned short UINT16;
typedef unsigned char UINT8;

/* Define Parsing error codes. */
#define SKIP_PICTURE (-10)
#define SKIP_TO_START_CODE (-1)
#define PARSE_OK 1

/* Define BOOLEAN, TRUE, and FALSE. */
#define BOOLEAN char

/* Set ring buffer size. */
#define RING_BUF_SIZE 5

/* Macros for picture code type. */
#define I_TYPE 1
#define P_TYPE 2
#define B_TYPE 3
#define D_TYPE 4

/* Start codes. */
#define SEQ_END_CODE 0x000001b7
#define SEQ_START_CODE 0x000001b3
#define GOP_START_CODE 0x000001b8
#define PICTURE_START_CODE 0x00000100
#define SLICE_MIN_START_CODE 0x00000101
#define SLICE_MAX_START_CODE 0x000001af
#define EXT_START_CODE 0x000001b5
#define USER_START_CODE 0x000001b2
#define SEQUENCE_ERROR_CODE 0x000001b4

/* Number of macroblocks to process in one call to mpegVidRsrc. */
#define MB_QUANTUM 100

/* Macros used with macroblock address decoding. */
#define MB_STUFFING 34
#define MB_ESCAPE 35

/* Lock flags for pict images. */
#define DISPLAY_LOCK 0x01
#define PAST_LOCK 0x02
#define FUTURE_LOCK 0x04

/* the state of decoder */
#define REGULAR_PARSE 1
#define IN_SLICE_PARSE 2
#define IN_SEQ_PARSE 3
#define IN_GOP_PARSE 4
#define IN_PICTURE_PARSE 5

/* return values decoder */
#define START_BLOCK  0x01
#define FIRST_BLOCK  0x02
#define NEW_PICTURE  0x04
#define CONTINUE_BLOCK 0x08
#define FINISHED_BLOCK 0x10
#define SKIPPED_PICTURE  0x20

/* chroma_format */
#define CHROMA420 1
#define CHROMA422 2
#define CHROMA444 3

/* picture structure */
#define TOP_FIELD     1
#define BOTTOM_FIELD  2
#define FRAME_PICTURE 3

/* External declaration of row,col to zig zag conversion matrix. */

/* Temporary definition of time stamp structure. */
typedef unsigned long long TimeStamp;

/* Structure with reconstructed pixel values. */
typedef struct pict_image {
  GstBuffer *buffer;
  unsigned char *luminance;              /* Luminance plane.   */
  unsigned char *Cr;                     /* Cr plane.          */
  unsigned char *Cb;                     /* Cb plane.          */
  int locked;                            /* Lock flag.         */
  TimeStamp show_time;                   /* Presentation time. */

} mpeg_play_PictImage;

/* Group of pictures structure. */
typedef struct GoP {
  BOOLEAN drop_flag;                     /* Flag indicating dropped frame. */
  unsigned int tc_hours;                 /* Hour component of time code.   */
  unsigned int tc_minutes;               /* Minute component of time code. */
  unsigned int tc_seconds;               /* Second component of time code. */
  unsigned int tc_pictures;              /* Picture counter of time code.  */
  BOOLEAN closed_gop;                    /* Indicates no pred. vectors to
					    previous group of pictures.    */
  BOOLEAN broken_link;                   /* B frame unable to be decoded.  */
  char *user_data;                       /* User data.                     */
} mpeg_play_GoP;

/* Picture structure. */
typedef struct pict {
  unsigned int temp_ref;                 /* Temporal reference.             */
  unsigned int code_type;                /* Frame type: P, B, I             */
  unsigned int vbv_delay;                /* Buffer delay.                   */
  BOOLEAN full_pel_forw_vector;          /* Forw. vectors specified in full
					    pixel values flag.              */
  unsigned int forw_r_size;              /* Used for vector decoding.       */
  unsigned int forw_f;                   /* Used for vector decoding.       */
  BOOLEAN full_pel_back_vector;          /* Back vectors specified in full 
					    pixel values flag.              */
  unsigned int back_r_size;              /* Used in decoding.               */
  unsigned int back_f;                   /* Used in decoding.               */
  /* MPEG2 coding extensions */
  int q_scale_type;
  int picture_structure;
  int frame_pred_frame_dct;
  
  char *extra_info;                      /* Extra bit picture info.         */
  char *user_data;                       /* User data.                      */
} mpeg_play_Pict;

/* Slice structure. */
typedef struct slice {
  unsigned int vert_pos;                 /* Vertical position of slice. */
  unsigned int quant_scale;              /* Quantization scale.         */
  /* for MPEG2 */
  unsigned int intra_slice;
  int vert_pos_ext;
  char *extra_info;                      /* Extra bit slice info.       */
} mpeg_play_Slice;

/* Macroblock structure. */
typedef struct macroblock {
  int mb_address;                        /* Macroblock address.              */
  int past_mb_addr;                      /* Previous mblock address.         */
  int motion_h_forw_code;                /* Forw. horiz. motion vector code. */
  unsigned int motion_h_forw_r;          /* Used in decoding vectors.        */
  int motion_v_forw_code;                /* Forw. vert. motion vector code.  */
  unsigned int motion_v_forw_r;          /* Used in decdoinge vectors.       */
  int motion_h_back_code;                /* Back horiz. motion vector code.  */
  unsigned int motion_h_back_r;          /* Used in decoding vectors.        */
  int motion_v_back_code;                /* Back vert. motion vector code.   */
  unsigned int motion_v_back_r;          /* Used in decoding vectors.        */
  unsigned int cbp;                      /* Coded block pattern.             */
  BOOLEAN mb_intra;                      /* Intracoded mblock flag.          */
  BOOLEAN bpict_past_forw;               /* Past B frame forw. vector flag.  */
  BOOLEAN bpict_past_back;               /* Past B frame back vector flag.   */
  int past_intra_addr;                   /* Addr of last intracoded mblock.  */
  int recon_right_for_prev;              /* Past right forw. vector.         */
  int recon_down_for_prev;               /* Past down forw. vector.          */
  int recon_right_back_prev;             /* Past right back vector.          */
  int recon_down_back_prev;              /* Past down back vector.           */
} mpeg_play_Macroblock;

/* Block structure. */
typedef struct block {
  short int dct_recon[8][8];             /* Reconstructed dct coeff matrix. */
  short int dct_dc_y_past;               /* Past lum. dc dct coefficient.   */
  short int dct_dc_cr_past;              /* Past cr dc dct coefficient.     */
  short int dct_dc_cb_past;              /* Past cb dc dct coefficient.     */
} mpeg_play_Block;

/* Video stream structure. */
typedef struct vid_stream {
  unsigned int h_size;                         /* Horiz. size in pixels.     */
  unsigned int v_size;                         /* Vert. size in pixels.      */
  unsigned int mb_height;                      /* Vert. size in mblocks.     */
  unsigned int mb_width;                       /* Horiz. size in mblocks.    */
  unsigned char aspect_ratio;                  /* Code for aspect ratio.     */
  unsigned char picture_rate;                  /* Code for picture rate.     */
  unsigned int bit_rate;                       /* Bit rate.                  */
  unsigned int vbv_buffer_size;                /* Minimum buffer size.       */
  BOOLEAN const_param_flag;                    /* Contrained parameter flag. */
  unsigned char intra_quant_matrix[8][8];      /* Quantization matrix for
						  intracoded frames.         */
  unsigned char non_intra_quant_matrix[8][8];  /* Quanitization matrix for 
						  non intracoded frames.     */
  char *ext_data;                              /* Extension data.            */
  char *user_data;                             /* User data.                 */
  mpeg_play_GoP group;                         /* Current group of pict.     */
  mpeg_play_Pict picture;                      /* Current picture.           */
  mpeg_play_Slice slice;                       /* Current slice.             */
  mpeg_play_Macroblock mblock;                 /* Current macroblock.        */
  mpeg_play_Block block;                       /* Current block.             */
  int status;                                  /* Status of decoding.        */
  int state;                                   /* State of decoding.         */
  
  unsigned long *swapbuf;                       /* Pointer to current buffer  */
  unsigned int *buf_start;                     /* Pointer to buffer start.   */

  gst_getbits_t gb;
  GstIDCT *idct;
  unsigned int *zigzag_scan;
  GstBufferPool *pool;
  GMemChunk *chunk;

/* Brown - beginning of added variables that used to be static or global */
  int film_has_ended;                          /* Boolean - film has ended   */
  int skipped;

  int right_for,down_for;                      /* From ReconPMBlock, video.c */
  int right_half_for, down_half_for;

/* WTA added for MPEG2 */
  int MPEG2;
  int profile, level;
  int progressive_sequence, progressive_frame;
  int chroma_format;

/* Brown - end of added variables */
  mpeg_play_PictImage *past;                             /* Past predictive frame.     */
  mpeg_play_PictImage *future;                           /* Future predictive frame.   */
  mpeg_play_PictImage *currentdisplay[RING_BUF_SIZE];    /* array with the current frames */
  mpeg_play_PictImage *current;                          /* Current frame.             */
  mpeg_play_PictImage *ring[RING_BUF_SIZE];              /* Ring buffer of frames.     */
} mpeg_play_VidStream;   

/* Definition of Contant integer scale factor. */
#define CONST_BITS 13

/* Misc DCT definitions */
#define DCTSIZE		8	/* The basic DCT block is 8x8 samples */
#define DCTSIZE2	64	/* DCTSIZE squared; # of elements in a block */

#define GLOBAL			/* a function referenced thru EXTERNs */
  
typedef short DCTELEM;
typedef DCTELEM DCTBLOCK[DCTSIZE2];

#if !defined(__MIPSEL__) && (defined(MIPSEL) || defined(__MIPSEL) || defined(__MIPSEL__) || defined(__mipsel) || defined(__mipsel__))
#define __MIPSEL__ 1
#endif

#if !defined(__MIPSEB__) && (defined(MIPSEB) || defined(__MIPSEB) || defined(__MIPSEB__) || defined(__mipseb) || defined(__mipseb__))
#define __MIPSEB__ 1
#endif

#if !defined(__SPARC__) && (defined(SPARC) || defined(__SPARC) || defined(__SPARC__) || defined(__sparc) || defined(__sparc__))
#define __SPARC__ 1
#endif

#if !defined(__alpha__) && (defined(ALPHA) || defined(__ALPHA) || defined(__ALPHA__) || defined(__alpha))
#define __alpha__ 1
#endif

#if !defined(__680x0__) && (defined(__680x0) || defined(__680x0__))
#define __680x0__ 1
#endif

#if !defined(__AIX__) && (defined(AIX) || defined(_AIX) || defined(__AIX) || defined(__AIX__))
#define __AIX__ 1
#endif

#if !defined(__RS6000__) && (defined(__AIX__) || defined(RS6000) || defined(_RS6000) || defined(__RS6000) || defined(__RS6000__))
#define __RS6000__ 1
#endif

#if !defined(__HPUX__) && (defined(HPUX) || defined(_HPUX) || defined(__HPUX) || defined(__HPUX__))
#define __HPUX__ 1
#endif
#if !defined(__HPUX__) && (defined(hpux) || defined(_hpux) || defined(__hpux) || defined(__hpux__))
#define __HPUX__ 1
#endif

#if !defined(__VAX__) && (defined(VAX) || defined (__VAX))
#define __VAX__ 1
#endif

#if !defined(__SCO__) && (defined(SCO) || defined(__SCO) || defined(sco) || defined(__sco__))
#define __SCO__ 1
#endif

#if defined(__i386__) || defined(__VAX__) || defined(__MIPSEL__) || defined(__alpha__) || defined(__SCO__)
#undef  BIG_ENDIAN_ARCHITECTURE
#define LITTLE_ENDIAN_ARCHITECTURE 1
#endif

#if defined(__RS6000__) || defined(__SPARC__) || defined(__680x0__) || defined(__HPUX__) || defined(__MIPSEB__) || defined(convex) || defined(__convex__)
#undef  LITTLE_ENDIAN_ARCHITECTURE
#define BIG_ENDIAN_ARCHITECTURE 1
#endif

/* Use autoconf determined setting. */
#if defined WORDS_BIGENDIAN
#undef  LITTLE_ENDIAN_ARCHITECTURE
#define BIG_ENDIAN_ARCHITECTURE 1
#else
#undef  BIG_ENDIAN_ARCHITECTURE
#define LITTLE_ENDIAN_ARCHITECTURE 1
#endif

#if !defined(LITTLE_ENDIAN_ARCHITECTURE) && !defined(BIG_ENDIAN_ARCHITECTURE)
Error: Unknown endianism of architecture
#endif

#ifdef __alpha__
#define SIXTYFOUR_BIT
#endif
#endif /* video.h already included */
