/* mpeg2dec.h, MPEG specific defines                                        */

/* Copyright (C) 1996, MPEG Software Simulation Group. All Rights Reserved. */

/*
 * Disclaimer of Warranty
 *
 * These software programs are available to the user without any license fee or
 * royalty on an "as is" basis.  The MPEG Software Simulation Group disclaims
 * any and all warranties, whether express, implied, or statuary, including any
 * implied warranties or merchantability or of fitness for a particular
 * purpose.  In no event shall the copyright-holder be liable for any
 * incidental, punitive, or consequential damages of any kind whatsoever
 * arising from the use of these programs.
 *
 * This disclaimer of warranty extends to the user of these programs and user's
 * customers, employees, agents, transferees, successors, and assigns.
 *
 * The MPEG Software Simulation Group does not represent or warrant that the
 * programs furnished hereunder are free of infringement of any third-party
 * patents.
 *
 * Commercial implementations of MPEG-1 and MPEG-2 video, including shareware,
 * are subject to royalty fees to patent holders.  Many of these patents are
 * general enough such that they are unavoidable regardless of implementation
 * design.
 *
 */

#include <gst/gst.h>
#include <libs/getbits/gstgetbits.h>
#include <libs/idct/gstidct.h>
#include "config.h"

//#undef HAVE_LIBMMX

#ifdef NON_ANSI_COMPILER
#define _ANSI_ARGS_(x) ()
#else
#define _ANSI_ARGS_(x) x
#endif

#define VLC_ERROR (-1)

#define PICTURE_START_CODE      0x100
#define SLICE_START_CODE_MIN    0x101
#define SLICE_START_CODE_MAX    0x1AF
#define USER_DATA_START_CODE    0x1B2
#define SEQUENCE_HEADER_CODE    0x1B3
#define SEQUENCE_ERROR_CODE     0x1B4
#define EXTENSION_START_CODE    0x1B5
#define SEQUENCE_END_CODE       0x1B7
#define GROUP_START_CODE        0x1B8
#define SYSTEM_START_CODE_MIN   0x1B9
#define SYSTEM_START_CODE_MAX   0x1FF

#define ISO_END_CODE            0x1B9
#define PACK_START_CODE         0x1BA
#define SYSTEM_START_CODE       0x1BB

#define VIDEO_ELEMENTARY_STREAM 0x1e0

/* scalable_mode */
#define SC_NONE 0
#define SC_DP   1
#define SC_SPAT 2
#define SC_SNR  3
#define SC_TEMP 4

/* picture coding type */
#define I_TYPE 1
#define P_TYPE 2
#define B_TYPE 3
#define D_TYPE 4

/* picture structure */
#define TOP_FIELD     1
#define BOTTOM_FIELD  2
#define FRAME_PICTURE 3

/* macroblock type */
#define MACROBLOCK_INTRA                        1
#define MACROBLOCK_PATTERN                      2
#define MACROBLOCK_MOTION_BACKWARD              4
#define MACROBLOCK_MOTION_FORWARD               8
#define MACROBLOCK_QUANT                        16
#define SPATIAL_TEMPORAL_WEIGHT_CODE_FLAG       32
#define PERMITTED_SPATIAL_TEMPORAL_WEIGHT_CLASS 64


/* motion_type */
#define MC_FIELD 1
#define MC_FRAME 2
#define MC_16X8  2
#define MC_DMV   3

/* mv_format */
#define MV_FIELD 0
#define MV_FRAME 1

/* chroma_format */
#define CHROMA420 1
#define CHROMA422 2
#define CHROMA444 3

/* extension start code IDs */
#define SEQUENCE_EXTENSION_ID                    1
#define SEQUENCE_DISPLAY_EXTENSION_ID            2
#define QUANT_MATRIX_EXTENSION_ID                3
#define COPYRIGHT_EXTENSION_ID                   4
#define SEQUENCE_SCALABLE_EXTENSION_ID           5
#define PICTURE_DISPLAY_EXTENSION_ID             7
#define PICTURE_CODING_EXTENSION_ID              8
#define PICTURE_SPATIAL_SCALABLE_EXTENSION_ID    9
#define PICTURE_TEMPORAL_SCALABLE_EXTENSION_ID  10

#define ZIG_ZAG                                  0

#define PROFILE_422                             (128+5)
#define MAIN_LEVEL                              8

/* Layers: used by Verbose_Flag, Verifier_Flag, Stats_Flag, and Trace_Flag */
#define NO_LAYER                                0
#define SEQUENCE_LAYER                          1
#define PICTURE_LAYER                           2
#define SLICE_LAYER                             3    
#define MACROBLOCK_LAYER                        4    
#define BLOCK_LAYER                             5
#define EVENT_LAYER                             6
#define ALL_LAYERS                              7

#define MB_WEIGHT                  32
#define MB_CLASS4                  64

/* return values decoder */
#define START_BLOCK  0x01
#define FIRST_BLOCK  0x02
#define NEW_PICTURE  0x04
#define CONTINUE_BLOCK 0x08
#define FINISHED_BLOCK 0x10

/* the state of decoder */
#define REGULAR_PARSE 1
#define IN_SLICE_PARSE 2
#define IN_SEQ_PARSE 3
#define IN_GOP_PARSE 4
#define IN_PICTURE_PARSE 5
/* Define Parsing error codes. */
#define SKIP_PICTURE (-10)
#define SKIP_TO_START_CODE (-1)
#define PARSE_OK 1

#define NO_STARTCODE 0
#define STARTCODE_FOUND 1


/* prototypes of global functions */

/* systems.c */
void Next_Packet _ANSI_ARGS_((void));
int Get_Long _ANSI_ARGS_((void));
void Flush_Buffer32 _ANSI_ARGS_((void));
unsigned int Get_Bits32 _ANSI_ARGS_((void));

/* mpeg2dec.c */
void Error _ANSI_ARGS_((char *text));
void Warning _ANSI_ARGS_((char *text));
void Print_Bits _ANSI_ARGS_((int code, int bits, int len));


/* store.c */
void Write_Frame _ANSI_ARGS_((unsigned char *src[], int frame));

#ifdef DISPLAY
/* display.c */
void Initialize_Display_Process _ANSI_ARGS_((char *name));
void Terminate_Display_Process _ANSI_ARGS_((void));
void Display_Second_Field _ANSI_ARGS_((void));
void dither _ANSI_ARGS_((unsigned char *src[]));
void Initialize_Dither_Matrix _ANSI_ARGS_((void));
#endif


/* color space conversion coefficients
 * for YCbCr -> RGB mapping
 *
 * entries are {crv,cbu,cgu,cgv}
 *
 * crv=(255/224)*65536*(1-cr)/0.5
 * cbu=(255/224)*65536*(1-cb)/0.5
 * cgu=(255/224)*65536*(cb/cg)*(1-cb)/0.5
 * cgv=(255/224)*65536*(cr/cg)*(1-cr)/0.5
 *
 * where Y=cr*R+cg*G+cb*B (cr+cg+cb=1)
 */

/* output types (Output_Type) */
#define T_YUV   0
#define T_SIF   1
#define T_TGA   2
#define T_PPM   3
#define T_X11   4
#define T_X11HIQ 5

extern const unsigned char Non_Linear_quantizer_scale[32];

extern unsigned char *Clip;

/* pointers to scalability picture buffers */
unsigned char *llframe0[3];
unsigned char *llframe1[3];

short *lltmp;
char *Lower_Layer_Picture_Filename;

#define MPEG2PLAY_WIDTH(mp) (((mp)->horizontal_size+8)&~0xF)
#define MPEG2PLAY_HEIGHT(mp) ((mp)->vertical_size)
#define MPEG2PLAY_FORMAT(mp) ((mp)->sequence.video_format)

/* headers */

typedef struct Sequence {
  /* ISO/IEC 13818-2 section 6.2.2.1:  sequence_header() */
  int aspect_ratio_information;
  int frame_rate_code; 
  int bit_rate_value; 
  int vbv_buffer_size;
  int constrained_parameters_flag;

  /* ISO/IEC 13818-2 section 6.2.2.3:  sequence_extension() */
  int profile_and_level_indication;
  int progressive_sequence;
  int chroma_format;
  int low_delay;
  int frame_rate_extension_n;
  int frame_rate_extension_d;

  /* ISO/IEC 13818-2 section 6.2.2.4:  sequence_display_extension() */
  int video_format;  
  int color_description;
  int color_primaries;
  int transfer_characteristics;
  int matrix_coefficients;
  int display_horizontal_size;
  int display_vertical_size;

  /* ISO/IEC 13818-2 section 6.2.2.5: sequence_scalable_extension() header */
  int layer_id;
  int lower_layer_prediction_horizontal_size;
  int lower_layer_prediction_vertical_size;
  int horizontal_subsampling_factor_m;
  int horizontal_subsampling_factor_n;
  int vertical_subsampling_factor_m;
  int vertical_subsampling_factor_n;
} mpeg2play_Sequence;

typedef struct GoP {
  /* ISO/IEC 13818-2 section 6.2.2.6: group_of_pictures_header()  */
  int drop_flag;
  int hour;
  int minute;
  int sec;
  int frame;
  int closed_gop;
  int broken_link;
} mpeg2play_GoP;

typedef struct Pict {
  /* ISO/IEC 13818-2 section 6.2.3: picture_header() */
  int temporal_reference;
  int picture_coding_type;
  int vbv_delay;
  int full_pel_forward_vector;
  int forward_f_code;
  int full_pel_backward_vector;
  int backward_f_code;

  /* ISO/IEC 13818-2 section 6.2.3.1: picture_coding_extension() header */
  int f_code[2][2];
  int intra_dc_precision;
  int picture_structure;
  int top_field_first;
  int frame_pred_frame_dct;
  int concealment_motion_vectors;

  int intra_vlc_format;

  int repeat_first_field;

  int chroma_420_type;
  int progressive_frame;
  int composite_display_flag;
  int v_axis;
  int field_sequence;
  int sub_carrier;
  int burst_amplitude;
  int sub_carrier_phase;

  /* ISO/IEC 13818-2 section 6.2.3.3: picture_display_extension() header */
  int frame_center_horizontal_offset[3];
  int frame_center_vertical_offset[3];

  /* ISO/IEC 13818-2 section 6.2.3.5: picture_spatial_scalable_extension() header */
  int lower_layer_temporal_reference;
  int lower_layer_horizontal_offset;
  int lower_layer_vertical_offset;
  int spatial_temporal_weight_code_table_index;
  int lower_layer_progressive_frame;
  int lower_layer_deinterlaced_field_select;
} mpeg2play_Pict;


typedef struct Copyright {
  /* ISO/IEC 13818-2 section 6.2.3.6: copyright_extension() header */
  int copyright_flag;
  int copyright_identifier;
  int original_or_copy;
  int copyright_number_1;
  int copyright_number_2;
  int copyright_number_3;
} mpeg2play_Copyright;


/* layer specific variables (needed for SNR and DP scalability) */
typedef struct layer_data {
  /* bit input */
  gst_getbits_t gb;

  /* sequence header and quant_matrix_extension() */
  int intra_quantizer_matrix[64];
  int non_intra_quantizer_matrix[64];
  int chroma_intra_quantizer_matrix[64];
  int chroma_non_intra_quantizer_matrix[64];
  
  int load_intra_quantizer_matrix;
  int load_non_intra_quantizer_matrix;
  int load_chroma_intra_quantizer_matrix;
  int load_chroma_non_intra_quantizer_matrix;

  int MPEG2_Flag;
  /* sequence scalable extension */
  int scalable_mode;
  /* picture coding extension */
  int q_scale_type;
  int alternate_scan;
  /* picture spatial scalable extension */
  int pict_scal;
  /* slice/macroblock */
  int priority_breakpoint;
  int quantizer_scale;
  int intra_slice;
  short block[12][64];
  int sparse[12];
} mpeg2play_layer_data;

typedef struct vid_stream {
  /* normative derived variables (as per ISO/IEC 13818-2) */
  int horizontal_size;
  int vertical_size;
  int mb_width;
  int mb_height;
  double bit_rate;
  double frame_rate; 

  mpeg2play_layer_data base, enhan, *ld;
  mpeg2play_Copyright copyright;

  mpeg2play_Sequence sequence;
  mpeg2play_GoP group;
  mpeg2play_Pict picture;

  unsigned long *swapbuf;
  int status;                                  /* Status of decoding.        */
  int state;                                   /* State of decoding.         */
  int inited;       
  GstIDCT *idct;
  /* zig-zag and alternate scan patterns */
  //unsigned char **scan;
  unsigned char scan[2][64];

  /* pointers to generic picture buffers */
  unsigned char *backward_reference_frame[3];
  unsigned char *forward_reference_frame[3];

  unsigned char *output_frame;
  unsigned char *auxframe[3];
  unsigned char *current_frame[3];
  unsigned char *substitute_frame[3];

  /* non-normative variables derived from normative elements */
  int Coded_Picture_Width;
  int Coded_Picture_Height;
  int Chroma_Width;
  int Chroma_Height;
  int block_count;
  int Second_Field;
  int profile, level;

  int Decode_Layer;
  int global_MBA;
  int global_pic;
  int True_Framenum;

  /* decoder operation control variables */
  int Output_Type;
  int hiQdither;

  /* decoder operation control flags */
  int Quiet_Flag;
  int Trace_Flag;
  int Fault_Flag;
  int Verbose_Flag;
  int Two_Streams;
  int Spatial_Flag;
  int Reference_IDCT_Flag;
  int Frame_Store_Flag;
  int System_Stream_Flag;
  int Ersatz_Flag;
  int Big_Picture_Flag;
  int Verify_Flag;
  int Stats_Flag;
  int User_Data_Flag;
  int Main_Bitstream_Flag;

} mpeg2play_vid_stream;



#ifdef VERIFY
int verify_sequence_header;
int verify_group_of_pictures_header;
int verify_picture_header;
int verify_slice_header;
int verify_sequence_extension;
int verify_sequence_display_extension;
int verify_quant_matrix_extension;
int verify_sequence_scalable_extension;
int verify_picture_display_extension;
int verify_picture_coding_extension;
int verify_picture_spatial_scalable_extension;
int verify_picture_temporal_scalable_extension;
int verify_copyright_extension;
#endif /* VERIFY */


/* verify.c */
#ifdef VERIFY
void Check_Headers _ANSI_ARGS_((int Bitstream_Framenum, int Sequence_Framenum));
void Clear_Verify_Headers _ANSI_ARGS_((void));
#endif /* VERIFY */

/* getblk.c */
void Decode_MPEG1_Intra_Block _ANSI_ARGS_((mpeg2play_vid_stream *vid_stream, int comp, int dc_dct_pred[]));
void Decode_MPEG1_Non_Intra_Block _ANSI_ARGS_((mpeg2play_vid_stream *vid_stream, int comp));
void Decode_MPEG2_Intra_Block _ANSI_ARGS_((mpeg2play_vid_stream *vid_stream, int comp, int dc_dct_pred[]));
void Decode_MPEG2_Non_Intra_Block _ANSI_ARGS_((mpeg2play_vid_stream *vid_stream, int comp));

/* gethdr.c */
int Get_Hdr _ANSI_ARGS_((mpeg2play_vid_stream *vid_stream));
int mpeg2play_next_start_code _ANSI_ARGS_((gst_getbits_t *gb));
int slice_header _ANSI_ARGS_((mpeg2play_vid_stream *vid_stream));
void marker_bit _ANSI_ARGS_((gst_getbits_t *gb, char *text));
int sequence_header _ANSI_ARGS_((mpeg2play_vid_stream *vid_stream));
int group_of_pictures_header _ANSI_ARGS_((mpeg2play_vid_stream *vid_stream));
int picture_header _ANSI_ARGS_((mpeg2play_vid_stream *vid_stream));
int extension_and_user_data _ANSI_ARGS_((mpeg2play_vid_stream *vid_stream, int code));


/* getpic.c */
void Decode_Picture _ANSI_ARGS_((mpeg2play_vid_stream *vidStream, int bitstream_framenum, 
  int sequence_framenum));
void Decode_Picture_End _ANSI_ARGS_((mpeg2play_vid_stream *vidStream, int bitstream_framenum, 
  int sequence_framenum));
void Output_Last_Frame_of_Sequence _ANSI_ARGS_((mpeg2play_vid_stream *vidStream, int framenum));
int slice _ANSI_ARGS_((mpeg2play_vid_stream *vid_stream, int framenum, int MBAmax));

/* getvlc.c */
int Get_macroblock_type _ANSI_ARGS_((mpeg2play_vid_stream *vid_stream));
int Get_motion_code _ANSI_ARGS_((gst_getbits_t *gb));
int Get_dmvector _ANSI_ARGS_((gst_getbits_t *gb));
int Get_coded_block_pattern _ANSI_ARGS_((gst_getbits_t *gb));
int Get_macroblock_address_increment _ANSI_ARGS_((mpeg2play_vid_stream *vid_stream, gst_getbits_t *gb));
int Get_Luma_DC_dct_diff _ANSI_ARGS_((gst_getbits_t *gb));
int Get_Chroma_DC_dct_diff _ANSI_ARGS_((gst_getbits_t *gb));

/* readpic.c */
//void Substitute_Frame_Buffer _ANSI_ARGS_ ((mpeg2play_vid_stream *vid_stream, int bitstream_framenum, 
//  int sequence_framenum));

/* spatscal.c */
void Spatial_Prediction _ANSI_ARGS_((mpeg2play_vid_stream *vid_stream));

/* motion.c */
void motion_vectors _ANSI_ARGS_((mpeg2play_vid_stream *vid_stream, int PMV[2][2][2], int dmvector[2],
  int motion_vertical_field_select[2][2], int s, int motion_vector_count, 
  int mv_format, int h_r_size, int v_r_size, int dmv, int mvscale));
void motion_vector _ANSI_ARGS_((mpeg2play_vid_stream *vid_stream, int *PMV, int *dmvector,
  int h_r_size, int v_r_size, int dmv, int mvscale, int full_pel_vector));
void Dual_Prime_Arithmetic _ANSI_ARGS_((mpeg2play_vid_stream *vid_stream, int DMV[][2], int *dmvector, int mvx, int mvy));

/* recon.c */
void mpeg2play_init_predictions _ANSI_ARGS_((void));
void mpeg2play_form_predictions _ANSI_ARGS_((mpeg2play_vid_stream *vid_stream, int bx, int by, int macroblock_type, 
  int motion_type, int PMV[2][2][2], int motion_vertical_field_select[2][2], 
  int dmvector[2], int stwtype));

/* IMPLEMENTAION specific rouintes */
mpeg2play_vid_stream *mpeg2play_new_decoder();
int mpeg2play_new_buffer (mpeg2play_vid_stream *vid_stream, char *inbuf, long inlen, int first);

