#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <glib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <fcntl.h>
#include <string.h>

#include <rtp/rtp-packet.h>
#include <rtp/rtcp-packet.h>
#include <rtp/rtp-audio.h>

#include "rtpsend.h"

static const gchar App_Name[] = { /* Name for APP packets */
  'p', 'v'
};

int
find_host(gchar *host_name, struct in_addr *address)
{
  struct hostent *host;

  if (inet_aton(host_name, address)) {
    return 1;
  } else {
    host = gethostbyname(host_name);
  }
  
  if (!host) {
    herror("error looking up host");
    return 0;
  }

  memcpy(address, (struct in_addr *) host->h_addr_list[0],
         sizeof(struct in_addr));

  return 1;
}

void
rtp_send(struct rtp_sender_info* sen,
	 gchar *buf, int nbytes, 
	 rtp_payload_t pt, guint32 nsamp)
{
  Rtp_Packet packet;

  packet = rtp_packet_new_allocate(nbytes, 0, 0);

  rtp_packet_set_csrc_count(packet, 0);
  rtp_packet_set_extension(packet, 0);
  rtp_packet_set_padding(packet, 0);
  rtp_packet_set_version(packet, RTP_VERSION);
  rtp_packet_set_payload_type(packet, pt);
  rtp_packet_set_marker(packet, 0);
  rtp_packet_set_ssrc(packet, sen->ssrc); 
  rtp_packet_set_seq(packet, sen->seq);
  rtp_packet_set_timestamp(packet, sen->timestamp);

  ++sen->seq;
  sen->timestamp += nsamp;

  g_memmove(rtp_packet_get_payload(packet), buf, nbytes);
  sen->send_addr.sin_port = g_htons(sen->dest_port);
  rtp_packet_send(packet, sen->send_sock, &(sen->send_addr));

  ++sen->packets_sent;
  sen->octets_sent += rtp_packet_get_packet_len(packet);

  rtp_packet_free(packet);
}

void
rtp_client_connection(struct rtp_sender_info* sen) {

  if ((sen->send_sock = socket(PF_INET, SOCK_DGRAM, 0)) < 0) {
    g_print("open_sockets : Send_Sock");
  }
}

void
rtcp_send(struct rtp_sender_info* sen)
{
  Rtcp_Compound compound;
  guint32 message;
  
  compound = rtcp_compound_new_allocate(RTP_MTU);
  rtcp_compound_add_sr(compound, sen->ssrc, sen->timestamp,
                       sen->packets_sent, sen->octets_sent);
  message = g_htonl(sen->packets_sent);
  
  rtcp_compound_add_app(compound, sen->ssrc, App_Name,
                        &message, sizeof message);
  sen->send_addr.sin_port = g_htons(sen->dest_port+1);
  g_print("Sending rtcp message stating %d packets\n", sen->packets_sent);
  rtcp_compound_send(compound, sen->send_sock, &(sen->send_addr));
  sen->send_addr.sin_port = g_htons(sen->dest_port);

  rtcp_compound_free(compound);
}

int
rtp_connection_call(struct rtp_sender_info* sen,
		    gchar *hostname,
		    guint port)
{
  struct in_addr call_host;     /* host info of computer to call */

  if (find_host(hostname, &call_host)) {
    sen->send_addr.sin_family = AF_INET;
    sen->send_addr.sin_port = g_htons(8877);
    g_memmove(&sen->send_addr.sin_addr.s_addr,
              &call_host, sizeof (struct in_addr));
    
    sen->seq = random32(1);
    sen->ssrc = random32(2);
    sen->timestamp = random32(3);
    sen->dest_hostname = g_strdup(hostname);
    sen->dest_port = port;
    sen->packets_sent = 0;
    return 1;
  }
  else {
    return 0;
  }
}





