/* Gnome-Streamer
 * Copyright (C) <1999> Erik Walthinsen <omega@cse.ogi.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "rtpsend.h"
#include "rtp.h"

/* elementfactory information */
static GstElementDetails rtpsend_details = {
  "RTP plugin",
  "RtpSend",
  "Streams data via RTP",
  VERSION,
  "Zaheer Merali <zaheer@bellworldwide.net>",
  "(C) 2001",
};

/* RtpSend signals and args */
enum {
  /* FILL ME */
  LAST_SIGNAL
};

enum {
  ARG_0,
  ARG_IP,
  ARG_PORT,
  ARG_MTU
};

static GstPadTemplate*
sink_factory (void)
{
  return
    gst_padtemplate_new (
  	"sink",
  	GST_PAD_SINK,
 	GST_PAD_ALWAYS,
	NULL);
}

static void			gst_rtpsend_class_init	(GstRtpSendClass *klass);
static void			gst_rtpsend_init		(GstRtpSend *rtpsend);

static void			gst_rtpsend_chain		(GstPad *pad, GstBuffer *buf);

static void			gst_rtpsend_set_property		(GObject *object, guint prop_id, const GValue *value, GParamSpec *pspec);
static void			gst_rtpsend_get_property		(GObject *object, guint prop_id, GValue *value, GParamSpec *pspec);

static GstElementStateReturn	gst_rtpsend_change_state	(GstElement *element);

GstPadTemplate *src_template, *sink_template;

static GstElementClass *parent_class = NULL;
//static guint gst_icecastsend_signals[LAST_SIGNAL] = { 0 };

GType
gst_rtpsend_get_type(void)
{
  static GType rtpsend_type = 0;

  if (!rtpsend_type) {
    static const GTypeInfo rtpsend_info = {
      sizeof(GstRtpSendClass),      NULL,
      NULL,
      (GClassInitFunc)gst_rtpsend_class_init,
      NULL,
      NULL,
      sizeof(GstRtpSend),
      0,
      (GInstanceInitFunc)gst_rtpsend_init,
    };
    rtpsend_type = g_type_register_static(GST_TYPE_ELEMENT, "GstRtpSend", &rtpsend_info, 0);
  }
  return rtpsend_type;
}

static void
gst_rtpsend_class_init (GstRtpSendClass *klass)
{
  GObjectClass *gobject_class;
  GstElementClass *gstelement_class;

  gobject_class = (GObjectClass*)klass;
  gstelement_class = (GstElementClass*)klass;

  parent_class = g_type_class_ref(GST_TYPE_ELEMENT);

  g_object_class_install_property(G_OBJECT_CLASS(klass), ARG_IP,
    g_param_spec_string("ip","ip","ip",
                        NULL, G_PARAM_READWRITE)); // CHECKME
  g_object_class_install_property(G_OBJECT_CLASS(klass), ARG_PORT,
    g_param_spec_int("port","port","port",
                     G_MININT,G_MAXINT,0,G_PARAM_READWRITE)); // CHECKME
  g_object_class_install_property(G_OBJECT_CLASS(klass), ARG_MTU,
    g_param_spec_int("mtu","mtu","mtu",
                     G_MININT,G_MAXINT,0,G_PARAM_READWRITE)); // CHECKME

  gobject_class->set_property = gst_rtpsend_set_property;
  gobject_class->get_property = gst_rtpsend_get_property;

  gstelement_class->change_state = gst_rtpsend_change_state;
}

static void
gst_rtpsend_init (GstRtpSend *rtpsend)
{
  rtpsend->sinkpad = gst_pad_new_from_template (sink_template, "sink");
  gst_element_add_pad(GST_ELEMENT(rtpsend),rtpsend->sinkpad);
  gst_pad_set_chain_function(rtpsend->sinkpad,gst_rtpsend_chain);

  rtpsend->ip = g_strdup ("127.0.0.1");
  rtpsend->port = 8000;
  rtpsend->mtu = 160;
}

static void
gst_rtpsend_chain (GstPad *pad, GstBuffer *buf)
{
  GstRtpSend *rtpsend;
  //glong ret;
  guint32 i;

  g_return_if_fail(pad != NULL);
  g_return_if_fail(GST_IS_PAD(pad));
  g_return_if_fail(buf != NULL);

  rtpsend = GST_RTPSEND (GST_OBJECT_PARENT (pad));

  g_return_if_fail (rtpsend != NULL);
  g_return_if_fail (GST_IS_RTPSEND (rtpsend));

  for(i=0;i<GST_BUFFER_SIZE(buf);i+=rtpsend->mtu) {
    if (GST_BUFFER_SIZE(buf)-i>rtpsend->mtu) {
      rtp_send (&rtpsend->conn, GST_BUFFER_DATA (buf)+i,
		rtpsend->mtu,0,20);
    }
    else {
      rtp_send (&rtpsend->conn, GST_BUFFER_DATA (buf)+i,
		GST_BUFFER_SIZE (buf) - i,0,20);
    }
  }
  /*if (!ret) {
    g_warning ("rtp send error...\n");
    }*/
  
  /*
  shout_sleep (&icecastsend->conn);
  */
  gst_buffer_unref (buf);
}

static void
gst_rtpsend_set_property (GObject *object, guint prop_id, const GValue *value, GParamSpec *pspec)
{
  GstRtpSend *rtpsend;

  /* it's not null if we got it, but it might not be ours */
  g_return_if_fail(GST_IS_RTPSEND(object));
  rtpsend = GST_RTPSEND(object);

  switch (prop_id) {
  case ARG_IP:
    if (rtpsend->ip)
      g_free (rtpsend->ip);
    rtpsend->ip = g_strdup (g_value_get_string (value));
    break;
  case ARG_PORT:
    rtpsend->port = g_value_get_int (value);
    break;
  case ARG_MTU:
    rtpsend->mtu = g_value_get_int (value);
  default:
    break;
  }
}

static void
gst_rtpsend_get_property (GObject *object, guint prop_id, GValue *value, GParamSpec *pspec)
{
  GstRtpSend *rtpsend;

  /* it's not null if we got it, but it might not be ours */
  g_return_if_fail(GST_IS_RTPSEND(object));
  rtpsend = GST_RTPSEND(object);

  switch (prop_id) {
  case ARG_IP:
    g_value_set_string (value, rtpsend->ip);
    break;
  case ARG_PORT:
    g_value_set_int (value, rtpsend->port);
    break;
  case ARG_MTU:
    g_value_set_int (value, rtpsend->mtu);
  default:
    G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    break;
  }
}

static GstElementStateReturn
gst_rtpsend_change_state (GstElement *element)
{
  GstRtpSend *rtpsend;

  g_return_val_if_fail (GST_IS_RTPSEND (element), GST_STATE_FAILURE);

  rtpsend = GST_RTPSEND(element);

  GST_DEBUG (0,"state pending %d\n", GST_STATE_PENDING (element));

  /* if going down into NULL state, close the file if it's open */
  switch (GST_STATE_TRANSITION (element)) {
   case GST_STATE_NULL_TO_READY:
     rtp_client_connection (&rtpsend->conn);

     if (rtp_connection_call(&rtpsend->conn,rtpsend->ip,rtpsend->port)) {
       g_print("initialised RTP successfully...\n");
     }
     else {
       g_warning ("couldn't initialise RTP...\n");
       return GST_STATE_FAILURE;
     }
     break;
   case GST_STATE_READY_TO_NULL:
     /*shout_disconnect (&icecastsend->conn);*/
    rtcp_send(&rtpsend->conn);
    break;
   default:
     break;
  }

  /* if we haven't failed already, give the parent class a chance to ;-) */
  if (GST_ELEMENT_CLASS (parent_class)->change_state)
    return GST_ELEMENT_CLASS (parent_class)->change_state (element);

  return GST_STATE_SUCCESS;
}

static gboolean
plugin_init (GModule *module, GstPlugin *plugin)
{
  GstElementFactory *factory;

  factory = gst_elementfactory_new("rtpsend", GST_TYPE_RTPSEND, &rtpsend_details);
  g_return_val_if_fail(factory != NULL, FALSE);

  sink_template = sink_factory ();
  gst_elementfactory_add_padtemplate (factory, sink_template);

  gst_plugin_add_factory (plugin, factory);

  return TRUE;
}

GstPluginDesc plugin_desc = {
  GST_VERSION_MAJOR,
  GST_VERSION_MINOR,
  "rtpsend",
  plugin_init
};
