/* Based on xqcam.c by Paul Chinn <loomer@svpal.org> */
 
#include "config.h"

/* gcc -ansi -pedantic on GNU/Linux causes warnings and errors
 * unless this is defined:
 * warning: #warning "Files using this header must be compiled with _SVID_SOURCE or _XOPEN_SOURCE"
 */
#ifndef _XOPEN_SOURCE
#  define _XOPEN_SOURCE 1
#endif

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xproto.h>
#include <X11/Xmd.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include "gstxwindow.h"

GstXWindow*
gst_xwindow_new (int width, int height)
{
  XGCValues values;
  GstXWindow *new;

  new = g_new0 (GstXWindow, 1);

  new->width=width;
  new->height=height;

  new->disp=XOpenDisplay(NULL);
  if(!new->disp) {
    fprintf(stderr, "open display failed\n"); 
    return NULL;
  }
  
  new->screen=DefaultScreenOfDisplay(new->disp);
  new->screen_num=DefaultScreen(new->disp);
  new->white=XWhitePixel(new->disp,new->screen_num);
  new->black=XBlackPixel(new->disp,new->screen_num);
  
  new->root=DefaultRootWindow(new->disp);
  
  new->win=XCreateSimpleWindow(new->disp,new->root,0,0,new->width,new->height,0,new->white,new->black);
  if(!new->win) {  
    fprintf(stderr, "create window failed\n");
    return(NULL); 
  }
  
  XSelectInput(new->disp, new->win, ExposureMask | StructureNotifyMask);
  
  new->gc = XCreateGC(new->disp, new->win, 0, &values);
  new->depth = DefaultDepthOfScreen(new->screen);

  return (new);
}

void
gst_xwindow_destroy (GstXWindow *window)
{
  g_free (window);
}

void
gst_xwindow_resize (GstXWindow *window, int width, int height)
{
  XResizeWindow (window->disp, window->win, width, height); 
}

