#include "gtk-gui.h"

#include <sys/time.h>
#include <stdio.h>

#include "callbacks.h"
#include "interface.h"
#include "contactlist.h"
#include "view_event_window.h"

void
on_add_user_ok_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget   *add_user_entry;
    GtkWidget   *add_alert_check;
    GtkWidget   *add_user_dialog;
    char        *text;
    long        uin;
    int         alert_user;
    
    add_user_entry = lookup_widget(GTK_WIDGET(button),"add_user_entry");
    add_alert_check = lookup_widget(GTK_WIDGET(button),"add_alert_check");
    add_user_dialog =  lookup_widget(GTK_WIDGET(button),"add_user_dialog");        
    text = gtk_entry_get_text(GTK_ENTRY(add_user_entry));
    alert_user = gtk_toggle_button_get_active(
            GTK_TOGGLE_BUTTON(add_alert_check));
    if (text != NULL) {
        if ((sscanf(text,"%ld",&uin) != 1) || (uin < 0)){
            return;
        }
        
        licq_daemon->AddUserToList(uin);
        gbug("Adding user %ld and alertflag = %d\n",uin,alert_user);
        if (alert_user) {
            licq_daemon->icqAlertUser(uin);
        }
    }

    check_for_autoclose_after_sysevent(add_user_dialog);
    gtk_widget_destroy(add_user_dialog);
}

gboolean
on_add_user_dialog_delete_event        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    check_for_autoclose_after_sysevent(widget);
    gtk_widget_destroy(widget);
    return FALSE;
}


