#include "gtk-gui.h"

#include <sys/time.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>

#include "callbacks.h"
#include "interface.h"
#include "contactlist.h"
#include "functions.h"
#include "view_event_window.h"

void
on_authorize_ok_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *authorize_user_entry=lookup_widget(GTK_WIDGET(button),
            "authorize_user_entry");
    GtkWidget       *authorize_user_dialog=lookup_widget(GTK_WIDGET(button),
            "authorize_user_dialog");
    GtkWidget       *authorize_message_text=lookup_widget(GTK_WIDGET(button),
            "authorize_message_text");
    char            *text;
    unsigned long   uin;
    
    text = gtk_entry_get_text(GTK_ENTRY(authorize_user_entry));
    if (text != NULL) {
        if ((sscanf(text,"%ld",&uin) != 1) ){
            return;
        }
        text=gtk_editable_get_chars(GTK_EDITABLE(authorize_message_text),0,-1);
        
        if(GPOINTER_TO_INT(gtk_object_get_user_data(GTK_OBJECT(button)))) {
            licq_daemon->icqAuthorizeGrant(uin,text);
        }else {
            licq_daemon->icqAuthorizeRefuse(uin,text);
        }
        if(text) {
            g_free(text);
        }
    }
    check_for_autoclose_after_sysevent(authorize_user_dialog);
    gtk_widget_destroy(authorize_user_dialog);
}


gboolean
on_authorize_user_dialog_delete_event  (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    check_for_autoclose_after_sysevent(widget);
    gtk_widget_destroy(widget);
    return FALSE;
}

gboolean
on_authorize_message_text_key_press_event
                                       (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
    GtkWidget       *authorize_ok_button;

    if ((event->state == GDK_CONTROL_MASK) && (event->keyval == GDK_Return)){
        authorize_ok_button=lookup_widget(GTK_WIDGET(widget),
                "authorize_ok_button");
        on_authorize_ok_button_clicked(GTK_BUTTON(authorize_ok_button),NULL);
    }

    return FALSE;
}

GtkWidget *
show_authorize_dialog                  (bool            isgrant, 
                                        unsigned long   uin) 
{
    GtkWidget       *authorize_user_dialog;
    GtkWidget       *authorize_user_entry;
    GtkWidget       *authorize_ok_button;
    gchar           struin[20];

    authorize_user_dialog=create_authorize_user_dialog();
    if(uin) {
        authorize_user_entry=lookup_widget(authorize_user_dialog,
                            "authorize_user_entry");
        g_snprintf(struin,20,"%ld",uin);
        gtk_entry_set_text(GTK_ENTRY(authorize_user_entry),struin);
    }
    authorize_ok_button=lookup_widget(authorize_user_dialog,
            "authorize_ok_button");
    if(!isgrant) {
        gtk_licq_button_set(GTK_BUTTON(authorize_ok_button),
                GTK_LICQ_BUTTON_REFUSE);
    }
    gtk_object_set_user_data(GTK_OBJECT(authorize_ok_button),
            GINT_TO_POINTER(isgrant));
    gtk_widget_show(authorize_user_dialog);

    return authorize_user_dialog;
}
