#include "gtk-gui.h"

#include <sys/time.h>
#include <stdio.h>

#include "licq_sar.h"

#include <gdk/gdkkeysyms.h>

#include "callbacks.h"
#include "interface.h"
#include "contactlist.h"
#include "functions.h"

    /*  Globals */
GtkWidget   *dialog_autoresponse=NULL;

void
autoresponse_button_set_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *autoresponse_message_text=lookup_widget(dialog_autoresponse,
            "autoresponse_message_text");
    gchar           *message;
    ICQOwner        *o;
    ICQUser         *u;
    int             status;
    unsigned long   uin;

    status=GPOINTER_TO_INT(gtk_object_get_user_data(GTK_OBJECT(button))); 
    message=gtk_editable_get_chars(GTK_EDITABLE(autoresponse_message_text),0,-1);
    if((uin=gtk_widget_get_active_uin(GTK_WIDGET(button)))!=
            gUserManager.OwnerUin()) {
        if(!(u=gUserManager.FetchUser(uin,LOCK_W))) {
            return ;
        }
        u->SetCustomAutoResponse(message);
        if(status!=-1) {
            u->SetStatusToUser(status);
        }
        gUserManager.DropUser(u);
    }else {
        if((o=gUserManager.FetchOwner(LOCK_W))) {
            o->SetAutoResponse(message);
            gUserManager.DropOwner();
            if(status!=-1) {
                screensaver_original_status = -1;
                set_status(status);
            }
        }else {
            gbug("Unable to get owner!\n");
        }
    }
    g_free(message);

    gtk_widget_destroy(dialog_autoresponse);
}


void
autoresponse_autoresponse_dialog_show  (GtkWidget       *widget,
                                        gpointer         user_data)
{
    GtkWidget       *autoresponse_message_text=lookup_widget(dialog_autoresponse,
            "autoresponse_message_text");
    GtkWidget       *button_set=lookup_widget(dialog_autoresponse,
            "button_set");
    gchar           *message=NULL;
    ICQUser         *u;
    gint            pos=0;
    unsigned long   uin;
    int             status;


    gtk_widget_realize(widget);
    gtk_widget_set_events (widget, GDK_BUTTON_PRESS_MASK);
    gtk_editable_delete_text(GTK_EDITABLE(autoresponse_message_text),0,-1);
    status=GPOINTER_TO_INT(gtk_object_get_user_data(
                GTK_OBJECT(button_set)));

    if((uin=gtk_widget_get_active_uin(widget))!=gUserManager.OwnerUin()) {
        if(!(u=gUserManager.FetchUser(uin,LOCK_R))) {
            return ;
        }
        if(!u->CustomAutoResponse()||!strlen(u->CustomAutoResponse())) {
            message=g_strdup_printf(_("I am currently %s"),
                    status!=-1?status_string(status,TRUE):_("unavailable"));
        }else {
            gtk_editable_insert_text(GTK_EDITABLE(autoresponse_message_text),
                    u->CustomAutoResponse(), strlen(u->CustomAutoResponse()),
                    &pos); 
        }
        gUserManager.DropUser(u);
    }else {
        u=gUserManager.FetchOwner(LOCK_R);
        if(!u->AutoResponse()||!strlen(u->AutoResponse())) {
            message=g_strdup_printf(_("I am currently %s"),
                    status!=-1?status_string(status,TRUE):_("unavailable"));
        }else {
            gtk_editable_insert_text(GTK_EDITABLE(autoresponse_message_text),
                    u->AutoResponse(), strlen(u->AutoResponse()),&pos); 
        }
        gUserManager.DropOwner();
    }
    if(message) {
        gtk_editable_insert_text(GTK_EDITABLE(autoresponse_message_text),message,
                strlen(message),&pos); 
        g_free(message);
    } 
    gtk_editable_select_region(GTK_EDITABLE(autoresponse_message_text),0,-1);
    gtk_widget_grab_focus(autoresponse_message_text);    
}

void
autoresponse_autoresponse_dialog_destroy
                                        (GtkObject       *widget,
                                        gpointer         user_data)
{
    dialog_autoresponse=NULL; 
}

void
autoresponse_sar_activate              (GtkMenuItem *mitem,
                                        GtkWidget   *autoresponse_message_text)
{
    SARList         sarlist;
    SARListIter     sariter;
    gint            pos=0;

    sarlist=gSARManager.Fetch(GPOINTER_TO_INT(
                gtk_object_get_user_data(GTK_OBJECT(dialog_autoresponse))));
    gtk_text_freeze(GTK_TEXT(autoresponse_message_text));
    gtk_editable_delete_text(GTK_EDITABLE(autoresponse_message_text),0,-1);
    sariter=sarlist.begin()+GPOINTER_TO_INT(gtk_object_get_user_data(
            GTK_OBJECT(mitem)));
    gtk_editable_insert_text(GTK_EDITABLE(autoresponse_message_text),
            (*sariter)->AutoResponse(),
            strlen((*sariter)->AutoResponse()),&pos);
    gtk_text_thaw(GTK_TEXT(autoresponse_message_text));

    gSARManager.Drop();
}

void
set_status_with_message    (int status,
                            unsigned long uin)
{
    GtkWidget       *button_set, *button_clear;
    GtkWidget       *optionmenu_predefined;
    GtkWidget       *autoresponse_message_text;

    SARList         sarlist;
    SARListIter     sariter;
    GtkWidget       *menu,*menuitem;
    gchar           *btntext=NULL;
    short           what;
    gint            ndx=0;
    ICQUser         *u=NULL;


    if(uin!=gUserManager.OwnerUin()) {
        if(!(u=gUserManager.FetchUser(uin,LOCK_R))) {
            return ;
        }
        if(status!=-1) {
            if(u->StatusToUser()==status) {
                u->SetStatusToUser(ICQ_STATUS_OFFLINE);
                gUserManager.DropUser(u);
                return;
            }
        }
    }
    if(dialog_autoresponse) {
        gdk_window_raise(dialog_autoresponse->window);
    }else {
        dialog_autoresponse=create_autoresponse_dialog();
        gtk_window_set_default_size(GTK_WINDOW(dialog_autoresponse),250,190);
    }
    button_set=lookup_widget(dialog_autoresponse,"button_set");
    optionmenu_predefined=lookup_widget(dialog_autoresponse,
            "optionmenu_predefined");
    button_clear=lookup_widget(dialog_autoresponse,"button_clear");
    gtk_widget_set_active_uin(dialog_autoresponse,uin);
    if(uin!=gUserManager.OwnerUin()) {
        btntext=g_strdup_printf(_("Custom autoresponse for %s"),u->GetAlias());
        gtk_window_set_title(GTK_WINDOW(dialog_autoresponse),btntext);
        g_free(btntext);
        if(status!=-1) {
            btntext=g_strdup_printf(_("%s to %s"),status_string(status,TRUE),
                    u->GetAlias());
        }else {
            btntext=g_strdup_printf(_("Autoresponse to %s"),
                    u->GetAlias());
        }
        gUserManager.DropUser(u);
        gtk_widget_show(button_clear);
    }else {
        if(status!=-1) {
            btntext=g_strdup_printf(_("Set %s"),status_string(status,TRUE));
        }else {
            btntext=g_strdup("");
        }
        gtk_widget_hide(button_clear);
    }
    gtk_object_set_user_data(GTK_OBJECT(button_set),
            GINT_TO_POINTER(status));

    gtk_licq_button_set(GTK_BUTTON(button_set),btntext);
    g_free(btntext);
    switch(status) {
        case ICQ_STATUS_AWAY:
            what=SAR_AWAY;
            break;
        case ICQ_STATUS_NA:
            what=SAR_NA;
            break;
        case ICQ_STATUS_DND:
            what=SAR_DND;
            break;
        case ICQ_STATUS_OCCUPIED:
            what=SAR_OCCUPIED;
            break;
        case ICQ_STATUS_FREEFORCHAT:
            what=SAR_FFC;
            break;
        default:
            what=-1;
            break;
    }
    gtk_object_set_user_data(GTK_OBJECT(dialog_autoresponse),
            GINT_TO_POINTER(what));
    if(what>=0) {
        menu=gtk_menu_new();
        gtk_widget_ref(menu);
        sarlist=gSARManager.Fetch(what);
        for(sariter=sarlist.begin();sariter!=sarlist.end();sariter++,ndx++) {
            if(strlen((*sariter)->Name())>25) {
                btntext=g_strdup_printf("%22.22s...",(*sariter)->Name());
                menuitem=gtk_menu_item_new_with_label(btntext);
                g_free(btntext);
            }else {
                menuitem=gtk_menu_item_new_with_label((*sariter)->Name());
            }
            gtk_object_set_user_data(GTK_OBJECT(menuitem),
                    GINT_TO_POINTER(ndx));
            autoresponse_message_text=lookup_widget(dialog_autoresponse,
                    "autoresponse_message_text");
            gtk_signal_connect(GTK_OBJECT(menuitem),"activate",
                    GTK_SIGNAL_FUNC(autoresponse_sar_activate),
                    autoresponse_message_text);
            gtk_widget_ref(menuitem);
            gtk_menu_append(GTK_MENU(menu),menuitem);
        }
        gSARManager.Drop();
        gtk_widget_show_all(menu);
        gtk_option_menu_set_menu(GTK_OPTION_MENU(optionmenu_predefined), menu);
        gtk_option_menu_set_history(GTK_OPTION_MENU(optionmenu_predefined), 0);
        gtk_widget_show(optionmenu_predefined);
    }else {
        gtk_widget_hide(optionmenu_predefined);
    }
    if(!GTK_WIDGET_VISIBLE(dialog_autoresponse)) {
        gtk_widget_show(dialog_autoresponse);
    }
}

gboolean
on_autoresponse_dialog_delete_event    (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    gtk_widget_destroy(widget);
    return FALSE;
}

void
autoresponse_set_new_mode              (GtkWidget       *button,
                                        gpointer        user_data)
{
    set_status_with_message(GPOINTER_TO_INT(user_data),
            gtk_widget_get_active_uin(button));
}


void
autoresponse_dummy_detach_func         (GtkWidget *attach_widget,
                                        GtkMenu *menu)
{
}

gboolean
on_button_set_button_press_event       (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer        user_data)
{
    GtkWidget       *popup;

    if(event->button==3) {
        popup=create_status_menu(
                GTK_SIGNAL_FUNC(autoresponse_set_new_mode),
                GTK_SIGNAL_FUNC(autoresponse_set_new_mode),
                FALSE,FALSE,FALSE);
        gtk_menu_attach_to_widget(GTK_MENU(popup),dialog_autoresponse,
                autoresponse_dummy_detach_func);
        gtk_menu_popup(GTK_MENU(popup),NULL,NULL,NULL,0,0,0);
    }
    return FALSE;
}

void
on_button_clear_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
    unsigned long       uin;
    ICQUser             *u;
    GtkWidget           *autoresponse_message_text=lookup_widget(
            GTK_WIDGET(button),"autoresponse_message_text");

    uin=gtk_widget_get_active_uin(GTK_WIDGET(button));
    if((u=gUserManager.FetchUser(uin,LOCK_W))) {
        if(u->Uin()==gUserManager.OwnerUin()) {
            u->SetAutoResponse(NULL);
        }else {
            u->ClearCustomAutoResponse();
        }
        gUserManager.DropUser(u);
        gtk_editable_delete_text(GTK_EDITABLE(autoresponse_message_text),0,-1);
    }
}

gboolean
on_autoresponse_dialog_key_press_event (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
    if (event->state & GDK_CONTROL_MASK) {
        switch(event->keyval) {
            case GDK_Return:
                GtkWidget *button_set=lookup_widget(dialog_autoresponse,
                        "button_set");
                gtk_signal_emit_by_name(GTK_OBJECT(button_set),
                        "clicked");
                break;
        }
    }


    return FALSE;
}

gboolean
on_autoresponse_dialog_message_key_press_event   
                                       (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
    if(event->keyval==GDK_Tab) {
        if(event->state & GDK_SHIFT_MASK) {
            gtk_container_focus(GTK_CONTAINER(gtk_widget_get_toplevel(widget)),
                    GTK_DIR_TAB_BACKWARD);
            return TRUE;
        }else if((event->state & GDK_MODIFIER_MASK) == 0) {
            gtk_container_focus(GTK_CONTAINER(gtk_widget_get_toplevel(widget)),
                    GTK_DIR_TAB_FORWARD);
            return TRUE;
        }
    }
    return FALSE;
}
