#include "gtk-gui.h"

#include <sys/time.h>
#include <stdio.h>

#include "licq_log.h"
#include <gdk/gdkkeysyms.h>

#include "interface.h"
#include "contactlist.h"
#include "autoresponse.h"
#include "network_dialog.h"
#include "randomchat_dialog.h"
#include "user_popup.h"
#include "authorize_user_dialog.h"
#include "functions.h"
#include "view_event_window.h"
#include "send_event_window.h"
#include "user_info_dialog.h"
#include "history_dialog.h"
#include "search_dialog.h"
#include "registration_wizard.h"


    /*  Globals */
GtkWidget       *groups_dialog=NULL;
struct timeval  dclick;

void
on_view_system_messages1_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    ICQOwner        *owner;

    owner=gUserManager.FetchOwner(LOCK_R);
    if(owner->NewMessages()) {
        gUserManager.DropOwner();
        popup_user_event_window(0,MODE_VIEW,SEND_MESSAGE);
    }else {
        gUserManager.DropOwner();
        show_history_dialog_for_user(0);
    }
}


void
on_general_info1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    show_info_dialog_for_user(0,GENERAL_INFO_PAGE);
}


void
on_more_info1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    show_info_dialog_for_user(0,MORE_INFO_PAGE);
}


void
on_work_info1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    show_info_dialog_for_user(0,WORK_INFO_PAGE);
}


void
on_about2_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    show_info_dialog_for_user(0,ABOUT_INFO_PAGE);
}

void
on_last_seen2_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    show_info_dialog_for_user(0,LAST_INFO_PAGE);
}


void
on_licq1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    show_info_dialog_for_user(0,LICQ_INFO_PAGE);
}


void
on_history1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    show_history_dialog_for_user(0);
}


void
on_change_password1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    if(!passwd_dialog) {
        passwd_dialog = create_passwd_dialog();
        gtk_widget_show(passwd_dialog);
    }else {
        gdk_window_raise(passwd_dialog->window);
    }
}


void
on_debug_level1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget   *status_info=lookup_widget(main_window,"status_info1");
    GtkWidget   *unknown_packets=lookup_widget(main_window,"unknown_packets1");
    GtkWidget   *errors=lookup_widget(main_window,"errors1");
    GtkWidget   *warnings=lookup_widget(main_window,"warnings1");
    GtkWidget   *packets=lookup_widget(main_window,"packets1");
    int         debug_level;

    debug_level=gLog.ServiceLogTypes(S_STDOUT);
        /*  Bad kludge, but the freakin thing emits signals while doing
            this, so in order to prevent reversal of settings ... */
    do_nothing=1;
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(status_info), 
            debug_level&L_INFO);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(unknown_packets), 
            debug_level&L_UNKNOWN);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(errors), 
            debug_level&L_ERROR);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(warnings), 
            debug_level&L_WARN);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(packets), 
            debug_level&L_PACKET);
    do_nothing=0;
}


void
on_debughandlers_toggled               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    if(do_nothing) {
        return ;
    }
    if(!GTK_CHECK_MENU_ITEM(menuitem)->active) {
        gLog.RemoveLogTypeFromService(S_STDOUT,
                GPOINTER_TO_INT(gtk_object_get_user_data(GTK_OBJECT(menuitem))));
    }else {
        gLog.AddLogTypeToService(S_STDOUT,
                GPOINTER_TO_INT(gtk_object_get_user_data(GTK_OBJECT(menuitem))));
    }
}


void
on_set_all1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    gLog.ModifyService(S_STDOUT, L_ALL);
}


void
on_clear_all1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    gLog.ModifyService(S_STDOUT, L_NONE);
}


void
on_add_user1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget *add_user_dialog;

    add_user_dialog = create_add_user_dialog();
    gtk_widget_show(add_user_dialog);
}


void
on_search_for_user1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    show_search_dialog();
}


void
on_authorize_user1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    show_authorize_dialog(TRUE,0);
}


void
on_random_chat1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    show_random_chat_dialog(FALSE);
}


void
on_edit_groups1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    if(!groups_dialog) {
        groups_dialog = create_groups_dialog();
        gtk_widget_show(groups_dialog);
    }else {
        gdk_window_raise(groups_dialog->window);
    }
}


void
on_save_all_users1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    gUserManager.SaveAllUsers();
}

void
on_update_all_users1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    FOR_EACH_USER_START(LOCK_R);
    licq_daemon->icqRequestMetaInfo(pUser->Uin());
    FOR_EACH_USER_END;
}




void
on_register_user1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    if(!registration_wizard_window) {
        register_new_user();
    }else {
        gdk_window_raise(registration_wizard_window->window);
    }
}


void
on_set_auto_response_1_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget       *button_set;
    GtkWidget       *optionmenu_predefined;
    GtkWidget       *button_clear;

    if(dialog_autoresponse) {
        gdk_window_raise(dialog_autoresponse->window);
        return;
    }
    dialog_autoresponse=create_autoresponse_dialog();
    gtk_window_set_default_size(GTK_WINDOW(dialog_autoresponse),250,190);
    optionmenu_predefined=lookup_widget(dialog_autoresponse,
            "optionmenu_predefined");
    button_clear=lookup_widget(dialog_autoresponse,
            "button_clear");
    button_set=lookup_widget(dialog_autoresponse,"button_set");

    gtk_licq_button_set(GTK_BUTTON(button_set), GTK_LICQ_BUTTON_OK);
    gtk_object_set_user_data(GTK_OBJECT(button_set),GINT_TO_POINTER(-1));
    gtk_widget_hide(optionmenu_predefined);
    gtk_widget_set_active_uin(dialog_autoresponse,gUserManager.OwnerUin());
    gtk_widget_hide(button_clear);
    gtk_widget_show(dialog_autoresponse);
}


void
on_show_network_window1_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    show_network_window();
}


void
on_use_mini_mode1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
     GtkWidget      *scrolledwindow_contactlist = lookup_widget(main_window,
             "scrolledwindow_contactlist");
     GtkWidget      *group_menu  = lookup_widget(main_window,"group_menu");
     static gint    width=0,height=0;    

     
     if(GTK_CHECK_MENU_ITEM(menuitem)->active){
         gdk_window_get_size(main_window->window,&width,&height);
         gtk_window_set_policy(GTK_WINDOW(main_window),1,0,1);
         if(GTK_WIDGET_VISIBLE(group_menu)) {
             gtk_widget_hide(GTK_WIDGET(group_menu));
         }
         gtk_widget_hide(GTK_WIDGET(scrolledwindow_contactlist));

     } else {
         gtk_window_set_policy(GTK_WINDOW(main_window),0,1,0);
         if(configuration.showgroupmenu&&!GTK_WIDGET_VISIBLE(group_menu)) {
             gtk_widget_show(GTK_WIDGET(group_menu));
         }
         gtk_widget_show_all(GTK_WIDGET(scrolledwindow_contactlist));
         /* GDK_THREADS_LEAVE();
         while(g_main_iteration(FALSE)) ;
         GDK_THREADS_ENTER();*/
         gtk_window_set_policy(GTK_WINDOW(main_window),1,1,0);
         gdk_window_resize(main_window->window,width,height);
     }
}


void
on_show_offline_users1_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    configuration.showofflineusers=GTK_CHECK_MENU_ITEM(menuitem)->active;
    refresh_contactlist(contactlist_current_group);
}


void
on_options1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    if(!options_window) {
        options_window=create_options_window();
        gtk_widget_show(options_window);
    }else {
        gdk_window_raise(options_window->window);
    }
}


void
on_plugin_manager1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    if(!plugin_dialog) {
        plugin_dialog = create_plugin_dialog();
        gtk_widget_show(plugin_dialog);
    }else {
        gdk_window_raise(plugin_dialog->window);
    }
}


void
on_next_server1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    licq_daemon->SwitchServer();
}


void
on_help1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
#ifdef USE_GNOME_HELP_BROWSER
    gnome_help_goto (NULL, "ghelp:gtk+licq");
#else
    gchar *url;
    url = g_strconcat ("file://",HELP_FILE_PATH,"/index.html",NULL);
    view_url(url); 
    g_free (url);
#endif
}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget   *about_dialog;

    about_dialog=create_about_dialog();
    gtk_widget_show(about_dialog);
}


void
on_exit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    licq_daemon->icqLogoff(); 
    licq_daemon->Shutdown();
}

gboolean
on_alias_clist_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
    int             row,col;
    struct timeval  tmp_time;
    GtkWidget       *user_popup;
    userdata_t      *userdata;
    long            td;
    unsigned long   current_uin;

    gtk_clist_get_selection_info(GTK_CLIST(widget),(int) event->x,
            (int) event->y,&row,&col);

    if(!gtk_clist_get_row_data(GTK_CLIST(widget), row)||
            row>gtk_clist_get_length(GTK_CLIST(widget))) {
        return FALSE;
    }
    userdata=(userdata_t*)gtk_clist_get_row_data(GTK_CLIST(widget), row);
    current_uin=userdata->uin;
    gtk_widget_set_active_uin(main_window,current_uin);
    if (event->button==3){
        if(configuration.showactiveuser) {
            gtk_clist_select_row(GTK_CLIST(widget),row,-1);
        }
        if((user_popup=create_user_popup_menu(current_uin,NULL))) {
            gtk_menu_popup (GTK_MENU (user_popup), NULL, NULL, NULL, NULL,
                    3, event->time);
        }
    } else if (event->button == 1){
        if(configuration.showactiveuser) {
            gtk_clist_select_row(GTK_CLIST(widget),row,-1);
        }
        gettimeofday(&tmp_time,NULL);
        td = time_diff(&tmp_time,&dclick);
        dclick.tv_sec = tmp_time.tv_sec;
        dclick.tv_usec = tmp_time.tv_usec;
        if (((event->type == GDK_2BUTTON_PRESS) && 
                    (!configuration.singleclick)) ||
                ((event->type == GDK_BUTTON_PRESS) && 
                 (td > DCLICK_DELAY) && //prevent from doubleclick!
                 (configuration.singleclick))){
            popup_user_event_window(current_uin,MODE_UNSPEC,SEND_MESSAGE); 
        }
    }

    return FALSE;
}

gboolean
on_statusbar_button_press_event        (GtkWidget       *widget,
        GdkEventButton  *event,
        gpointer         user_data)
{
    GtkWidget       *status1=lookup_widget(main_window,"status1");
    GtkWidget       *status_menu;
    ICQOwner        *owner;
    unsigned short  tmp_status;
    struct timeval  tmp_time;
    long            td;
     
    if (event->button==3) {
        status_menu = GTK_MENU_ITEM(status1)->submenu;
        gtk_widget_show(status_menu);
        gtk_menu_popup (GTK_MENU (status_menu), NULL, NULL, NULL, NULL, 
                event->button, event->time);
    } else if (event->button == 1) {
            gettimeofday(&tmp_time,NULL);
            td = time_diff(&tmp_time,&dclick);
            dclick.tv_sec = tmp_time.tv_sec;
            dclick.tv_usec = tmp_time.tv_usec;
            if (((event->type == GDK_2BUTTON_PRESS) && 
                        (!configuration.singleclick)) ||
                    ((event->type == GDK_BUTTON_PRESS) && 
                     (td > DCLICK_DELAY) && //prevent from doubleclick!
                     (configuration.singleclick))){
                gbug("Toggle status to %s\n",status_string(last_status,false));
                set_status(last_status);

                /* Reset the autoback function so that it will not
                 * override our status */
                screensaver_original_status = -1;
            }
    }
    return FALSE;
}


gboolean
on_system_message_button_press_event   (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
    GtkWidget       *event_window;
    GtkWidget       *notebook;
    struct timeval  tmp_time;
    ICQOwner        *owner = NULL;
    unsigned int    tmpuin = 0;
    long            td;
    
    if (event->button==1){
        gettimeofday(&tmp_time,NULL);
        td = time_diff(&tmp_time,&dclick);
        dclick.tv_sec = tmp_time.tv_sec;
        dclick.tv_usec = tmp_time.tv_usec;
        if (((event->type == GDK_2BUTTON_PRESS) && 
                    (!configuration.singleclick)) ||
                ((event->type == GDK_BUTTON_PRESS) && 
                 (td > DCLICK_DELAY) && //prevent from doubleclick!
                 (configuration.singleclick))){

            popup_system_messages();

        }
    }

  return FALSE;
}


void
on_change_randomchat_group1_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    show_random_chat_dialog(TRUE);
}

gboolean
on_main_window_key_press_event          (GtkWidget       *widget,
                                         GdkEventKey     *event,
                                         gpointer         user_data)
{
    static char         *line = NULL; 
    static unsigned int maxlen = 0;
    GList               *rows;
    int                 rs;
    
    if ((event->state == 0) || (event->state & GDK_SHIFT_MASK)) {
        switch (event->keyval) {
            case GDK_Shift_L:
            case GDK_Shift_R:
            case GDK_Control_L:
            case GDK_Control_R:
            case GDK_Meta_L:
            case GDK_Meta_R:
            case GDK_Alt_L:
            case GDK_Alt_R:
            case GDK_Caps_Lock:
            case GDK_Shift_Lock:
                break;

            case GDK_Escape:
                if(line) {
                    memset(line,0,strlen(line));
                }
                find_and_mark_as_current(line);
                break;
                
            case GDK_F1:
                {
                    GtkWidget *item = lookup_widget(widget, "system1");
                    GtkWidget *menubar = lookup_widget(widget, "menubar1");
                    gtk_signal_emit_by_name(GTK_OBJECT(item),"activate-item");
                    gbug("F1\n");
                }
                break;
                
            case GDK_KP_Enter:
            case GDK_Return:
                if(line) {
                    memset(line,0,strlen(line));
                    popup_user_event_window(
                            gtk_widget_get_active_uin(main_window),
                            MODE_UNSPEC,SEND_MESSAGE);
                }
                break;

            case GDK_BackSpace:
                if (line && strlen(line) > 0){
                    line[strlen(line)-1] = '\0';
                }
                find_and_mark_as_current(line);
                break;
            case GDK_Left:
            case GDK_Up:
                {
                    GtkWidget *alias_clist=lookup_widget(
                            widget,"alias_clist");
                    char *text;
                    userdata_t *userdata;

                    rows=GTK_CLIST(alias_clist)->selection; 
                    if(rows&&(rs=GPOINTER_TO_INT(rows->data))>0) {
                        if (gtk_clist_get_text(GTK_CLIST(alias_clist),rs-1,
                                    configuration.quicksearchcol,&text)) {
                            g_free(line);
                            line = g_strdup(text);
                            maxlen = strlen(text);
                        } else {
                            memset(line,0,strlen(line));
                        }
                        userdata = (userdata_t*) gtk_clist_get_row_data(
                                GTK_CLIST(alias_clist), rs-1);
                        gtk_widget_set_active_uin(main_window,userdata->uin);
                        if(configuration.showactiveuser) {
                            gtk_clist_select_row(GTK_CLIST(alias_clist),
                                    rs-1,-1);
                            gtk_clist_moveto(GTK_CLIST(alias_clist),
                                    rs-1,1,0.5,0);
                        }
                    }
                }
                break;
            case GDK_Right:
            case GDK_Down:
                {
                    GtkWidget *alias_clist=lookup_widget(
                            widget,"alias_clist");
                    char *text;
                    userdata_t *userdata;
                    
                    rows=GTK_CLIST(alias_clist)->selection; 
                    if(rows&&((rs=GPOINTER_TO_INT(rows->data))<
                            (gtk_clist_get_length(GTK_CLIST(alias_clist))-1))) {
                        if (gtk_clist_get_text(GTK_CLIST(alias_clist),rs+1,
                                    configuration.quicksearchcol,&text)) {
                            g_free(line);
                            line = g_strdup(text);
                            maxlen = strlen(line);
                        } else {
                            memset(line,0,strlen(line));
                        }

                        userdata = (userdata_t*) gtk_clist_get_row_data(
                                GTK_CLIST(alias_clist), rs+1);
                        gtk_widget_set_active_uin(main_window,userdata->uin);
                        if(configuration.showactiveuser) {
                            gtk_clist_select_row(GTK_CLIST(alias_clist),
                                    rs+1,-1);
                            gtk_clist_moveto(GTK_CLIST(alias_clist),
                                    rs+1,1,0.5,0);
                        }
                    } else if (!rows){
                        if (gtk_clist_get_length(GTK_CLIST(alias_clist)) > 0) {
                            userdata = (userdata_t*) gtk_clist_get_row_data(
                                    GTK_CLIST(alias_clist), 0);
                            gtk_widget_set_active_uin(main_window,userdata->uin);
                            if(configuration.showactiveuser) {
                                gtk_clist_select_row(GTK_CLIST(alias_clist),
                                        0,-1);
                                gtk_clist_moveto(GTK_CLIST(alias_clist),
                                        0,1,0.5,0);
                            }
                        }
                    }
                }
                break;
            default:
                if (line == NULL) {
                    if((line = (char *) malloc(40)) == NULL) {
                        maxlen = 0;
                        return FALSE;
                    }
                    memset(line,0,40);
                    maxlen = 40;
                }

                if (strlen(line) >= maxlen) {
                    if((line = (char *) realloc(line,maxlen + 40)) == NULL) {
                        maxlen = 0;
                        return FALSE;
                    }
                    maxlen += 40;
                }

                strcat(line,event->string);
                find_and_mark_as_current(line);
                gbug("%s\n",line);
                break;
        }
    } else if (event->state & GDK_CONTROL_MASK) {
        switch (event->keyval) {
            case GDK_q:
                licq_daemon->icqLogoff();
                licq_daemon->Shutdown();
                //gtk_plugin_terminate();
                break;
            case GDK_s:
                {
                    GtkWidget       *systemmenu_menubar=lookup_widget(widget,
                            "systemmenu_menubar");
                    GtkWidget       *system1=lookup_widget(widget,"system1");

                    gbug("mojj\n");

                    gtk_menu_shell_select_item(GTK_MENU_SHELL(systemmenu_menubar),
                            system1);
                }
                break;
        }
    }
    return FALSE;
}

void
on_contacts_clist_select_row           (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    GtkWidget       *event_2_button=lookup_widget(GTK_WIDGET(clist),
            "event_2_button");
    gchar           *text;
    unsigned long   uin=0;
    ICQUser         *user;

    gtk_clist_get_text(clist,row,0,&text);
    if(sscanf(text,"%ld",&uin)) {
        if(uin&&(user=gUserManager.FetchUser(uin,LOCK_R))) {
            gUserManager.DropUser(user);
            uin=0;
        }
    }
    gtk_widget_set_sensitive(event_2_button,(uin?TRUE:FALSE));
}



void
on_window_destroy_get_posdata          (GtkObject       *object,
                                        gpointer         user_data)
{
    windowposdata_t *data=(windowposdata_t*)user_data;
    GtkWidget       *alias_clist;

    GETWINDOWPOSDATA(GTK_WIDGET(object),*data);
    if(lookup_widget(GTK_WIDGET(object),"send_event_window")&&
            (alias_clist=lookup_widget(GTK_WIDGET(object),"alias_clist"))) {
        if(data->width>alias_clist->allocation.width) {
            data->width-=alias_clist->allocation.width;
        }
    }
}


void
on_window_show_set_posdata             (GtkWidget       *widget,
                                        gpointer         user_data)
{
    windowposdata_t        *data=(windowposdata_t*)user_data;

    if(HASWINDOWPOSDATA(*data)) {
        gbug("on_window_show_set_posdata: %dx%d@%d.%d\n", data->width,data->height,data->x,data->y);
//        gtk_window_set_position(GTK_WINDOW(widget),GTK_WIN_POS_NONE);
        SETWINDOWPOSDATA(widget,*data);
    }else {
        //gtk_window_set_position(GTK_WINDOW(widget),GTK_WIN_POS_CENTER);
    }
}

void
on_options_browse_default_foreground_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_options_browse_default_background_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{

}

