#include "gtk-gui.h"

#include "functions.h"
#include "contactlist.h"
#include "gnomedock.h"
#include "user_popup.h"

#include <sys/time.h>
#include <unistd.h>

    /*  Globals */
int         contactlist_current_group;

    /*  Forwards */ 
void on_group_menu_clicked             (GtkButton       *button,
                                        gpointer        user_data);

extern bool         blinkfunctionactive;


gint
contactlist_sort                       (GtkCList        *clist,
                                        GtkCListRow     *ptr1,
                                        GtkCListRow     *ptr2)
{
    ICQUser     *user1,*user2;
    gint        ret=0;

    user1=gUserManager.FetchUser(((userdata_t*)(ptr1->data))->uin,LOCK_R);
    user2=gUserManager.FetchUser(((userdata_t*)(ptr2->data))->uin,LOCK_R);
    if(user1&&user2) {
        if(!(ret=get_sort_index(user1,user2,configuration.sortlist[0]))&&
                configuration.sortlist[1]) {
            if(!(ret=get_sort_index(user1,user2,configuration.sortlist[1]))&&
                    configuration.sortlist[2]) {
                ret=get_sort_index(user1,user2,configuration.sortlist[2]);
            }
        }
    }
    if(user1) {
        gUserManager.DropUser(user1);
    }
    if(user2) {
        gUserManager.DropUser(user2);
    }
    return ret;
}

void 
refresh_contactlist                    (unsigned int
                                                    group)
{
    GtkWidget       *contactlist=lookup_widget(main_window, 
            "alias_clist");

    if(!contactlist) {
        return ;
    }
    real_refresh_contactlist(group,contactlist,TRUE,NULL);

    refresh_eventwindows_contactlists();
    refresh_floating_windows();
}

void 
real_refresh_contactlist               (unsigned int
                                                    group,
                                        GtkWidget   *contactlist,
                                        gboolean    ismainlist,
                                        GList       *selection)
{
    userdata_t      *oldata;
    GroupType       gtype=GROUPS_USER;
    GList           *f_active;
    gint            row=-1;
    ICQUser         *user;
    unsigned long   uin;

    if(group>gUserManager.NumGroups()) {
        gtype=GROUPS_SYSTEM;
        group-=gUserManager.NumGroups();
    }
        /*  Pause updating and set new contents */ 
    gtk_clist_freeze(GTK_CLIST(contactlist));
        /*  FIXME: Clear list and rebuild it, so deleted used can 
            actually dissapear */

    FOR_EACH_USER_START(LOCK_R);
        row=-1;
        oldata=real_find_user_data(contactlist,pUser->Uin(),&row);
        real_refresh_contactlist_single_user(group,gtype,contactlist,
                ismainlist,oldata,selection,pUser,row);
    FOR_EACH_USER_END;
        /*  Now do it backwards, check each list entry in order to find 
            user who no longer exists */
    for(row=gtk_clist_get_length(GTK_CLIST(contactlist));row>=0;row--) {
        oldata=(userdata_t*)gtk_clist_get_row_data(GTK_CLIST(contactlist),row);
        if(oldata) {
            uin=oldata->uin;
            if(!(user=gUserManager.FetchUser(uin,LOCK_N))) {
                gtk_clist_remove(GTK_CLIST(contactlist),row);
                row++;
            }
        }
    }
    if(selection) {
        g_list_foreach(selection,g_list_foreach_destroy,NULL);
        g_list_free(selection);
    }
    gtk_clist_sort(GTK_CLIST(contactlist));
    gtk_clist_thaw(GTK_CLIST(contactlist));
}

int
add_group_to_grouplist                 (GtkWidget   *new_menu,
                                        GtkSignalFunc 
                                                    func,
                                        const gchar *title,
                                        int         id) 
{
    GtkWidget       *menuitem;

    if(new_menu) {
        if(!title) {
            menuitem=gtk_menu_item_new(); 
            gtk_widget_set_sensitive(menuitem,FALSE);
        }else {
            menuitem=gtk_menu_item_new_with_label(title); 
            gtk_object_set_user_data(GTK_OBJECT(menuitem),GINT_TO_POINTER(id));
            gtk_signal_connect(GTK_OBJECT(menuitem),"activate",
                    func, GINT_TO_POINTER(id));
        }
        gtk_widget_show(menuitem);
        gtk_menu_append(GTK_MENU(new_menu),menuitem);
    }
    return 0;
}

void 
refresh_grouplist()
{
    GtkWidget       *optionmenu=lookup_widget(main_window, "group_menu");
    GtkWidget       *option_new_menu;
    GroupList       *groups;
    unsigned int    i;
    GList           *menuitems;
    gint            index=0;

        /* create a menu and swap e'm l8er */ 
    option_new_menu=GTK_WIDGET(gtk_menu_new());
    add_group_to_grouplist(option_new_menu, 
            GTK_SIGNAL_FUNC(on_group_menu_clicked), _("All users"), 0);
    add_group_to_grouplist(option_new_menu, NULL, NULL, 0);
    add_group_to_grouplist(option_new_menu, 
            GTK_SIGNAL_FUNC(on_group_menu_clicked), _("Online notify"),
            gUserManager.NumGroups()+GROUP_ONLINE_NOTIFY);
    add_group_to_grouplist(option_new_menu, 
            GTK_SIGNAL_FUNC(on_group_menu_clicked), _("Visible list"),
            gUserManager.NumGroups()+GROUP_VISIBLE_LIST);
    add_group_to_grouplist(option_new_menu, 
            GTK_SIGNAL_FUNC(on_group_menu_clicked), _("Invisible list"),
            gUserManager.NumGroups()+GROUP_INVISIBLE_LIST);
    add_group_to_grouplist(option_new_menu, 
            GTK_SIGNAL_FUNC(on_group_menu_clicked), _("Ignore list"),
            gUserManager.NumGroups()+GROUP_IGNORE_LIST);
    add_group_to_grouplist(option_new_menu, 
            GTK_SIGNAL_FUNC(on_group_menu_clicked), _("New users"),
            gUserManager.NumGroups()+GROUP_NEW_USERS);
    add_group_to_grouplist(option_new_menu, NULL, NULL, 0);

    groups=gUserManager.LockGroupList(LOCK_R);
    if(groups) {
        for (i=0;i<groups->size();i++)
        { 
            add_group_to_grouplist(option_new_menu,
                    GTK_SIGNAL_FUNC(on_group_menu_clicked),
                    (*groups)[i],i+1);
        }
    }
    gUserManager.UnlockGroupList();
        /*  This also destroys the old menu */ 
    gtk_option_menu_set_menu(GTK_OPTION_MENU(optionmenu),option_new_menu);
    menuitems=gtk_container_children(GTK_CONTAINER(option_new_menu));
    while(menuitems) {
        if(GPOINTER_TO_INT(
                    gtk_object_get_user_data(
                        GTK_OBJECT(menuitems->data)))==contactlist_current_group) {
            gtk_option_menu_set_history(GTK_OPTION_MENU(optionmenu),index); 
            break;
        }
        index++;
        menuitems=g_list_next(menuitems);
    }
    if(!menuitems) {
        gtk_option_menu_set_history(GTK_OPTION_MENU(optionmenu),0);
        contactlist_current_group=0;
    }
}

bool 
contactlist_signal_callback            (CICQSignal  *signal, 
                                        gpointer    data)
{
    ICQUser     *user;

    gbug("contactlist_signal_callback: enter\n");
    if(!signal) {
        return FALSE;
    }
    switch(signal->Signal()) {
        case SIGNAL_UPDATExUSER:
            switch(signal->SubSignal()) {
                case USER_STATUS:
#ifdef DEBUG
                    if((user=gUserManager.FetchUser(signal->Uin(),LOCK_R))) {
                        gbug("User %s has status %s\n",user->GetAlias(),user->StatusStr());
                        gUserManager.DropUser(user);
                    }
#endif
                    if (signal->Uin() == gUserManager.OwnerUin()) {
                        update_status_display();
                    }else {
                        refresh_contactlist_single_user(signal->Uin());
                    }
                    break;
                case USER_EVENTS:
                    sys_msgbar_set();
                    refresh_contactlist_single_user(signal->Uin());
                    if (signal->Argument() > 0) {
                        user=gUserManager.FetchOwner(LOCK_R);
                        if (configuration.autopopupmessages&&
                                (!configuration.onlyautopopupwhenonline||
                                 user->Status()==ICQ_STATUS_ONLINE)) {
                            gUserManager.DropOwner();
                            popup_user_event_window(signal->Uin(),MODE_VIEW,0);
                        }else {
                            gUserManager.DropOwner();
                        }
                        if (configuration.autoraise) {
                            gdk_window_raise(main_window->window);
                        }
                    }
                    break;
                case USER_BASIC:
                    if(signal->Uin()!=gUserManager.OwnerUin()) {
                        refresh_contactlist_single_user(signal->Uin());
                    }
                    break;
                default:
                    if(signal->Uin()!=gUserManager.OwnerUin()) {
                        refresh_contactlist_single_user(signal->Uin());
                    }
                    break;
            }
            break;
        case SIGNAL_UPDATExLIST:
            switch(signal->SubSignal()) {
                case LIST_ADD:
                    if(signal->Uin()!=gUserManager.OwnerUin()) {
                        refresh_contactlist_single_user(signal->Uin());
                    }
                    break;
                case LIST_REMOVE:
                case LIST_ALL:
                    refresh_contactlist(contactlist_current_group);
                    break;
            }
            break;
    }
    return FALSE;
}

void
on_group_menu_clicked                  (GtkButton   *button,
                                        gpointer    user_data)
{
    contactlist_current_group=GPOINTER_TO_INT(user_data);
    refresh_contactlist(contactlist_current_group);
}

gboolean
on_main_window_delete_event            (GtkWidget   *widget,
                                        GdkEvent    *event,
                                        gpointer    user_data)
{
#ifdef USE_PANEL
    if(panel_dockapp) {
        on_toggle_main_window_activate(APPLET_WIDGET(panel_dockapp),NULL);
        return TRUE;
    }else {
        licq_daemon->icqLogoff();
        licq_daemon->Shutdown();
    }
#else
    licq_daemon->icqLogoff();
    licq_daemon->Shutdown();
#endif
    return TRUE;
}

void
refresh_eventwindows_contactlists()
{
    GtkWidget   *alias_clist,*multimess_scrolledwindow;
    GtkWidget   *contactlist=lookup_widget(main_window,"alias_clist");
    GtkWidget   *newlist;
    GList       *rows,*selection;

    if(!contactlist) {
        return ;
    }
    rows=GTK_CLIST(contactlist)->row_list;
    while(rows) {
        if(rows->data&&((GtkCListRow*)(rows->data))->data&&
                ((userdata_t*)(((GtkCListRow*)(rows->data))->data))->send_event_window) {
            alias_clist=lookup_widget(
                    ((userdata_t*)(((GtkCListRow*)(rows->data))->data))->send_event_window,
                    "alias_clist");
            if(alias_clist) {
                selection=get_contactlist_selected_uin(alias_clist);
                real_refresh_contactlist(0,alias_clist,FALSE,selection);
            }
        }
        rows=g_list_next(rows);
    }
}

GList *
get_contactlist_selected_uin           (GtkWidget   *contactlist)
{
    GList           *rows,*selected_uins=NULL;
    userdata_t      *thisuin;
    unsigned long   *uin;

    rows=GTK_CLIST(contactlist)->selection;
    while(rows) {
        thisuin=(userdata_t*)gtk_clist_get_row_data(GTK_CLIST(contactlist),
                GPOINTER_TO_INT(rows->data));
        if(thisuin) {
            uin=(unsigned long*)malloc(sizeof(unsigned long));
            *uin=thisuin->uin;
            selected_uins=g_list_append(selected_uins, uin);
        }
        rows=g_list_next(rows);
    }
    return selected_uins;
}

void
on_alias_clist_column_resize_event     (GtkCList    *clist,
                                        gint        column,
                                        gint        width,
                                        gpointer    user_data)
{
    gint        i;

    for(i=0;i<4;i++) {
        if(!i||configuration.columns[i].active) {
            if(!column--) {
                configuration.columns[i].width=width;
                break;
            }
        }
    }
}

void
on_alias_clist_drag_data_received      (GtkWidget   *widget,
                                        GdkDragContext     
                                                    *context,
                                        gint        x,
                                        gint        y,
                                        GtkSelectionData
                                                    *data,
                                        guint       info,
                                        guint       time)
{
    int             row,col,len;
    gchar           *content;
    userdata_t      *userdata;
    GtkWidget       *event_window;
    GtkWidget       *filename_entry;
    int             end = 0,i,fpos = 0, fmax = 0;
    char            *files;
    
    if ((data->length >= 0) && (data->format == 8))
    {
        content = (gchar *)data->data;
        /* Ugly fix for marking the correct row */
        if (configuration.showcoltitles) {
            y -= 25;
        }
        gtk_clist_get_selection_info(GTK_CLIST(widget), x, y,&row,&col);
        gbug ("Received \"%s\" on row %d \n", content , row);
        len = strlen(content);
        if (row < gtk_clist_get_length(GTK_CLIST(widget))) {
            userdata = (userdata_t *) gtk_clist_get_row_data(GTK_CLIST(widget), 
                    row);
        } else {
            userdata = NULL;
        }
        
        if (userdata) {
            event_window = popup_user_event_window(userdata->uin,MODE_SEND,SEND_MESSAGE);
            filename_entry = lookup_widget(event_window,"filename_entry");
            if  ((len > 7 && !strncasecmp(content,"http://",7)) ||
                    (len > 6 && !strncasecmp(content,"ftp://",6)) ||
                    (len > 4 && !strncasecmp(content,"www.",4)) ||
                    (len > 4 && !strncasecmp(content,"ftp.",4))) {
          
                configure_send(SEND_URL,event_window); 
                gtk_entry_set_text(GTK_ENTRY(filename_entry),content);
            } else if (len > 5 && !strncasecmp(content,"file:",5)) {  
                configure_send(SEND_FILE,event_window);
                fmax = 2*len;
                if ((files = (char *) malloc(fmax)) == NULL) {
                    gtk_entry_set_text(GTK_ENTRY(filename_entry),content+5);
                    return;
                }
                memset (files,0,fmax);
                
                for(i=0; i < len; i++) {
                    if (fpos >= fmax) {
                        if ((files= (char *)realloc(files,fmax * 2)) == NULL) {
                            gtk_entry_set_text(GTK_ENTRY(filename_entry),
                                    content+5);
                            return;
                        }
                        fmax = fmax * 2;
                    }
                    if (!strncmp(&content[i],"file:",5)) { 
                        /* file urls.... */
                        if (!strncmp(&content[i],"file://",7)) {
                            i+= 7;
                        } else {
                            i+= 5;
                        }
                        
                        for(; (i < len) && (content[i] != '\n'); i++){
                            if ((content[i] == '\\') || (content[i] == ',')) {
                                files[fpos++] = '\\';
                            }
                            if (content[i] != '\r') {
                                files[fpos++] = content[i];
                            }
                        }

                        end = fpos;
                        files[fpos++] = ',';
                        files[fpos++] = ' ';
                    }
                }
                files[end] = '\0';
                gtk_entry_set_text(GTK_ENTRY(filename_entry),files);
                free(files);
            }
        }
        gtk_drag_finish (context, TRUE, FALSE, time);
        return;
    }

    gtk_drag_finish (context, FALSE, FALSE, time);
}

gboolean
on_alias_clist_drag_motion             (GtkWidget   *widget,
                                        GdkDragContext
                                                    *context,
                                        gint        x,
                                        gint        y,
                                        guint       time)
{
    int row,col;

    if (GTK_CLIST_SHOW_TITLES(GTK_CLIST(widget))) {
        y -= GTK_CLIST(widget)->column_title_area.height;
    }
    gtk_clist_get_selection_info(GTK_CLIST(widget), x, y,&row,&col);
    if ((row < gtk_clist_get_length(GTK_CLIST(widget))) && 
            (configuration.showactiveuser)) {
        gtk_clist_select_row(GTK_CLIST(widget),row,-1);
    }
     return TRUE;
}

gboolean
icon_blink_function                    (gpointer    data)
{
    static int      iconson=0;
    GdkPixMask_t    *ustatus=NULL;
    GtkWidget       *temp,*pix;
    ICQOwner        *o;
    ICQUser         *u;
    GtkWidget       *alias_clist=lookup_widget(main_window,"alias_clist");
    GList           *rows;
    userdata_t      *udata;
    gint            row=0;

    if(!configuration.blinkicons) {
        iconson=0;
        blinkfunctionactive=FALSE;
    }else {
        iconson=++iconson%5;
    }
    
    if (iconson > 1) {
        return configuration.blinkicons;
    }
    
#ifdef USE_PANEL
    if(iconson) {
        if(panel_dockapp) {
            temp=lookup_widget(panel_dockapp,"status_pixmap");
            ustatus=(GdkPixMask_t*)gtk_object_get_data(GTK_OBJECT(temp),
                    "status_pixmap");
            if(ustatus) {
                gtk_pixmap_set(GTK_PIXMAP(temp),ustatus->pix, ustatus->mask);
            }
        }
    }else {
        if(panel_dockapp) {
            temp=lookup_widget(panel_dockapp,"status_pixmap");
            o=gUserManager.FetchOwner(LOCK_R);
            ustatus=getuserstatusicon(o,FALSE);
            gUserManager.DropOwner();
            gtk_pixmap_set(GTK_PIXMAP(temp),ustatus->pix, ustatus->mask);
        }
    }
#endif
    if(alias_clist) {
        rows=GTK_CLIST(alias_clist)->row_list;
        while(rows) {
            if(rows->data&&
                    (udata=(userdata_t*)((GtkCListRow*)(rows->data))->data)&&
                    (ustatus=udata->status_icon)) 
            {
                if(!iconson) {
                    u=gUserManager.FetchUser(udata->uin,LOCK_R);
                    ustatus=getuserstatusicon(u,FALSE);
                    gUserManager.DropUser(u);
                }
                gtk_clist_set_pixmap(GTK_CLIST(alias_clist),row,0,
                        ustatus->pix, ustatus->mask);
                if(udata->floating_window) {
                    pix=lookup_widget(udata->floating_window,"pix");
                    gtk_pixmap_set(GTK_PIXMAP(pix),ustatus->pix,ustatus->mask);
                }
            }   
            rows=g_list_next(rows);
            row++;
        }
    } 
  
    return configuration.blinkicons;
}

void
on_contacts_list_drag_data_get         (GtkWidget   *contactlist,
                                        GdkDragContext 
                                                    *drag_context,
                                        GtkSelectionData 
                                                    *data,
                                        guint       info,
                                        guint       time,
                                        gpointer    user_data)
{
    gchar       *tosend=NULL;
    GList       *selection;
    userdata_t  *udata;
    gchar       temp[13];


    gbug("on_contacts_list_drag_data_get: enter\n");
    selection=GTK_CLIST(contactlist)->selection;
    if(selection) {
            /*  12 is maxlength of 32-bit value+1 for the comma */ 
        if(!(tosend=(gchar*)malloc(12*g_list_length(selection)+1))) {
            return;
        }
        *tosend=0;
        while(selection) {
            udata=(userdata_t*)gtk_clist_get_row_data(
                    GTK_CLIST(contactlist),
                    GPOINTER_TO_INT(selection->data));
            selection=g_list_next(selection);
            if(selection) {
                sprintf(temp,"%ld,",udata->uin);
            }else {
                sprintf(temp,"%ld",udata->uin);
            }
            strcat(tosend,temp);
        }
    }
    if(tosend) {
        gbug("on_contacts_list_drag_data_get: sent '%s'\n",tosend);
        gtk_selection_data_set(data, data->target, 8, (guchar*)tosend, 
                strlen(tosend));
        free(tosend);
    }
}

void
refresh_floating_windows()
{
    userdata_t      *udata;
    gchar           newln[MAX_CONFIG_STRLEN];
    gchar           lname[7];
    GtkWidget       *label,*pix;
    int             i;
    GdkPixMask_t    *upix;

    FOR_EACH_USER_START(LOCK_R);
        udata=find_user_data(pUser->Uin(),NULL);
        if(!udata||!udata->floating_window) {
            FOR_EACH_USER_CONTINUE;
        }
        pix=lookup_widget(udata->floating_window,"pix");
        if(configuration.blinkicons&&udata->status_icon) {
            upix=udata->status_icon;
        }else {
            upix=getuserstatusicon(pUser,TRUE);
        }
        gtk_pixmap_set(GTK_PIXMAP(pix),upix->pix,upix->mask);
        for(i=0;i<4;i++) {
            if(!i||(configuration.columns[i].active&&
                        configuration.columns[i].width)) {
                pUser->usprintf(newln,
                        configuration.columns[i].format,TRUE);
                sprintf(lname,"label%d",i);
                label=lookup_widget(udata->floating_window,lname);
                gtk_label_set(GTK_LABEL(label),newln);
            }
        }
    FOR_EACH_USER_END;
}

GtkWidget   *
create_floating_window_contents        (GtkWindow   *win)
{
    GtkWidget           *hbox,*label,*pixmap;
    GtkWidget           *alias_clist;
    unsigned long       uin=gtk_widget_get_active_uin(GTK_WIDGET(win));
    gchar               lname[7];
    int                 i;
    GdkPixMask_t        *upix;
    ICQUser             *u;
    userdata_t          *udata;
       
    udata=find_user_data(uin,NULL);

    if(udata&&udata->floating_window) {
        if((hbox=lookup_widget(udata->floating_window,"hbox"))) {
            gtk_container_remove(GTK_CONTAINER(win),hbox);
        }
    }

    alias_clist=lookup_widget(main_window,"alias_clist");

    hbox=gtk_hbox_new(FALSE,3);
    gtk_container_set_border_width(GTK_CONTAINER(hbox),3);
    gtk_widget_ref(hbox);
    gtk_object_set_data_full(GTK_OBJECT(win),"hbox",hbox,
            (GtkDestroyNotify) gtk_widget_unref);
    if(udata&&configuration.blinkicons&&udata->status_icon) {
        pixmap=gtk_pixmap_new(udata->status_icon->pix,udata->status_icon->mask);
    }else {
        u=gUserManager.FetchUser(uin,LOCK_R);
        upix=getuserstatusicon(u,FALSE);
        gUserManager.DropUser(u);
        pixmap=gtk_pixmap_new(upix->pix,upix->mask);
    }
    gtk_widget_ref(pixmap);
    gtk_object_set_data_full(GTK_OBJECT(win),"pix",pixmap,
            (GtkDestroyNotify) gtk_widget_unref);
    gtk_box_pack_start(GTK_BOX(hbox),pixmap,TRUE,TRUE,0);
    
    for(i=0;i<4;i++) {
        if(!i||(configuration.columns[i].active&& 
                    configuration.columns[i].width)) {
            label=gtk_label_new("");
            sprintf(lname,"label%d",i);
            gtk_object_set_data_full(GTK_OBJECT(win),lname,label,
                    (GtkDestroyNotify) gtk_widget_unref);
            gtk_widget_ref(label);
            gtk_box_pack_start(GTK_BOX(hbox),label,TRUE,TRUE,0);
        }  
    }                                           
    gtk_container_add(GTK_CONTAINER(win),hbox);
    gtk_widget_show_all(GTK_WIDGET(win));

    return hbox;
}

GtkWidget   *
create_user_floating_window            (unsigned long   
                                                    uin)
{
    GtkWidget           *win,*hbox,*label;

    win=gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_window_set_title(GTK_WINDOW(win),"LicqFloat");
    gtk_window_set_wmclass(GTK_WINDOW(win),"FloatingUser","GtkLicq");
    gtk_widget_set_active_uin(win,uin);
    gtk_widget_set_events (win, GDK_BUTTON_PRESS_MASK);
    create_floating_window_contents(GTK_WINDOW(win));
    gtk_signal_connect (GTK_OBJECT (win), "delete-event",
            GTK_SIGNAL_FUNC (on_floating_user_delete_event),
            NULL);
    gtk_signal_connect (GTK_OBJECT (win), "button_press_event",
            GTK_SIGNAL_FUNC (on_floating_user_button_press_event),
            NULL);

    gtk_window_set_policy(GTK_WINDOW(win),FALSE,FALSE,TRUE);

    return win;
}

void
rebuild_all_floating_windows()
{
    userdata_t          *udata;

    FOR_EACH_USER_START(LOCK_R);
        udata=find_user_data(pUser->Uin(),NULL);
        if(!udata||!udata->floating_window) {
            FOR_EACH_USER_CONTINUE;
        }
        create_floating_window_contents(GTK_WINDOW(udata->floating_window));
    FOR_EACH_USER_END;
    refresh_floating_windows();    
}

gboolean
on_floating_user_button_press_event      (GtkWidget *widget,
                                          GdkEventButton  
                                                    *event,
                                          gpointer  user_data)
{
    GtkWidget       *user_popup;
    unsigned long   uin;
    struct timeval  tmp_time;
    static struct timeval dclick={0,0};
    long            td;

    gbug("got mouse\n");
    uin=gtk_widget_get_active_uin(widget);

    if (event->button == 3) {
        if((user_popup=create_user_popup_menu(uin,NULL))) {
            gtk_menu_popup (GTK_MENU (user_popup), NULL, NULL, NULL, NULL,
                    3, event->time);
        }
    }else if (event->button == 1) {
        gettimeofday(&tmp_time,NULL);
        td = time_diff(&tmp_time,&dclick);
        dclick.tv_sec = tmp_time.tv_sec;
        dclick.tv_usec = tmp_time.tv_usec;
        if (((event->type == GDK_2BUTTON_PRESS) &&
                    (!configuration.singleclick)) ||
                ((event->type == GDK_BUTTON_PRESS) &&
                 (td > DCLICK_DELAY) && //prevent from doubleclick!
                 (configuration.singleclick))){
            popup_user_event_window(uin,MODE_UNSPEC,SEND_MESSAGE);
        }
    }
    return FALSE;
}


gboolean
on_floating_user_delete_event          (GtkWidget   *widget,
                                        GdkEvent    *event,
                                        gpointer    user_data)
{
    userdata_t      *udata;
    unsigned long   uin;

    uin=gtk_widget_get_active_uin(widget);
    udata=find_user_data(uin,NULL);
    udata->floating_window=NULL;
    gtk_widget_destroy(widget);

    return FALSE;
}

void 
real_refresh_contactlist_single_user   (unsigned int
                                                    group,
                                        GroupType   gtype,
                                        GtkWidget   *contactlist,
                                        gboolean    ismainlist,
                                        userdata_t  *udata,
                                        GList       *selection,
                                        ICQUser     *pUser,
                                        gint        row)
{
    int             colndx=1,i;
    gchar           *newrow[5];
    GdkPixMask_t    *image;
    GdkColor        *color;
    unsigned long   uin;
    GList           *invisible_users,*f_active;
    GList           *rent;


    if(!contactlist) {
        return ;
    }
    newrow[0]="";
    invisible_users=(GList*)gtk_object_get_data(GTK_OBJECT(contactlist),
            "invisible_users");
    if(pUser->GetInGroup(gtype,group)&&
            (configuration.showofflineusers||!pUser->StatusOffline())&&
            (!pUser->IgnoreList()||
             (gtype==GROUPS_SYSTEM&&group==GROUP_IGNORE_LIST))) {
        if(!udata) {
            if(!(udata=create_blank_userdata(pUser->Uin()))) {
                return ;
            }
        }
        if(row<0) {
            for(i=0;i<4;i++) {
                if(!i||(configuration.columns[i].active&&
                            configuration.columns[i].width)) {
                    if(!(newrow[colndx]=(char*)malloc(MAX_CONFIG_STRLEN))) {
                        gbug("real_refresh_contactlist_single_user: could not malloc\n");
                        return ;
                    }
                    pUser->usprintf(newrow[colndx++], 
                            configuration.columns[i].format,TRUE);
                }
            }
            newrow[colndx]=NULL;
            row=gtk_clist_append(GTK_CLIST(contactlist),newrow);
            for(i=1;i<colndx;i++) {
                free(newrow[i]);
            }
        }else {
            if(!(newrow[0]=(char*)malloc(MAX_CONFIG_STRLEN))) {
                gbug("real_refresh_contactlist_single_user: could not malloc\n");
                return ;
            }
            for(i=0;i<4;i++) {
                if(!i||(configuration.columns[i].active&&
                            configuration.columns[i].width)) {
                    pUser->usprintf(newrow[0], 
                            configuration.columns[i].format,TRUE);
                    gtk_clist_set_text(GTK_CLIST(contactlist),row,colndx++,
                            newrow[0]);
                }
            }
            free(newrow[0]);
        }
        if((image=getuserstatusicon(pUser,ismainlist))) {
            if(ismainlist&&configuration.blinkicons) {
                if(image!=getuserstatusicon(pUser,FALSE)) {
                    udata->status_icon=image;
                }else {
                    udata->status_icon=NULL;
                }
            }
            gtk_clist_set_pixmap(GTK_CLIST(contactlist),row,0,
                    image->pix, image->mask);
        }
        if((color=getuserstatuscolor(pUser))) {
            gtk_clist_set_foreground(GTK_CLIST(contactlist),row,color);
        }
        if(!gtk_clist_get_row_data(GTK_CLIST(contactlist),row)) {
            gtk_clist_set_row_data_full(GTK_CLIST(contactlist),row,
                    (gpointer)udata, destroy_notify_free);
        }
        if(selection) {
            uin=pUser->Uin();
            if(g_list_find_custom(selection,&uin,g_list_compare_uin)) {
                gtk_clist_select_row(GTK_CLIST(contactlist),row,-1);
            }
        }
        if(ismainlist) {
            f_active=invisible_users;
            while(f_active) {
                if(((userdata_t*)(f_active->data))->uin==pUser->Uin()) {
                    invisible_users=g_list_remove(invisible_users,
                            f_active->data);
                    gtk_object_set_data(GTK_OBJECT(contactlist),
                            "invisible_users",invisible_users);
                    break;
                }
                f_active=g_list_next(f_active);
            }
        }
    }else {
        if(row>=0) {
            if(row==GTK_CLIST(contactlist)->rows-1) {
                rent=GTK_CLIST(contactlist)->row_list_end;
            }else {
                rent=g_list_nth(GTK_CLIST(contactlist)->row_list,row);
            }
            if(rent) {
                GTK_CLIST_ROW(rent)->destroy=NULL;
            }
            gtk_clist_remove(GTK_CLIST(contactlist),row);
        }
        if(ismainlist) {
            row=-1;
            f_active=invisible_users;
            while(f_active) {
                if(((userdata_t*)(f_active->data))->uin==pUser->Uin()) {
                    row=0;
                    break;
                }
                f_active=g_list_next(f_active);
            }
            if(row<0) {
                if(udata||(udata=create_blank_userdata(pUser->Uin()))) {
                    invisible_users=g_list_append(invisible_users,udata);
                    gtk_object_set_data(GTK_OBJECT(contactlist),
                            "invisible_users",invisible_users);
                }
            }
        }
    }
}

void 
refresh_contactlist_single_user        (unsigned long   
                                                    uin)
{
    GtkWidget       *contactlist=lookup_widget(main_window, 
            "alias_clist");
    GroupType       gtype=GROUPS_USER;
    ICQUser         *u;
    userdata_t      *udata;
    unsigned int    group=contactlist_current_group;
    gint            row=-1;
    

    if(!contactlist) {
        return ;
    }
    if(uin==gUserManager.OwnerUin()) {
        return ;
    }

    if(!(u=gUserManager.FetchUser(uin,LOCK_R))) {
        return ;
    }

    if(group>gUserManager.NumGroups()) {
        gtype=GROUPS_SYSTEM;
        group-=gUserManager.NumGroups();
    }
    gtk_clist_freeze(GTK_CLIST(contactlist));
    udata=find_user_data(uin,&row);
    real_refresh_contactlist_single_user(group,gtype,contactlist,
            TRUE,udata,NULL,u,row);
    gUserManager.DropUser(u);

    gtk_clist_sort(GTK_CLIST(contactlist));
    gtk_clist_thaw(GTK_CLIST(contactlist));

    
    refresh_eventwindows_contactlists();
    refresh_floating_windows();
}

