#include "gtk-gui.h"

#include <stdio.h>
#include <gdk/gdkkeysyms.h>

#include "interface.h"
#include "functions.h"

void
on_event_autoresponse_dialog_show      (GtkWidget       *widget,
                                        gpointer         user_data)
{
    GtkWidget       *user_label;
    GtkWidget       *autoresponse_vbox=lookup_widget(widget,
            "autoresponse_vbox");
    GtkWidget       *autroreponse_ok_button = lookup_widget(widget,
            "autroreponse_ok_button");
    GtkAccelGroup   *acc = gtk_accel_group_new();
    gchar           *msg;
    ICQUser         *user;
    unsigned long   uin=gtk_widget_get_active_uin(widget);

    if((user=gUserManager.FetchUser(uin,LOCK_R))) {
        msg=g_strdup_printf(_("Autoresponse for %s:"), user->GetAlias());
        gUserManager.DropUser(user);
    }else {
        gtk_widget_destroy(widget);
        return;
    }
    gtk_accel_group_add(acc,GDK_Escape,(GdkModifierType)GDK_LOCK_MASK,
            GTK_ACCEL_VISIBLE, GTK_OBJECT(autroreponse_ok_button), "clicked");
    gtk_window_add_accel_group(GTK_WINDOW(widget),acc); 
    user_label=gtk_label_new(msg);
    if(msg&&*msg&&msg[strlen(msg)-1]==':') {
        msg[strlen(msg)-1]=0;
    }
    gtk_window_set_title(GTK_WINDOW(widget),msg);
    g_free(msg);
    gtk_widget_ref(user_label);
    gtk_object_set_data_full( GTK_OBJECT(widget),"user_label",
            user_label, (GtkDestroyNotify) gtk_widget_unref);
    gtk_misc_set_alignment(GTK_MISC(user_label), 0,0.5);
    gtk_box_pack_start(GTK_BOX(autoresponse_vbox), user_label,FALSE,TRUE,0);
    gtk_box_reorder_child(GTK_BOX(autoresponse_vbox), user_label,0);
    gtk_widget_show(user_label);
}


void
on_auto_response_dialog_destroy_event  (GtkWidget       *widget,
                                        gpointer         user_data)
{
}

gboolean
on_event_autoresponse_dialog_delete_event
                                        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    gtk_widget_destroy(widget);
    return FALSE;
}


void
on_autroreponse_ok_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
    ICQUser         *user;
    unsigned long   uin=gtk_widget_get_active_uin(GTK_WIDGET(button));
    gint            ndx;
    GtkWidget       *auto_away_text=lookup_widget(GTK_WIDGET(button),
            "auto_away_text");
    GtkWidget       *show_again_optionmenu=lookup_widget(GTK_WIDGET(button),
            "show_again_optionmenu");
    userdata_t      *uinfo;
    
    if(GTK_WIDGET_VISIBLE(show_again_optionmenu)) {
        ndx=gtk_option_menu_get_history(GTK_OPTION_MENU(show_again_optionmenu)); 
        user=gUserManager.FetchUser(uin,LOCK_W);
        uinfo=find_user_data(uin,NULL);
        if(!user||!uinfo) {
            if(user) {
                gUserManager.DropUser(user);
            }
            return ;
        }
        gbug("on_show_again_optionmenu_clicked: do work\n");
        switch(ndx) {
            case 0:
            case 1:
                user->SetShowAwayMsg(ndx?FALSE:TRUE); 
                gbug("on_show_again_optionmenu_clicked: set show %d\n",1-ndx);
                if(uinfo->last_away_mess) {
                    g_free(uinfo->last_away_mess);
                    uinfo->last_away_mess=NULL;
                }
                break;
            case 2:
                gbug("on_show_again_optionmenu_clicked: set show if change\n");
                user->SetShowAwayMsg(TRUE);
                if(uinfo->last_away_mess) {
                    g_free(uinfo->last_away_mess);
                }
                uinfo->last_away_mess=gtk_editable_get_chars(
                        GTK_EDITABLE(auto_away_text),0,-1);
                break;
        }
        gUserManager.DropUser(user);
    }
    gtk_widget_destroy(gtk_widget_get_toplevel(GTK_WIDGET(button)));
    
}


