#include "gtk-gui.h"

#include "functions.h"
#include "interface.h"
#include "gnomedock.h"
#include "callbacks.h"
#include "contactlist.h"
#include "user_popup.h"
#include "view_event_window.h"
#include "send_event_window.h"
#include "licq_countrycodes.h"
#include "licq_languagecodes.h"

#include <string.h>
#include <strings.h>
#include <sys/time.h>
#include <unistd.h>
#include <values.h>
#include <pthread.h>


unsigned short  last_status;
extern bool statustimerfunctionactive;

bool 
sound_signal_callback                  (CICQSignal  *signal, 
                                        gpointer    data)
{
    if(signal&&signal->Signal()==SIGNAL_ONEVENT) {
        if (configuration.beep_onevent &&
                configuration.use_onevents) {
            gdk_beep();
        }
        gbug("signal SOUND  %ld %s\n",signal->SubSignal(),signal->Parameters());
    }
     return(FALSE);
}

bool 
secure_signal_callback                 (CICQSignal  *signal, 
                                        gpointer    data)
{
    GtkWidget       *pixmap; 
    GtkWidget       *toplevel;
    GList           *children = NULL;
    ICQUser *user;
    bool            secure = false;
    unsigned long   uin;
    GtkWidget       *send_through_server_checkbutton;

    if ((signal == NULL) || 
            (signal->Signal() != SIGNAL_UPDATExUSER) || 
            (signal->SubSignal() != USER_SECURITY)) {
        return(FALSE);
    }
            
    if ((data != NULL) && GTK_IS_CONTAINER(data)) {
        uin=gtk_widget_get_active_uin(GTK_WIDGET(data));
        if (uin != signal->Uin()) {
            return(FALSE);
        }
        
        user = (uin > 0)?gUserManager.FetchUser(uin,LOCK_R):
            gUserManager.FetchOwner(LOCK_R);
        if (user != NULL) {
            secure = user->Secure();
            gUserManager.DropUser(user);
        }
        
        toplevel=gtk_widget_get_toplevel(GTK_WIDGET(data));
        send_through_server_checkbutton=lookup_widget(toplevel,
                "send_through_server_checkbutton");
        pixmap=lookup_widget(GTK_WIDGET(data),"security_pixmap");
        
        if ((secure) &&
                (send_through_server_checkbutton&&
                 (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(send_through_server_checkbutton))))) {
            gtk_pixmap_set(GTK_PIXMAP(pixmap),
                    not_secure_on_pixmap.pix,not_secure_on_pixmap.mask);
        }else if (secure) {
            gtk_pixmap_set(GTK_PIXMAP(pixmap),
                    secure_on_pixmap.pix,secure_on_pixmap.mask);
        }else {
            gtk_pixmap_set(GTK_PIXMAP(pixmap),
                    secure_off_pixmap.pix,secure_off_pixmap.mask);
        }
    }
    return(FALSE);
}

bool 
secure_result_callback                 (ICQEvent    *event, 
                                        gpointer    data) 
{
    ICQUser         *user;
    char            *msg = NULL;
    
    if ((event->Command() == ICQ_CMDxTCP_START) && 
            (event->SubCommand() == ICQ_CMDxSUB_SECURExOPEN)) {
        user = gUserManager.FetchUser(event->Uin(),LOCK_W);
        msg =  g_strdup_printf(_("Could not open a secure channel to %s."),
                user?user->GetAlias():_("the user"));
        if (event->Result() == EVENT_FAILED) {
            showokdialog(_("Request failed!"), msg);
        } else if (event->Result() == EVENT_TIMEDOUT) {
            showokdialog(_("Request timeout!"), msg);
        } else if (event->Result() == EVENT_ERROR) {
            showokdialog(_("Request error!"), msg);
        } else if ((event->Result() == EVENT_ACKED) ||
                (event->Result() == EVENT_SUCCESS)) {
            if ((user != NULL) && configuration.auto_autosecure) {
                user->SetAutoSecure(true);
            }
        }
        if(user) {
            gUserManager.DropUser(user);
        }
        g_free(msg);

        return(TRUE);
    } else if ((event->Command() == ICQ_CMDxTCP_START) && 
            (event->SubCommand() == ICQ_CMDxSUB_SECURExCLOSE)) {

        user = gUserManager.FetchUser(event->Uin(),LOCK_W);
        if ((event->Result() == EVENT_ACKED) ||
                (event->Result() == EVENT_SUCCESS)) {
            if ((user != NULL) && (configuration.auto_autosecure)) {
                user->SetAutoSecure(false);
            }
        }
        if(user) {
            gUserManager.DropUser(user);
        }
        return(TRUE);
    }
    return(FALSE);
}


void 
view_url                               (const char  *url)
{
    const char      *urlviewer = licq_daemon->getUrlViewer();
    gchar           *cmd, *errmsg;
    int             eval=0;
    gchar           *tmp = NULL;
    gchar           *fixedurl = NULL;
    int             i,len;
    
    if (url == NULL) {
        return;
    }
#ifdef USE_GNOME
    if (configuration.use_gnomeurlviewer) {
        gnome_url_show(url);
    } else {
#endif
    /* Remove space at the beginning and add http:// if that is missing */
    len = strlen(url);
    for(i=0;(i < len) && (url[i] == ' '); i++);
    fixedurl = (char*)&url[i];
    if (fixedurl != NULL) {
        if (!strncmp(url,"http://",7) || !strncmp(url,"file://",7)) {
            cmd=g_strdup_printf("%s '%s' &",urlviewer, fixedurl);
        } else {
            if (fixedurl[0] == '/') {
                cmd=g_strdup_printf("%s 'file://%s' &",urlviewer, fixedurl);
            } else {
                cmd=g_strdup_printf("%s 'http://%s' &",urlviewer, fixedurl);
            }
        }

        if (cmd != NULL) {
            if ((eval=system((gchar *) cmd)) < 0) {
                errmsg=g_strdup_printf(_("Failed to invoke the urlviewer\n'%s'\n\n Error code %d"), cmd,eval);
                showokdialog(_("URL view failed"),errmsg);
                gbug("View URL failed.\n");
                g_free(errmsg);
            }
        }
        /* View url */
        g_free(cmd);
    }
#ifdef USE_GNOME
    }
#endif
}
    
GdkPixMask_t *
geticonforevent                     (unsigned short subcommand)
{
    switch (subcommand) {
        case ICQ_CMDxSUB_MSG:
            return &status_pixmap_message;
            break;
        case ICQ_CMDxSUB_URL:
            return &status_pixmap_url;
            break;
        case ICQ_CMDxSUB_CHAT:
            return &status_pixmap_chat;
            break;
        case ICQ_CMDxSUB_FILE:
            return &status_pixmap_file;
            break;
        case ICQ_CMDxSUB_CONTACTxLIST:
            return &status_pixmap_contacts;
            break;
        case ICQ_CMDxSUB_AUTHxREQUEST:
        case ICQ_CMDxSUB_AUTHxGRANTED:
        case ICQ_CMDxSUB_AUTHxREFUSED:
        case ICQ_CMDxSUB_ADDEDxTOxLIST:
            return &status_pixmap_authorize;
            break;

        default:
            return &status_pixmap_message;
            break;
    }
    return &status_pixmap_message;
}


GdkPixMask_t *
getuserstatusicon                      (ICQUser     *user,
                                        gboolean    careforevents)
{
    CUserEvent *e=NULL;

    if(!user) {
        return &status_pixmap_offline;
    }
    
    if(careforevents&&user->NewMessages()&&(e=user->EventPeekFirst())) {
        gbug("getuserstatusicon: %d\n",e->Command());
        if(e && ((e->Command() == ICQ_CMDxTCP_START) || 
                (e->Command() == ICQ_CMDxRCV_SYSxMSGxONLINE))) {
            return geticonforevent(e->SubCommand());
        } else {
            return &status_pixmap_message;
        }
    } else {
        if(user->StatusInvisible()) {
            return &status_pixmap_private;
        }
        switch(user->Status()) {
            case ICQ_STATUS_OFFLINE:
                return &status_pixmap_offline;
                break;
            case ICQ_STATUS_ONLINE:
                return &status_pixmap_online;
                break;
            case ICQ_STATUS_AWAY:
                return &status_pixmap_away;
                break;
            case ICQ_STATUS_DND:
                return &status_pixmap_dnd;
                break;
            case ICQ_STATUS_NA:
                return &status_pixmap_na;
                break;
            case ICQ_STATUS_OCCUPIED:
                return &status_pixmap_occupied;
                break;
            case ICQ_STATUS_FREEFORCHAT:
                return &status_pixmap_ffc;
                break;
            default:
                return NULL;
                break;
        }
    }
}

GdkColor    *
getuserstatuscolor(ICQUser *user)
{
    if(user->NewUser()) {
        return &statuscolor_new;
    }else {
/*      if(user->StatusInvisible()) {
            return &statuscolor_other;
        }
 */
        switch(user->Status()) {
            case ICQ_STATUS_OFFLINE:
                return &statuscolor_offline;
                break;
            case ICQ_STATUS_FREEFORCHAT:
            case ICQ_STATUS_ONLINE:
                return &statuscolor_online;
                break;
            case ICQ_STATUS_AWAY:
            case ICQ_STATUS_DND:
            case ICQ_STATUS_NA:
            case ICQ_STATUS_OCCUPIED:
                return &statuscolor_other;
                break;
            default:
                return NULL;
                break;
        }
    }
}

void
destroy_notify_free_userdata(GtkWidget *widget, gpointer dummy)
{
    gpointer data;
    if (widget != NULL) {
        data = gtk_object_get_user_data(GTK_OBJECT(widget));
        if (data != NULL) {
            free(data);
        }
    }
}

void
destroy_notify_free(gpointer data)
{
    if(data) {
        free(data);
    }else {
        gbug("destroy_notify_free: Attempt to free NULL data\n");
    }
}

char *
geticqeventerrorstring(EventResult result) 
{
    switch(result) {
        case EVENT_ACKED:
            return _("Acknowledged");
            break;
        case EVENT_FAILED:
            return _("Failed");
            break;
        case EVENT_TIMEDOUT:
            return _("Timed out");
            break;
        case EVENT_ERROR:
            return _("Error");
            break;
        case EVENT_CANCELLED:
            return _("Cancelled");
            break;
        default:
            return NULL;
            break;
    }
}

GtkJustification
get_justification(gchar *descr)
{
    if(!strcasecmp(descr,"left")) {
        return GTK_JUSTIFY_LEFT;
    }else if (!strcasecmp(descr,"right")) {
        return GTK_JUSTIFY_RIGHT;
    }else if (!strcasecmp(descr, "center")) {
        return GTK_JUSTIFY_CENTER;
    }
    return GTK_JUSTIFY_LEFT;
}

int
get_status_sort_index(unsigned short status)
{
    switch(status) {
        case ICQ_STATUS_OFFLINE:
            return 2;
            break;
        case ICQ_STATUS_FREEFORCHAT:
        case ICQ_STATUS_ONLINE:
            return 0;
            break;
        case ICQ_STATUS_AWAY:
        case ICQ_STATUS_DND:
        case ICQ_STATUS_NA:
        case ICQ_STATUS_OCCUPIED:
            return 1;
            break;
        default:
            return 3;
    }
}

char *
get_window_type_text(EWinType type)
{
    switch(type) {
        case UtilityWinLicq:
            return _("Internal");
            break;
        case UtilityWinTerm:
            return _("Terminal");
            break;
        case UtilityWinGui:
            return _("Windows GUI");
            break;
        default:
            return _("Unknown");
            break;
    }
}

userdata_t *
real_find_user_data                    (GtkWidget   *alias_clist,
                                        unsigned long
                                                    uin,
                                        int         *row)
{
    GList           *rows;
    int             current_row=0;

    if ((uin == 0) || (uin==gUserManager.OwnerUin())) {
        return((userdata_t *) gtk_object_get_data(GTK_OBJECT(main_window), 
                    "owner_userdata"));
    }
    
    if(!alias_clist) {
        return NULL;
    }

    rows=GTK_CLIST(alias_clist)->row_list;
    while(rows) {
        if(rows->data&&((GtkCListRow*)(rows->data))->data&&
                ((userdata_t*)(((GtkCListRow*)(rows->data))->data))->uin==uin) {
            if(row) {
                *row=current_row;
            }
            return ((userdata_t*)(((GtkCListRow*)(rows->data))->data));
        }
        rows=g_list_next(rows);
        current_row++;
    }

    rows=(GList*)gtk_object_get_data(GTK_OBJECT(alias_clist),"invisible_users");
    while(rows) {
        if(rows->data&&((userdata_t*)(rows->data))->uin==uin) {
            if(row) {
                *row=-1;
            }
            return (userdata_t*)(rows->data);
        }
        rows=g_list_next(rows);
    }
    return NULL;
}

userdata_t *
find_user_data                         (unsigned long   
                                                    uin,
                                        int         *row)
{
    GtkWidget       *alias_clist=lookup_widget(main_window,"alias_clist");

    return real_find_user_data(alias_clist,uin,row);

}


int
get_sort_index(     ICQUser *u1, 
                    ICQUser *u2,
                    gushort sortby)
{
    long        i1,i2;
    gchar       str1[MAX_CONFIG_STRLEN],str2[MAX_CONFIG_STRLEN];

    switch(sortby) {
        case 0: /*  Shouldn't happen, no sort */
            break;
        case 1: /*  Status */
            i1=get_status_sort_index(u1->Status());
            i2=get_status_sort_index(u2->Status());
            if(i1==i2) {
                return 0; 
            }else if(i1<i2) {
                return -1; 
            }else {
                return 1; 
            }
            break;
        case 2: /*  Last event */
            if(u1->Touched()==u2->Touched()) {
                return 0; 
            }else if(u1->Touched()>u2->Touched()) {
                return -1; 
            }else {
                return 1; 
            }
            break;
        case 3: /*  Column1-4 */
        case 4:
        case 5:
        case 6:
            sortby-=3;
            for(i1=0;i1<4;i1++) {
                if(!i1||configuration.columns[i1].active) {
                    if(!sortby) {
                        u1->usprintf(str1,configuration.columns[i1].format,
                                TRUE);
                        u2->usprintf(str2,configuration.columns[i1].format,
                                TRUE);
                        return strcasecmp(str1,str2);
                        break;
                    }else {
                        sortby--;
                    }
                }
            }
            break;
        default:
            break;
    }
    return strcasecmp(u1->GetAlias(),u2->GetAlias());
}

unsigned long
get_user_uin_from_sysmsg(gchar *msg)
{
    gchar           *start;
    unsigned long   uin=0;

    if((start=strstr(msg,"Uin: "))) {
        if(!sscanf(start+5,"%ld",&uin)) {
            uin=0;
        }
    }
    return uin;
}

gchar
get_message_expanded_text_max_length(gchar *message,gchar r_char)
{
    gint    to_go=MAX_MESSAGE_SIZE;

    if(message) {
        if(r_char) {
            *message=r_char;
        }
        while(*message) {
            if(!--to_go||(*message=='\n'&&!--to_go)) {
                    r_char=*message;
                    *message=0;
                    return r_char;
            }
            message++;
        }
    }
    return 0;
}

gint
get_message_expanded_length(GtkText     *mbox)
{
    ssize_t count=0,len,pos=0;

    for(len=gtk_text_get_length(mbox);pos<len;pos++) {
        count++;
        if(GTK_TEXT_INDEX(mbox,(unsigned)pos)=='\n') {
            count++;
        }
    }
    return count;
}

char *
EventDescription(CUserEvent *e)
{
    switch(e->SubCommand()) {
        case 0:
            return _("Saved Event");
            break;
        case ICQ_CMDxSUB_MSG:
            return _("Message");
            break;
        case ICQ_CMDxSUB_CHAT:
            return _("Chat Request");
            break;
        case ICQ_CMDxSUB_FILE:
            return _("File Transfer");
            break;
        case ICQ_CMDxSUB_URL:
            return _("URL");
            break;
        case ICQ_CMDxSUB_AUTHxREQUEST:
            return _("Authorization Request");
            break;
        case ICQ_CMDxSUB_AUTHxREFUSED:
            return _("Authorization Refused");
            break;
        case ICQ_CMDxSUB_AUTHxGRANTED:
            return _("Authorization Granted");
            break;
        case ICQ_CMDxSUB_ADDEDxTOxLIST:
            return _("Added to Contact List");
            break;
        case ICQ_CMDxSUB_WEBxPANEL:
            return _("Web Panel");
            break;
        case ICQ_CMDxSUB_EMAILxPAGER:
            return _("Email Pager");
            break;
        case ICQ_CMDxSUB_CONTACTxLIST:
            return _("Contact List");
            break;
        case ICQ_CMDxSUB_USERxINFO:
            return _("User Info");
            break;
        default:
            //FIXME: Memleak
            return g_strdup_printf(_("Unknown (%d)"),e->SubCommand());
            break;
    }
}

const char *
status_string(unsigned short status,gboolean shrt) 
{
    switch(status){
        case ICQ_STATUS_ONLINE:
            return _("Online");
            break;
        case ICQ_STATUS_OFFLINE:
            return _("Offline");
            break;
        case ICQ_STATUS_AWAY:
            return _("Away");
            break;
        case ICQ_STATUS_DND:
            return (shrt?_("DND"):_("Do Not Disturb"));
            break;
        case ICQ_STATUS_NA:
            return (shrt?_("N/A"):_("Not Available"));
            break;
        case ICQ_STATUS_OCCUPIED:
            return _("Occupied");
            break;
        case ICQ_STATUS_FREEFORCHAT:
            return (shrt?_("FFC"):_("Free for Chat"));
            break;
        case ICQ_STATUS_FxPRIVATE:
           return _("Invisible"); 
        default:
            return "";
            break;
    }
}

int 
set_status(unsigned short status)
{
    ICQOwner                *owner;
    int                     new_status;

    owner=gUserManager.FetchOwner(LOCK_R);
    if((last_status != owner->StatusFull()) && (status != owner->StatusFull())) {
        last_status = owner->StatusFull();
    }

    switch(status) {
        case ICQ_STATUS_OFFLINE:
            gUserManager.DropOwner();
            licq_daemon->icqLogoff();
            return(0);
        case ICQ_STATUS_FxPRIVATE:
            if (owner->StatusOffline()){
                gUserManager.DropOwner();
                return(0);
            } else {
                status = owner->StatusFull() ^ ICQ_STATUS_FxPRIVATE;
                gUserManager.DropOwner();
                licq_daemon->icqSetStatus(status);
                return(0);
            }
        default:
            if (owner->StatusOffline()) {
                licq_daemon->icqLogon(status);
            } else {
                if (owner->StatusFull() & ICQ_STATUS_FxPRIVATE) {
                    status = status ^ ICQ_STATUS_FxPRIVATE;
                }
                licq_daemon->icqSetStatus(status);
            }
            break;
    }
    gUserManager.DropUser(owner);
    return(0);
}


int 
gtk_clist_get_length(GtkCList *clist)
{
    return(clist->rows);
}

int
gtk_option_menu_get_history(GtkOptionMenu *menu)
{
    GList       *childlist;
    guint       index=0;

    g_return_val_if_fail (menu != NULL,-1);
    g_return_val_if_fail (GTK_IS_OPTION_MENU (menu),-1);

    childlist=gtk_container_children(GTK_CONTAINER(
                gtk_option_menu_get_menu(menu)));
    while(childlist) {
        if(menu->menu_item==childlist->data) {
            return index;
        }
        index++;
        childlist=g_list_next(childlist);
    }
    return -1;
}

int 
sys_msgbar_set()
{
    GtkWidget       *system_message_label=lookup_widget(main_window,
            "system_message_label");
    GtkTooltips     *main_window_tooltips=GTK_TOOLTIPS(lookup_widget(
                main_window, "main_window_tooltips"));
    GtkWidget       *system_message_eventbox=lookup_widget(main_window,
            "system_message_eventbox");
    int             msg=0;
    char            *sys_msg;
    gchar           message[MAX_HINT_SIZE+1]="",tempmessage[MAX_HINT_SIZE];

    ICQUser         *owner;
   
    FOR_EACH_USER_START(LOCK_R);
        if (pUser->NewMessages()) {
            msg += pUser->NewMessages();
            snprintf(tempmessage,MAX_HINT_SIZE,"%s%s: %d",
                    (*message?", ":""),pUser->GetAlias(),pUser->NewMessages());
            strncat(message,tempmessage,MAX_HINT_SIZE-4-strlen(message));
            if(strlen(message)>=MAX_HINT_SIZE-4) {
                strcat(message," ...");
                FOR_EACH_USER_BREAK;
            }
        }
    FOR_EACH_USER_END;
    gtk_tooltips_set_tip(main_window_tooltips,system_message_eventbox,
            (*message?message:NULL),NULL);
    owner=gUserManager.FetchOwner(LOCK_R);
    if(owner&&owner->NewMessages()) {
        snprintf(message,MAX_HINT_SIZE,"%s: %d",_("System"),
                owner->NewMessages());
        msg+=owner->NewMessages();
        gUserManager.DropOwner();
    }else if (owner) {
        gUserManager.DropOwner();
    }

    if (msg) {
        sys_msg=g_strdup_printf(_(" %d new msg"),msg);
        gtk_label_set(GTK_LABEL(system_message_label),sys_msg);
        g_free(sys_msg);
    } else {
        gtk_label_set(GTK_LABEL(system_message_label),_("No new msg"));
    }
#ifdef USE_PANEL
    set_panel_msg_count(msg,message);
#endif
    return(0);
}

gchar * 
gtk_button_get_label(GtkButton *button)
{
    gchar   *label;
    g_return_val_if_fail(button!=NULL,NULL);

    gtk_label_get(GTK_LABEL(GTK_BIN(button)->child),&label);
    return label;
}

GtkWidget *
gtk_menu_item_new_with_label_color_and_pixmap(gchar *label,
        GdkColor *color,
        GdkPixMask_t *pixmap) 
{
    GtkWidget   *menu_item;
    GtkWidget   *accel_label;
    GtkWidget   *container;
    GtkWidget   *g_pixmap;
    GtkStyle    *style;
    GdkGC       *gc;

    g_return_val_if_fail(label!=NULL,NULL);
    g_return_val_if_fail(pixmap!=NULL,NULL);
    menu_item = gtk_menu_item_new ();

    g_pixmap = gtk_pixmap_new(pixmap->pix,pixmap->mask);
    gtk_widget_ref(g_pixmap);
    gtk_object_set_data_full(GTK_OBJECT(menu_item),"g_pixmap",
            g_pixmap,(GtkDestroyNotify) gtk_widget_unref);

    container = gtk_hbox_new(FALSE,2);
    gtk_widget_ref(container);
    gtk_object_set_data_full(GTK_OBJECT(menu_item),"container",
            container,(GtkDestroyNotify) gtk_widget_unref);

    accel_label = gtk_accel_label_new (label);
    gtk_widget_ref(accel_label);
    gtk_object_set_data_full(GTK_OBJECT(menu_item),"accel_label",
            accel_label,(GtkDestroyNotify) gtk_widget_unref);

    
    gtk_misc_set_alignment (GTK_MISC (accel_label), 0.0, 0.5);
    gtk_accel_label_set_accel_widget (GTK_ACCEL_LABEL (accel_label), menu_item);
    gtk_box_pack_start(GTK_BOX(container),g_pixmap,FALSE,TRUE,0);
    gtk_box_pack_start(GTK_BOX(container),accel_label,TRUE,TRUE,0);
    gtk_container_add (GTK_CONTAINER (menu_item), container);

    gtk_widget_show (accel_label);
    gtk_widget_show (container);
    gtk_widget_show (menu_item);
    gtk_widget_show (g_pixmap);
    return menu_item; 
}

void
on_refuse2_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *refuse_textbox= lookup_widget(GTK_WIDGET(button),
            "refuse_textbox");
    GtkWidget       *refuse_dialog= lookup_widget(GTK_WIDGET(button),
            "refuse_dialog");
    CUserEvent      *e;
    unsigned long   uin;
    char            *reason;

    e = (CUserEvent *) gtk_object_get_data(GTK_OBJECT(refuse_dialog),"event");
    if (e==NULL)  {
        gbug("Cant find the event!\n");
        return;
    }
    uin=gtk_widget_get_active_uin(refuse_dialog);
    
    reason = gtk_editable_get_chars(GTK_EDITABLE(refuse_textbox),0,-1);
    
    if (e->SubCommand() == ICQ_CMDxSUB_FILE) {
        licq_daemon->icqFileTransferRefuse(uin,reason,e->Sequence());
    } else if (e->SubCommand() == ICQ_CMDxSUB_CHAT) {
        licq_daemon->icqChatRequestRefuse(uin,reason,e->Sequence());
    } else {
        gbug("Unknown ICQ sub cmd %x\n",e->SubCommand());
    }
    delete(e);
    gtk_widget_destroy(refuse_dialog);
            
}

GtkWidget *
popup_user_event_window         (unsigned long  uin,
                                 gint           view_mode,
                                 gint           send_page)
{
    GtkWidget       *event_window=NULL;
    ICQUser         *user;
    userdata_t      *userdata;

    if ((uin == 0) || (gUserManager.OwnerUin() == uin)) {
        userdata = (userdata_t *) gtk_object_get_data(GTK_OBJECT(main_window),
                "owner_userdata");
        uin = gUserManager.OwnerUin();
        view_mode=MODE_VIEW;
    } else {
        userdata = find_user_data(uin,NULL);
    }
    
    if(view_mode==MODE_UNSPEC) {
        user = (uin > 0)?gUserManager.FetchUser(uin,LOCK_R):
            gUserManager.FetchOwner(LOCK_R);
        if(user) {
            view_mode=user->NewMessages()?MODE_VIEW:MODE_SEND;
            gUserManager.DropUser(user);
        }
    }
    
    if(userdata != NULL) {
        if(view_mode==MODE_VIEW) {
            event_window=show_view_event_window_for_user(uin);
        }else {
            event_window=show_send_event_window_for_user(uin,send_page); 
        }
    }

    return event_window;
}

/* This function is shamelessly ripped from the gtkfontsel but as it was an
 * internal function, I don't dare to user theirs. */
const gchar*
ripped_gtk_font_selection_get_xlfd_field (const gchar *fontname,
        FontField    field_num,
        gchar       *buffer)
{
    const gchar *t1, *t2;
    gint countdown, len, num_dashes;

    if (!fontname)
        return NULL;

    /* we assume this is a valid fontname...that is, it has 14 fields */

    countdown = field_num;
    t1 = fontname;
    while (*t1 && (countdown >= 0))
        if (*t1++ == '-')
            countdown--;

    num_dashes = (field_num == XLFD_CHARSET) ? 2 : 1;
    for (t2 = t1; *t2; t2++)
    {
        if (*t2 == '-' && --num_dashes == 0)
            break;
    }

    if (t1 != t2)
    {
        /* Check we don't overflow the buffer */
        len = (long) t2 - (long) t1;
        if (len > XLFD_MAX_FIELD_LEN - 1)
            return NULL;
        strncpy (buffer, t1, len);
        buffer[len] = 0;

        /* Convert to lower case. */
        g_strdown (buffer);
    }
    else
        strcpy(buffer, "(nil)");

    return buffer;
}
/* end of ripp */

void
g_list_foreach_destroy  (gpointer data,
                         gpointer user_data)
{
    if(data) {
        free(data);
    }
}

gint
g_list_compare_uin  (gconstpointer a,
                     gconstpointer b)
{
    if((*(unsigned long*)a)==(*(unsigned long*)b)) {
        return 0;
    }else {
        return -1;
    }
}

gint
gtk_widget_set_active_uin   (GtkWidget      *widget,
                             unsigned long uin)
{
    unsigned long   *uinptr;
    GtkWidget       *parent=NULL;

    for (;;)
    {
        if (GTK_IS_MENU (widget)) {
            parent = gtk_menu_get_attach_widget (GTK_MENU (widget));
        }else {
            parent = widget->parent;
        }
        if (parent == NULL) {
            break;
        }
        widget = parent;
    }

    if(!widget) {
        return -1;
    }
    uinptr=(unsigned long*)malloc(sizeof(unsigned long));
    if(!uinptr) {
        return -1;
    }
    *uinptr=uin;
    gtk_object_set_data_full(GTK_OBJECT(widget),"active_uin",
            (gpointer)uinptr,(GtkDestroyNotify)destroy_notify_free);
    return 0;
}

unsigned long
gtk_widget_get_active_uin   (GtkWidget      *widget)
{
    unsigned long   *uinptr;
    GtkWidget       *parent=NULL;
    
    if (widget == NULL) {
        return(0);
    }
    
    for (;;)
    {
        if (GTK_IS_MENU (widget)) {
            parent = gtk_menu_get_attach_widget (GTK_MENU (widget));
        }else {
            parent = widget->parent;
        }
        if (parent == NULL) {
            break;
        }
        widget = parent;
    }

    uinptr=(unsigned long*)gtk_object_get_data(GTK_OBJECT(widget),"active_uin");

    if(!uinptr) {
        gbug("gtk_widget_get_active_uin: failed to get uin\n");
    }
    
    return (uinptr?*uinptr:0);
}

gboolean
popup_system_messages()
{
    GtkWidget       *event_window;
    GtkWidget       *notebook;
    ICQOwner        *owner = NULL;
    unsigned int    tmpuin = 0;

    owner=gUserManager.FetchOwner(LOCK_R);
    if (owner && owner->NewMessages()) {
        gUserManager.DropOwner();
        popup_user_event_window(0,MODE_VIEW,0);

        return TRUE;
    } else {
        if(owner) {
            gUserManager.DropOwner();
        }
        FOR_EACH_USER_START(LOCK_R);
        if (pUser->NewMessages()) {
            tmpuin = pUser->Uin();
            FOR_EACH_USER_BREAK;
        }
        FOR_EACH_USER_END;

        if(tmpuin)  {
            popup_user_event_window(tmpuin,MODE_VIEW,0);
            return TRUE;
        }
    }
    return FALSE;
}

gint
gtk_clist_compare_string(GtkCList *clist,
        GtkCListRow  *ptr1,
        GtkCListRow  *ptr2)
{
    return g_strcasecmp(ptr1->cell->u.text,ptr2->cell->u.text);
}

void
gtk_menu_detach_func_unref  (GtkWidget *attach_widget,
                             GtkMenu *menu)
{
    gtk_widget_unref(GTK_WIDGET(menu));
}

void 
find_and_mark_as_current(char *line)
{
    GtkWidget       *alias_clist=lookup_widget(main_window,"alias_clist");
    int len = gtk_clist_get_length(GTK_CLIST(alias_clist));
    int i;
    char *text;
    userdata_t *userdata;
   
    if(line) {
        for(i = 0; i < len; i++) {
            gtk_clist_get_text(GTK_CLIST(alias_clist),i,
                    configuration.quicksearchcol,&text);
            if (!strncasecmp(line,text,strlen(line))) {
                userdata = (userdata_t*) gtk_clist_get_row_data(
                        GTK_CLIST(alias_clist), i);
                gtk_widget_set_active_uin(main_window,userdata->uin);
                if(configuration.showactiveuser) {
                    gtk_clist_select_row(GTK_CLIST(alias_clist),i,-1);
                    gtk_clist_moveto(GTK_CLIST(alias_clist),i,1,0.5,0);
            }
                break;
            }
        }
    }
}

long 
time_diff(struct timeval *tva,struct timeval *tvb)
{
    if (tva->tv_sec == tvb->tv_sec) {
        gbug("time_diff 1: %ld\n",tva->tv_usec - tvb->tv_usec);
        return(tva->tv_usec - tvb->tv_usec);
    }

    if ((MAXLONG/1000000) <= (tva->tv_sec - tvb->tv_sec)) {
        gbug("time_diff MAXLONG! %ld  %ld %ld %ld\n",(MAXLONG/1000000),(tva->tv_sec - tvb->tv_sec),tva->tv_sec,tvb->tv_sec);
        return(MAXLONG);
    }

    if ((((tva->tv_sec - tvb->tv_sec)*1000000) + 
                (tva->tv_sec - tvb->tv_sec)) > MAXLONG) {
        gbug("time_diff MAXLONG! 3\n");
        return(MAXLONG);
    }
    gbug("time_diff %ld\n",(((tva->tv_sec - tvb->tv_sec)*1000000) + (tva->tv_usec - tvb->tv_usec))); 
    return((((tva->tv_sec - tvb->tv_sec)*1000000) + (tva->tv_usec - tvb->tv_usec)));
}

gint
just_filename_compare_func  (gconstpointer a,
                             gconstpointer b)
{
    char      *na,*nb;

    na=strrchr((const char*)a,'/');
    nb=strrchr((const char*)b,'/');

    if(!na) {
        na=(char*)a;
    }
    if(!nb) {
        nb=(char*)b;
    }

    return strcmp(na,nb);
}


GtkWidget *
gtk_container_get_label             (GtkContainer   *widget)
{
    GList       *children;

    children=gtk_container_children(widget);
    for(children=gtk_container_children(widget);children;children=g_list_next(children)) {
        if(GTK_IS_LABEL(GTK_WIDGET(children->data))) {
            return GTK_WIDGET(children->data);
        }
    }

    return NULL;
}


int
init_and_show_main_window()
{
    ICQOwner    *owner;
    gchar       *title;

    owner=gUserManager.FetchOwner(LOCK_R);
    if(!owner||!owner->GetAlias()) {
        title=g_strdup(_("Licq (New user)"));
    }else {
        title=g_strdup_printf(_("Licq (%s)"),owner->GetAlias());
    }
    gUserManager.DropOwner();

    main_window=GTK_WIDGET(create_main_window());
    gtk_window_set_title(GTK_WINDOW(main_window),title);
    g_free(title);

#ifdef USE_GNOME
    gbug("gnome_window_icon_set_from_file %s", LICQ_PREFIX "/share/pixmaps/gtklicq_small.png\n");
    gnome_window_icon_set_from_file(GTK_WINDOW(main_window), LICQ_PREFIX "/share/pixmaps/gtklicq_small.png");
#endif

    gtk_window_set_default_size(GTK_WINDOW(main_window),
            configuration.defaultwidth,
            configuration.defaultheight);
    gtk_widget_realize (main_window);
    /*  Setup the window and stuff so we get a freaking 
        window->gdkwindow */

    apply_options(TRUE);
    setup_widgets();

    refresh_grouplist();

    refresh_contactlist(gUserManager.DefaultGroup());
    if (((configuration.default_x >= 0) && (configuration.default_y >= 0)) &&
            (!configuration.wm_placement) && (!noplacement)){
        gtk_widget_set_uposition (main_window,configuration.default_x, 
                configuration.default_y);
    }
#ifdef USE_PANEL
    if(panel_dockapp&&configuration.starthidden) {
        gtk_widget_hide(main_window);
    }else {
        gtk_widget_show(main_window);
    }
#else
    gtk_widget_show (main_window);
#endif
    return 0;
}


void
stuff_combo_with_countries             (GtkCombo        *combo)
{
    static GList *countries=NULL;
   
    if (combo != NULL) {
        if(!countries) {
            for(int i=0; i < NUM_COUNTRIES; i++) {
                countries = g_list_append(countries,gCountries[i].szName);
            }
        }
        gtk_combo_set_popdown_strings(GTK_COMBO(combo),countries);
    }
}

    void
stuff_combo_with_languages             (GtkCombo        *combo)
{
    static GList *languages=NULL;

    if (combo != NULL) {
        if(!languages) {
            for(int i=0; i < NUM_LANGUAGES; i++) {
                languages = g_list_append(languages,gLanguages[i].szName);
            }
        }
        gtk_combo_set_popdown_strings(GTK_COMBO(combo),languages);
    }
}

void
gtk_widget_set_color                   (GtkWidget       *widget,
                                        gboolean        setback,
                                        gboolean        setfore,
                                        gushort         br,
                                        gushort         bg,
                                        gushort         bb,
                                        gushort         fr,
                                        gushort         fg,
                                        gushort         fb)
{
    GdkColormap     *cmap;
    GtkStyle        *style;
    GdkColor        tmp_color;

    if(!setfore&&!setback) {
        return ;
    }
    cmap=gtk_widget_get_colormap(gtk_widget_get_toplevel(widget));
    if (cmap != NULL) {
        style = gtk_style_copy(gtk_widget_get_style(widget));
        if(setback) {
            tmp_color.red = br;
            tmp_color.green = bg;
            tmp_color.blue = bb;
            gdk_colormap_alloc_color(cmap,&tmp_color,TRUE,TRUE);
            style->base[GTK_STATE_NORMAL] = tmp_color;
        }
        if(setfore) {
            tmp_color.red = fr;
            tmp_color.green = fg;
            tmp_color.blue = fb;
            gdk_colormap_alloc_color(cmap,&tmp_color,TRUE,TRUE);
            style->text[GTK_STATE_NORMAL] = tmp_color;
        }
        gtk_widget_hide(widget);
        gtk_widget_set_style(widget,style);
        gtk_widget_show(widget);
    }
}

void
update_status_display()
{
    GtkWidget       *status_label=lookup_widget(main_window,
            "status_label");
    GtkWidget       *status_pixmap=lookup_widget(main_window,"status_pixmap");
    ICQOwner        *owner;
    GdkPixMask_t    *ustatus;

    if(!status_pixmap||!status_label) {
        return ;
    }

    owner=gUserManager.FetchOwner(LOCK_R);
    ustatus=getuserstatusicon(owner,FALSE);
    gtk_pixmap_set(GTK_PIXMAP(status_pixmap),ustatus->pix,ustatus->mask);
    gUserManager.DropUser(owner);
    update_status_timer(NULL);

    sys_msgbar_set();
}

gboolean
update_status_timer(gpointer data)
{
    static time_t   stime=time(NULL);
    time_t          ctime;
    static unsigned short  laststatus=ICQ_STATUS_OFFLINE;
    GtkWidget       *status_label=lookup_widget(main_window,"status_label");
    ICQOwner        *owner;
    gchar           msg[64];

    if(!configuration.showstatustimer) {
        statustimerfunctionactive=FALSE;
    }

    if(!status_label) {
        return configuration.showstatustimer;
    }

    owner=gUserManager.FetchOwner(LOCK_R);
    if(configuration.showstatustimer) {
        if(owner->Status()!=laststatus) {
            laststatus=owner->Status();
            stime=time(NULL);
        }
        ctime=time(NULL)-stime;
        if(!owner->StatusInvisible()) { 
            snprintf(msg,64,"[%ld:%.2ld]",ctime/3600, (ctime%3600)/60);
        }else {
            snprintf(msg,64,"[%ld:%.2ld]",ctime/3600,(ctime%3600)/60);
        }
    }else {
        if(!owner->StatusInvisible()) { 
            snprintf(msg,64,"%s",status_string(owner->Status(),FALSE));
        }else {
            snprintf(msg,64,"(%s)",status_string(owner->Status(),FALSE));
        }
    }
    gUserManager.DropUser(owner);
    gtk_label_set(GTK_LABEL(status_label),msg);

    return configuration.showstatustimer;
}

userdata_t *
create_blank_userdata                  (unsigned long 
                                                    uin)
{
    userdata_t      *userd;
    if(!(userd=(userdata_t*)malloc(sizeof(userdata_t)))) {
        gbug("create_blank_userdata: could not malloc!!\n");
        return NULL;
    }
    userd->send_event_window=NULL;
    userd->view_event_window=NULL;
    userd->history_dialog=NULL;
    userd->info_dialog=NULL;
    userd->send_events=NULL;
    userd->last_away_mess=NULL;
    userd->floating_window=NULL;
    userd->uin=uin;
#ifdef USE_PSPELL
    userd->spellmanager=NULL;
#endif

    return userd;
}
