#ifndef FUNCTIONS_H_INCLUDED
#define FUNCTIONS_H_INCLUDED

#include "gtk-gui.h"
#include "multiuser_chat.h"

bool 
sound_signal_callback                  (CICQSignal  *signal, 
                                        gpointer    data);

bool 
secure_signal_callback                 (CICQSignal  *signal, 
                                        gpointer    data);

bool 
secure_result_callback                 (ICQEvent    *event, 
                                        gpointer    data);

void 
view_url                               (const char  *url);

GdkPixMask_t *
getuserstatusicon                      (ICQUser     *user,
                                        gboolean    careforevents);

GdkColor *
getuserstatuscolor                     (ICQUser     *user);

void 
destroy_notify_free_userdata           (GtkWidget   *widget, 
                                        gpointer    dummy);
    
void
destroy_notify_free                    (gpointer    data);

char *
geticqeventerrorstring                 (EventResult result);

GtkJustification
get_justification                      (gchar       *descr);

int
get_status_sort_index                  (unsigned short 
                                                    status);

char *
get_window_type_text                   (EWinType    type);

userdata_t *
real_find_user_data                    (GtkWidget   *alias_clist,
                                        unsigned long
                                                    uin,
                                        int         *row);

userdata_t *
find_user_data                         (unsigned long 
                                                    uin,
                                        int         *row);

int
get_sort_index                         (ICQUser     *u1, 
                                        ICQUser     *u2,
                                        gushort     sortby);

unsigned long
get_user_uin_from_sysmsg               (gchar       *msg);

gchar
get_message_expanded_text_max_length   (gchar       *message,
                                        gchar       r_char);

gint
get_message_expanded_length            (GtkText     *mbox);

char
*EventDescription                      (CUserEvent  *e);

int 
set_status                             (unsigned short 
                                                    status);

int 
gtk_clist_get_length                   (GtkCList    *clist);

const char *
status_string                          (unsigned short 
                                                    status,
                                        gboolean    shrt);

int
gtk_option_menu_get_history            (GtkOptionMenu 
                                                    *menu);

int 
sys_msgbar_set();

gchar * 
gtk_button_get_label                   (GtkButton   *button);

GtkWidget *
gtk_menu_item_new_with_label_color_and_pixmap
                                       (gchar       *label,
                                        GdkColor    *color,
                                        GdkPixMask_t 
                                                    *pixmap) ;

GtkWidget *
popup_user_event_window                (unsigned long  
                                                    uin,
                                        gint        view_mode,
                                        gint        send_page);

const gchar *
ripped_gtk_font_selection_get_xlfd_field
                                       (const gchar *fontname,
                                        FontField   field_num,
                                        gchar       *buffer);

void
g_list_foreach_destroy                 (gpointer    data,
                                        gpointer    user_data);


gint
g_list_compare_uin                     (gconstpointer 
                                                    a,
                                        gconstpointer 
                                                    b);

gint
gtk_widget_set_active_uin              (GtkWidget   *widget,
                                        unsigned long 
                                                    uin);

unsigned long
gtk_widget_get_active_uin              (GtkWidget   *widget);

gboolean
popup_system_messages();

gint
gtk_clist_compare_string               (GtkCList    *clist,
                                        GtkCListRow *ptr1,
                                        GtkCListRow *ptr2);

void
gtk_menu_detach_func_unref             (GtkWidget   *attach_widget,
                                        GtkMenu     *menu);

void 
find_and_mark_as_current               (char        *line);

long 
time_diff                              (struct timeval 
                                                    *tva,
                                        struct timeval 
                                                    *tvb);

gint
just_filename_compare_func             (gconstpointer 
                                                    a,
                                        gconstpointer 
                                                    b);

GdkPixMask_t *
geticonforevent                         (unsigned short 
                                                    subcommand);

GtkWidget *
gtk_container_get_label                 (GtkContainer   
                                                    *widget);

int
init_and_show_main_window();

void
stuff_combo_with_countries             (GtkCombo    *combo);

void
stuff_combo_with_languages             (GtkCombo    *combo);

void
gtk_widget_set_color                   (GtkWidget   *widget,
                                        gboolean    setback,
                                        gboolean    setfore,
                                        gushort     br,
                                        gushort     bg,
                                        gushort     bb,
                                        gushort     fr,
                                        gushort     fg,
                                        gushort     fb);

void
update_status_display();

gboolean
update_status_timer                    (gpointer    data);

userdata_t *
create_blank_userdata                  (unsigned long 
                                                    uin);
#endif /* FUNCTIONS_H_INCLUDED */ 
