#include "gtk-gui.h"

#include <sys/time.h>

#ifdef USE_PANEL

#include "gnomedock.h"
#include "functions.h"

    /*  Globals */
GtkWidget   *panel_dockapp=NULL;

#ifdef HAVE_PANEL_PIXEL_SIZE
static void
applet_change_pixel_size               (GtkWidget   *w, 
                                        int         size, 
                                        gpointer    data)
{
    GtkWidget       *event_label=lookup_widget(panel_dockapp,
            "event_label");

    if(size<PIXEL_SIZE_SMALL) {
        gtk_widget_hide(event_label);     
    }else {
        gtk_widget_show(event_label);
    }
}
#endif


void
on_toggle_main_window_activate  (AppletWidget *applet, 
                                 gpointer data)
{
    static int x_pos = -1, y_pos = -1;
    
    if(!GTK_WIDGET_VISIBLE(main_window)) {
        if ((x_pos >= 0) && (y_pos >= 0)) {
            gtk_widget_set_uposition  (main_window, x_pos, y_pos);
        }
        gtk_widget_show(main_window);
    }else {
        gdk_window_get_root_origin (main_window->window,&x_pos,&y_pos);
        gtk_widget_hide(main_window);
    }
}

void
on_status_pixmap_double_click   (GtkWidget *widget,
                                 GdkEventButton *event,
                                 gpointer user_data)
{
    struct timeval          tmp_time;
    static struct timeval   dclick={0,0};
    long            td;
    
    gettimeofday(&tmp_time,NULL);
    td = time_diff(&tmp_time,&dclick);
    dclick.tv_sec = tmp_time.tv_sec;
    dclick.tv_usec = tmp_time.tv_usec;
    if (((event->type == GDK_2BUTTON_PRESS) &&
                (!configuration.singleclick)) ||
            ((event->type == GDK_BUTTON_PRESS) &&
             (td > DCLICK_DELAY) && //prevent from doubleclick!
             (configuration.singleclick))){
        if(!popup_system_messages()) {
            on_toggle_main_window_activate(NULL,NULL);
        }
    }
}

static void
change_dockapp_orient       (AppletWidget *w, 
                             PanelOrientType o)
{
    GtkWidget       *pixmap_eventbox=lookup_widget(panel_dockapp,
            "pixmap_eventbox");
    GtkWidget       *event_label=lookup_widget(panel_dockapp,
            "event_label");
    GtkWidget       *panel_box,*opanel_box=lookup_widget(panel_dockapp,
            "panel_box");
    GtkWidget       *frame=lookup_widget(panel_dockapp,"frame");
    int lable_visible = 0;
   
    gbug("change_dockapp_orient: enter\n"); 
    if(o==ORIENT_LEFT||o==ORIENT_RIGHT) {
        panel_box=gtk_hbox_new(FALSE,3);
    }else {
        panel_box=gtk_vbox_new(FALSE,3);
    }
    lable_visible = GTK_WIDGET_VISIBLE(event_label);
    
    gtk_widget_ref(event_label);
    gtk_widget_ref(pixmap_eventbox);
    gtk_widget_ref(panel_box);
    gtk_container_remove(GTK_CONTAINER(opanel_box),event_label);
    gtk_container_remove(GTK_CONTAINER(opanel_box),pixmap_eventbox);
    gtk_container_remove(GTK_CONTAINER(frame),opanel_box);
    gtk_object_set_data_full(GTK_OBJECT(panel_dockapp),"panel_box",
            panel_box, (GtkDestroyNotify)gtk_widget_unref);
    gtk_box_pack_start(GTK_BOX(panel_box),pixmap_eventbox,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(panel_box),event_label,FALSE,FALSE,0);
    gtk_container_add(GTK_CONTAINER(frame),panel_box);
    
    gtk_widget_show(panel_box);
    gtk_widget_show_all(pixmap_eventbox);
    if (lable_visible) {
        gtk_widget_show_all(event_label);
    }
    gbug("change_dockapp_orient: leave\n"); 
}

void
create_dock_widget()
{

    GtkWidget       *panel_vbox, *event_label, *status_pixmap, *pixmap_eventbox,
                    *frame;
    GdkPixMask_t    *ustatus;
    ICQOwner        *owner;

    panel_dockapp=applet_widget_new("gtklicq");
    if (!panel_dockapp) {
        showokdialog(_("Gnome-Applet"),_("Failed to create Gnome applet"));
        return;
    }

    frame=gtk_vbox_new(FALSE,0);
    gtk_object_set_data_full(GTK_OBJECT(panel_dockapp),"frame",frame,
            (GtkDestroyNotify)gtk_widget_unref);
    gtk_widget_ref(frame);

    panel_vbox=gtk_vbox_new(FALSE,3);
    gtk_object_set_data_full(GTK_OBJECT(panel_dockapp),"panel_box",panel_vbox,
            (GtkDestroyNotify)gtk_widget_unref);
    gtk_widget_ref(panel_vbox);
    gtk_container_add(GTK_CONTAINER(frame),panel_vbox);

    pixmap_eventbox=gtk_event_box_new();
    gtk_object_set_data_full(GTK_OBJECT(panel_dockapp),"pixmap_eventbox",
            pixmap_eventbox, (GtkDestroyNotify)gtk_widget_unref);
    gtk_widget_ref(pixmap_eventbox);
    gtk_box_pack_start(GTK_BOX(panel_vbox),pixmap_eventbox,FALSE,FALSE,0);
    
    status_pixmap=gtk_pixmap_new(status_pixmap_offline.pix,
            status_pixmap_offline.mask);
    gtk_object_set_data_full(GTK_OBJECT(panel_dockapp),"status_pixmap",
            status_pixmap, (GtkDestroyNotify)gtk_widget_unref);
    gtk_widget_ref(status_pixmap);
    gtk_container_add(GTK_CONTAINER(pixmap_eventbox),status_pixmap);

    event_label=gtk_label_new("0");
    gtk_object_set_data_full(GTK_OBJECT(panel_dockapp),"event_label",
            event_label, (GtkDestroyNotify)gtk_widget_unref);
    gtk_widget_ref(event_label);
    gtk_label_set_justify(GTK_LABEL(event_label),GTK_JUSTIFY_CENTER);
    gtk_box_pack_start(GTK_BOX(panel_vbox),event_label,FALSE,FALSE,0);

    gtk_widget_show_all(panel_vbox);

    applet_widget_register_callback_dir (APPLET_WIDGET (panel_dockapp),
            "status_menu",
            _("Status"));
    applet_widget_register_callback (APPLET_WIDGET (panel_dockapp),
            "status_menu/online",
            _("Online"),
            (AppletCallbackFunc)on_set_status_with_no_message_activate,
            GINT_TO_POINTER(ICQ_STATUS_ONLINE));
    applet_widget_register_callback (APPLET_WIDGET (panel_dockapp),
            "status_menu/offline",
            _("Offline"),
            (AppletCallbackFunc)on_set_status_with_no_message_activate,
            GINT_TO_POINTER(ICQ_STATUS_OFFLINE));
    applet_widget_register_callback (APPLET_WIDGET (panel_dockapp),
            "status_menu/away",
            _("Away"),
            (AppletCallbackFunc)on_set_status_with_message_activate,
            GINT_TO_POINTER(ICQ_STATUS_AWAY));
    applet_widget_register_callback (APPLET_WIDGET (panel_dockapp),
            "status_menu/not_available",
            _("Not Available"),
            (AppletCallbackFunc)on_set_status_with_message_activate,
            GINT_TO_POINTER(ICQ_STATUS_NA));
    applet_widget_register_callback (APPLET_WIDGET (panel_dockapp),
            "status_menu/do_not_disturb",
            _("Do Not Disturb"),
            (AppletCallbackFunc)on_set_status_with_message_activate,
            GINT_TO_POINTER(ICQ_STATUS_DND));
    applet_widget_register_callback (APPLET_WIDGET (panel_dockapp),
            "status_menu/occupied",
            _("Occupied"),
            (AppletCallbackFunc)on_set_status_with_message_activate,
            GINT_TO_POINTER(ICQ_STATUS_OCCUPIED));
    applet_widget_register_callback (APPLET_WIDGET (panel_dockapp),
            "status_menu/free_for_chat",
            _("Free For Chat"),
            (AppletCallbackFunc)on_set_status_with_message_activate,
            GINT_TO_POINTER(ICQ_STATUS_FREEFORCHAT));
    applet_widget_register_callback (APPLET_WIDGET (panel_dockapp),
            "status_menu/invisible",
            _("Invisible"),
            (AppletCallbackFunc)on_set_status_invisible_activate,
            NULL);

    applet_widget_register_callback(APPLET_WIDGET(panel_dockapp),
            "set_auto_response",
            _("Set auto response ..."),
            (AppletCallbackFunc)on_set_auto_response_1_activate,
            NULL);

    applet_widget_register_callback(APPLET_WIDGET(panel_dockapp),
            "toggle_main_window",
            _("Toggle main window"),
            (AppletCallbackFunc)on_toggle_main_window_activate,
            NULL);
    
    gtk_signal_connect (GTK_OBJECT (panel_dockapp), "change_orient",
            GTK_SIGNAL_FUNC (change_dockapp_orient), NULL);
    gtk_signal_connect (GTK_OBJECT (pixmap_eventbox), "button-press-event",
            GTK_SIGNAL_FUNC (on_status_pixmap_double_click), NULL);
#ifdef HAVE_PANEL_PIXEL_SIZE
    gtk_signal_connect (GTK_OBJECT (panel_dockapp), "change_pixel_size",
            GTK_SIGNAL_FUNC (applet_change_pixel_size), NULL);
#endif
    sys_msgbar_set();
    applet_widget_add (APPLET_WIDGET (panel_dockapp), frame);
    gtk_widget_show(frame);
    gtk_widget_show(panel_dockapp);
}

void
set_panel_msg_count                    (int     count,
                                        gchar   *hint)
{
    GtkWidget       *event_label;
    gchar           msg[15];
    ICQOwner        *owner;

    if(!panel_dockapp) {
        return ;
    }    

    event_label=lookup_widget(panel_dockapp,"event_label");
    sprintf(msg,"%d",count);
    gtk_label_set(GTK_LABEL(event_label),msg);
    set_panel_status_pixmap(hint);
}

void
set_panel_status_pixmap                (gchar   *message)
{
    GtkWidget       *status_pixmap=NULL;
    GdkPixMask_t    *ustatus=NULL;
    ICQOwner        *owner;


    if(!panel_dockapp) {
        return ;
    }    

    owner=gUserManager.FetchOwner(LOCK_R);
    if(owner&&owner->NewMessages()) {
        ustatus=getuserstatusicon(owner,TRUE);
        gUserManager.DropOwner();
    }else if (owner) {
        gUserManager.DropOwner();
    }
    FOR_EACH_USER_START(LOCK_R);
        if (pUser->NewMessages()) {
            if(!ustatus) {
                ustatus=getuserstatusicon(pUser,TRUE);
            }
        }
    FOR_EACH_USER_END;
    if(!ustatus) {
        owner=gUserManager.FetchOwner(LOCK_R);
        ustatus=getuserstatusicon(owner,FALSE);
        gUserManager.DropOwner();
    }
    status_pixmap=lookup_widget(panel_dockapp,"status_pixmap");
    if(!configuration.blinkicons) {
        gtk_pixmap_set(GTK_PIXMAP(status_pixmap),ustatus->pix,
                ustatus->mask);
    }else {
        gtk_object_set_data(GTK_OBJECT(status_pixmap),"status_pixmap",
                (gpointer)ustatus);
    }
    applet_widget_set_tooltip(APPLET_WIDGET(panel_dockapp),
            (*message?message:NULL));
}

void
remove_dock_applet() 
{
    gbug("remove_dock_applet: in\n");
    if(!panel_dockapp) {
        return ;
    }

    gbug("remove_dock_applet: do\n");
    applet_widget_remove(APPLET_WIDGET(panel_dockapp));
    panel_dockapp=NULL;
}

#endif  /*  USE_PANEL */
