#include "gtk-gui.h"

#include <sys/time.h>
#include <stdio.h>

#include "interface.h"
#include "contactlist.h"


void
groupdialog_setup_namedit(bool postedit, bool addnew)
{
    GtkWidget   *g_add_button=lookup_widget(groups_dialog,"g_add_button");
    GtkWidget   *g_remove_button=lookup_widget(groups_dialog,"g_remove_button");
    GtkWidget   *g_shift_up_button=lookup_widget(groups_dialog,
            "g_shift_up_button");
    GtkWidget   *g_shift_down_button=lookup_widget(groups_dialog,
            "g_shift_down_button");
    GtkWidget   *g_edit_name_button=lookup_widget(groups_dialog,
            "g_edit_name_button");
    GtkWidget   *g_default_button=lookup_widget(groups_dialog,
            "g_default_button");
    GtkWidget   *g_name_entry=lookup_widget(groups_dialog, "g_name_entry");
    GtkWidget   *g_name_label=lookup_widget(groups_dialog, "g_name_label");
    GtkWidget   *g_set_name_button=lookup_widget(groups_dialog, 
            "g_set_name_button");
    GtkWidget   *groups_clist=lookup_widget(groups_dialog, "groups_clist");

    if(postedit) {
        if(addnew) {
            gtk_licq_button_set(GTK_BUTTON(g_add_button),GTK_LICQ_BUTTON_ADDL);
            gtk_object_set_user_data(GTK_OBJECT(g_add_button),GINT_TO_POINTER(0));
        }else {
            gtk_licq_button_set(GTK_BUTTON(g_edit_name_button),_("Edit Name"));
            gtk_object_set_user_data(GTK_OBJECT(g_edit_name_button),
                    GINT_TO_POINTER(0));
        }
        gtk_widget_hide(g_name_entry);
        gtk_widget_hide(g_name_label);
        gtk_widget_hide(g_set_name_button);
    }else {
        if(addnew) {
            gtk_licq_button_set(GTK_BUTTON(g_add_button),
                    GTK_LICQ_BUTTON_CANCELL);
            gtk_object_set_user_data(GTK_OBJECT(g_add_button),GINT_TO_POINTER(1));
        }else {
            gtk_licq_button_set(GTK_BUTTON(g_edit_name_button),
                    GTK_LICQ_BUTTON_CANCELL);
            gtk_object_set_user_data(GTK_OBJECT(g_edit_name_button),
                    GINT_TO_POINTER(1));
        }
        gtk_widget_show(g_name_entry);
        gtk_widget_show(g_name_label);
        gtk_widget_show(g_set_name_button);
    }
    gtk_widget_set_sensitive(g_add_button, (addnew?TRUE:postedit));
    gtk_widget_set_sensitive(g_remove_button, postedit);
    gtk_widget_set_sensitive(g_shift_up_button, postedit);
    gtk_widget_set_sensitive(g_shift_down_button, postedit);
    gtk_widget_set_sensitive(g_edit_name_button, (addnew?postedit:TRUE));
    gtk_widget_set_sensitive(g_default_button, postedit);
    gtk_widget_set_sensitive(groups_clist, postedit);
}

void
groupdialog_refresh() 
{
    GtkWidget       *g_default=lookup_widget(groups_dialog, "g_default_entry");
    GtkWidget       *grouplist=lookup_widget(groups_dialog,"groups_clist");
    GroupList       *groups;
    unsigned int    i;
    gchar           *newrow[2];


    newrow[0]=_("All users");
    newrow[1]=NULL;
    gtk_clist_freeze(GTK_CLIST(grouplist));
    gtk_clist_clear(GTK_CLIST(grouplist));
    
    gtk_clist_append(GTK_CLIST(grouplist), newrow);
    groups=gUserManager.LockGroupList(LOCK_R);
    if(groups) {
        for (i=0;i<groups->size();i++)
        { 
            newrow[0]=(gchar*)(*groups)[i];
            gtk_clist_append(GTK_CLIST(grouplist), newrow);
        }
        if(gUserManager.DefaultGroup()) {
            gtk_entry_set_text(GTK_ENTRY(g_default),
                    (gchar*)(*groups)[gUserManager.DefaultGroup()-1]);
        }else {
            gtk_entry_set_text(GTK_ENTRY(g_default), _("All users"));
        }
    } 
    gUserManager.UnlockGroupList();
    gtk_clist_thaw(GTK_CLIST(grouplist));
}

void
on_g_add_button_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget   *g_add_button=lookup_widget(groups_dialog,"g_add_button");
    GtkWidget   *g_name_entry=lookup_widget(groups_dialog, "g_name_entry");
    int         postedit=-1;

    postedit=GPOINTER_TO_INT(gtk_object_get_user_data(GTK_OBJECT(g_add_button)));
    gtk_entry_set_text(GTK_ENTRY(g_name_entry),"");
    groupdialog_setup_namedit(postedit,TRUE);
}


void
on_g_remove_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *grouplist=lookup_widget(groups_dialog,"groups_clist");
    int             group;

    if(GTK_CLIST(grouplist)->selection) {
        group=GPOINTER_TO_INT(GTK_CLIST(grouplist)->selection->data);
        if(!group) {
            return;
        }
        gUserManager.RemoveGroup(group);
    }
    groupdialog_refresh();
    refresh_grouplist();
}


void
on_g_shift_up_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget   *groups_clist=lookup_widget(groups_dialog,"groups_clist");
    int         group;

    if(GTK_CLIST(groups_clist)->selection) {
        group=GPOINTER_TO_INT(GTK_CLIST(groups_clist)->selection->data);
    }else {
        gbug("on_g_shift_up_clicked: No selection\n");
        return ;
    }
    if(group<=1) {
        return;
    }
    gUserManager.SwapGroups(group-1,group);
    groupdialog_refresh();
    refresh_grouplist();
    gtk_clist_select_row(GTK_CLIST(groups_clist),group-1,-1);
}


void
on_g_shift_down_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget   *groups_clist=lookup_widget(groups_dialog,"groups_clist");
    int         group;

    if(GTK_CLIST(groups_clist)->selection) {
        group=GPOINTER_TO_INT(GTK_CLIST(groups_clist)->selection->data);
    }else {
        gbug("on_g_shift_down_clicked: No selection\n");
        return ;
    }
    if(group>=gUserManager.NumGroups()) {
        return;
    }
    gUserManager.SwapGroups(group+1,group);
    groupdialog_refresh();
    refresh_grouplist();
    gtk_clist_select_row(GTK_CLIST(groups_clist),group+1,-1);
}


void
on_g_edit_name_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget   *g_edit_name_button=lookup_widget(groups_dialog,
            "g_edit_name_button");
    GtkWidget   *g_name_entry=lookup_widget(groups_dialog, "g_name_entry");
    GtkWidget   *groups_clist=lookup_widget(groups_dialog,"groups_clist");
    GroupList   *groups;
    GList       *edit_childs;
    gchar       *label;
    int         group;
    int         postedit=-1;

    if(GTK_CLIST(groups_clist)->selection) {
        group=GPOINTER_TO_INT(GTK_CLIST(groups_clist)->selection->data);
    }else {
        gbug("on_g_edit_name_clicked: No selection\n");
        return ;
    }
    if(!group) {
        return;
    }
    postedit=GPOINTER_TO_INT(gtk_object_get_user_data(
                GTK_OBJECT(g_edit_name_button)));
    groupdialog_setup_namedit(postedit,FALSE);
    if(postedit) {
        return;
    }

    groups=gUserManager.LockGroupList(LOCK_R);
    gtk_entry_set_text(GTK_ENTRY(g_name_entry),(gchar*)(*groups)[group-1]);
    gUserManager.UnlockGroupList();
}


void
on_g_default_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *groups_clist=lookup_widget(groups_dialog,"groups_clist");
    int             group=-1;

    gbug("on_g_default_clicked\n");
    if(GTK_CLIST(groups_clist)->selection) {
        group=GPOINTER_TO_INT(GTK_CLIST(groups_clist)->selection->data);
        gUserManager.SetDefaultGroup(group);
        groupdialog_refresh();
        gtk_clist_select_row(GTK_CLIST(groups_clist),group,-1);
    }
}


void
on_groups_dialog_show                  (GtkWidget       *widget,
                                        gpointer         user_data)
{
    GtkWidget       *g_default=lookup_widget(widget, "g_default_entry");
    GtkWidget       *g_name=lookup_widget(widget, "g_name_entry");
    GtkWidget       *g_label_name=lookup_widget(widget, "g_name_label");
    GtkWidget       *g_set_name_button=lookup_widget(widget, 
            "g_set_name_button");

    gbug("on_groups_dialog_show\n");
    gtk_widget_set_sensitive(g_default,FALSE);
    gtk_widget_hide(g_name);
    gtk_widget_hide(g_label_name);
    gtk_widget_hide(g_set_name_button);

    groupdialog_refresh();
}

void
on_groups_dialog_destroy               (GtkButton       *button,
                                        gpointer         user_data)
{
    groups_dialog=NULL; 
}

void
on_g_set_name_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget   *g_edit_name_button=lookup_widget(groups_dialog,
            "g_edit_name_button");
    GtkWidget   *g_name_entry=lookup_widget(groups_dialog, "g_name_entry");
    GtkWidget   *groups_clist=lookup_widget(groups_dialog,"groups_clist");
    gchar       *label;
    int         group;
    bool        isadd=TRUE;

    label=gtk_editable_get_chars(GTK_EDITABLE(g_name_entry),0,-1);
    if(label&&strlen(label)) {
        if(GTK_WIDGET_SENSITIVE(g_edit_name_button)) {
            isadd=FALSE;
            if(GTK_CLIST(groups_clist)->selection) {
                group=GPOINTER_TO_INT(GTK_CLIST(groups_clist)->selection->data);
            }else {
                gbug("on_g_edit_name_clicked: No selection\n");
                return ;
            }
            gUserManager.RenameGroup(group,label);
        }
        else {
            gUserManager.AddGroup(label);
            group=gUserManager.NumGroups();
        }
        groupdialog_refresh();
        refresh_grouplist();
        gtk_clist_select_row(GTK_CLIST(groups_clist),group,-1);
    }
    g_free(label);
    groupdialog_setup_namedit(TRUE,isadd);    
}


gboolean
on_groups_dialog_delete_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    gtk_widget_destroy(groups_dialog);
    return FALSE;
}


void
on_groups_dialog_done                  (GtkButton       *button,
                                        gpointer         user_data)
{
    gtk_widget_destroy(groups_dialog);
}


