#include "gtk-gui.h"

#include <sys/time.h>
#include <unistd.h>

#include "licq_plugin.h"

#include "interface.h"
#include "contactlist.h"
#include "functions.h"
#include "signalhandler.h"
#include "network_dialog.h"
#include "gnomedock.h"
#include "registration_wizard.h"
#include "search_dialog.h"
#include "user_info_dialog.h"

#ifdef ENABLE_NLS
#   include <libintl.h>
#endif
#ifdef USE_PANEL
#include <applet-widget.h>
#endif

    /*  Globals */ 
GtkWidget   *main_window;
CICQDaemon  *licq_daemon;
extern struct timeval dclick;
int nopanel=0;
//static int noplacement = 0;

/*----------------------------------------------------------------------------n
 * Name
 *
 * Returns the name of the plugin.  Should use a static character array.
 *----------------------------------------------------------------------------*/
const char *
LP_Name() 
{
    gbug("LP_Name()\n");
    return PACKAGE;
}


/*------------------------------------------------------------------------------
 * Version
 *
 * Returns the version of the plugin.  Should use a static character array.
 *----------------------------------------------------------------------------*/
const char *
LP_Version()
{
    gbug("LP_Version()\n");
    return VERSION;
}


/*------------------------------------------------------------------------------
 * Status
 *
 * Returns the status of the plugin.  Typically this will be enabled or
 * disabled.  Rarely relevant for a main interface plugin.
 * Should use a static character array.
 *----------------------------------------------------------------------------*/
const char *
LP_Status()
{
    gbug("LP_Status()\n");
    return GTK_GUI_STATUS;
}


/*------------------------------------------------------------------------------
 * Description
 *
 * Returns a brief (one line) description of the plugin
 * Should use a static character array.
 *----------------------------------------------------------------------------*/
const char *
LP_Description()
{
    gbug("LP_Description()\n");
    return GTK_GUI_DESCRIPTION;
}


/*------------------------------------------------------------------------------
 * Usage
 *
 * Returns a usage string.
 *----------------------------------------------------------------------------*/
const char *
LP_Usage()
{
    gbug("LP_Usage()\n");
    return GTK_GUI_USAGE;
}

/*------------------------------------------------------------------------------
 * ConfigFile
 *
 * Returns the config file we use.
 *----------------------------------------------------------------------------*/
const char *LP_ConfigFile()
{
    gbug("LP_ConfigFile()\n");
    return GTK_GUI_CONFIG_FILE;
}

/*------------------------------------------------------------------------------
 * Init
 *
 * This function is called to initialize the plugin.  It is passed the
 * relevant command line parameters to be parsed using getopt().  It should
 * return whether or not it started successfully.
 *----------------------------------------------------------------------------*/
bool 
LP_Init(int argc, char **argv)
{
#ifdef USE_GNOME
    struct poptOption options[] = {
#ifdef USE_PANEL
        {"nopanel",'p',POPT_ARG_NONE,&nopanel,0,_("Disable panel docking"),NULL},
#endif
        {"noplacement",'w',POPT_ARG_NONE,&noplacement,0,_("Let the WM place the windows"),NULL},
        {NULL,'\0',0,NULL,0,NULL,NULL}
    };

#else
    
     int c;
     while ((c=getopt(argc,argv,"w")) != EOF) {
         switch (c){
             case 'w':
                 noplacement = 1;
                 gbug("noplacement!\n");
                 break;
             case '?':
                 gbug("Unknown option\n");
                 break;
         }
     }
#endif

    gbug("LP_Init()\n");
    if(load_configuration()) {
        return FALSE;
    }
    
#ifdef ENABLE_NLS
    setlocale(LC_ALL,"");
    bindtextdomain("gtk+licq",PACKAGE_LOCALE_DIR); 
    textdomain("gtk+licq");
#endif

    gtk_set_locale();

#ifdef USE_PANEL
    return applet_widget_init(PACKAGE, NULL, argc, argv, options,0,NULL);
#else
#ifdef USE_GNOME
    return (gnome_init_with_popt_table(argv[0],VERSION,argc,argv,options,0,NULL)?FALSE:TRUE); 
#else
    return gtk_init_check(&argc, &argv);
#endif
#endif
}

/*------------------------------------------------------------------------------
 * Main
 *
 * This function is called to actually run the plugin.  It is run in it's own
 * thread so may block.  It is passed a pointer to the licq daemon with which
 * it *must* register before sending any requests.  It returns an integer
 * return code.
 *----------------------------------------------------------------------------*/
int 
LP_Main(CICQDaemon *licqmain)
{
    int         licq_pipe, regres=0;
    char        *pixdir;
    
    gbug("LP_Main()\n");
    licq_daemon = licqmain;
    licq_pipe=licqmain->RegisterPlugin(SIGNAL_ALL);
    

    if ((pixdir = g_strdup_printf("%s/pixmaps",GTKGUI_DIR)) != NULL) {
        add_pixmap_directory(pixdir);
        free(pixdir);
    }

    /* initialize the doubleclick timer */
    dclick.tv_sec = 0;
    dclick.tv_usec = 0;

    setup_signals(licq_pipe);
    
    setup_networkwindow();
    

    if (!gUserManager.OwnerUin()) {
        if(!((regres=register_new_user())&REGISTER_RESULT_REGISTERED)) {
            return 1;
        }
    } 
    init_and_show_main_window();
    rebuild_initial_floaties();
    autoconnect();
    /* Autoconnect */
    FOR_EACH_USER_START(LOCK_R);
    if ((pUser) && (pUser->AutoSecure()) && 
            (pUser->SecureChannelSupport() == SECURE_CHANNEL_SUPPORTED)) {
        licq_daemon->icqOpenSecureChannel(pUser->Uin());
    }
    FOR_EACH_USER_END;
    if(regres&REGISTER_RESULT_SHOWSEARCH) {
        show_search_dialog();
    }
    if(regres&REGISTER_RESULT_SHOWINFO) {
        show_info_dialog_for_user(gUserManager.OwnerUin(),GENERAL_INFO_PAGE);
    }
    
    gtk_main();
    gbug("LP_Main() exit\n");
    return 0;
}


/*------------------------------------------------------------------------------
 * Exit
 *
 * This function is called to exit the plugin other then when LP_Main
 * terminates.  It is implemented internally and should not be reimplemented.
 * It takes as argument the exit value for the plugin (0 for successful
 * termination).
 *----------------------------------------------------------------------------*/
/*void 
LP_Exit(int exitcode)
{
    return;
}*/

